/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import evergoodteam.chassis.util.Reference;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1863.class})
public class RecipeManagerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/Recipe"));

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void interceptApply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo info) {
        if (Reference.RECIPES.isEmpty()) {
            return;
        }
        for (int i = 0; i < Reference.RECIPES.size(); ++i) {
            Map<String, JsonObject> DEEP = Reference.RECIPES.get(Reference.RECIPES.keySet().toArray()[i]);
            LOGGER.info("Scanning recipes from \"{}\": found {} recipe(s)", Reference.RECIPES.keySet().toArray()[i], (Object)DEEP.size());
            for (int j = 0; j < DEEP.size(); ++j) {
                String namespace = Reference.RECIPES.keySet().toArray()[i].toString();
                String path = DEEP.keySet().toArray()[j].toString();
                JsonObject json = DEEP.get(DEEP.keySet().toArray()[j]);
                if (json != null) {
                    map.put(new class_2960(namespace, path), (JsonElement)json);
                    continue;
                }
                LOGGER.info("Recipe on {} ( {}:{} ) has an invalid Json", new Object[]{DEEP.size() - 1, namespace, path});
            }
        }
    }
}

