/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.mixin;

import evergoodteam.chassis.objects.resourcepacks.ResourcePackBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3288;
import net.minecraft.class_521;
import net.minecraft.class_5369;
import net.minecraft.class_5375;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5375.class})
public class PackScreenMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/Screen");

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/gui/screen/pack/PackScreen;loadPackIcon(Lnet/minecraft/client/texture/TextureManager;Lnet/minecraft/resource/ResourcePackProfile;)Lnet/minecraft/util/Identifier;"}, cancellable=true)
    public void injectLoadPackIcon(class_1060 textureManager, class_3288 resourcePackProfile, CallbackInfoReturnable<class_2960> cir) {
        if (ResourcePackBase.NO_ICON.contains(resourcePackProfile.method_14463())) {
            cir.setReturnValue((Object)new class_2960("textures/misc/unknown_pack.png"));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/client/gui/screen/pack/PackScreen;updatePackList(Lnet/minecraft/client/gui/screen/pack/PackListWidget;Ljava/util/stream/Stream;)V"})
    private void injectUpdatePackList(class_521 widget, Stream<class_5369.class_5371> packs, CallbackInfo info) {
        ArrayList<class_521.class_4271> toRemove = new ArrayList<class_521.class_4271>();
        for (class_521.class_4271 resourcePackEntry : widget.method_25396()) {
            String name;
            class_5369.class_5371 packFromEntry = this.getPackFromEntry(resourcePackEntry);
            if (packFromEntry == null || !ResourcePackBase.HIDDEN.contains(name = packFromEntry.method_29650().getString())) continue;
            toRemove.add(resourcePackEntry);
        }
        for (class_521.class_4271 resourcePackEntry : toRemove) {
            widget.method_25396().remove(resourcePackEntry);
        }
    }

    private class_5369.class_5371 getPackFromEntry(class_521.class_4271 entry) {
        try {
            Field field = this.findField(class_521.class_4271.class, "pack", "field_19129");
            field.setAccessible(true);
            return (class_5369.class_5371)field.get(entry);
        }
        catch (Exception e) {
            LOGGER.error("Error on getting pack", (Throwable)e);
            return null;
        }
    }

    private Field findField(Class<?> aClass, String ... names) throws NoSuchFieldException {
        Field field = null;
        for (String string : names) {
            try {
                field = aClass.getDeclaredField(string);
                field.setAccessible(true);
                break;
            }
            catch (Exception e) {
                LOGGER.error("Error on finding field", (Throwable)e);
            }
        }
        if (field == null) {
            throw new NoSuchFieldException("No field matching: " + names);
        }
        return field;
    }
}

