/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.info.MethodInfo;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.property.PropertyModify;
import com.probejs.jdoc.property.PropertyParam;
import com.probejs.jdoc.property.PropertyReturns;
import com.probejs.jdoc.property.PropertyType;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentMethod
extends AbstractDocument<DocumentMethod> {
    private String name;
    private boolean isStatic;
    private boolean isAbstract;
    private PropertyType<?> returns;
    private final List<PropertyParam> params = new ArrayList<PropertyParam>();

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("name", this.name);
        object.addProperty("static", Boolean.valueOf(this.isStatic));
        object.addProperty("abstract", Boolean.valueOf(this.isAbstract));
        Serde.serializeCollection(object, "params", this.params);
        object.add("returns", (JsonElement)this.returns.serialize());
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        this.name = object.get("name").getAsString();
        if (object.has("static")) {
            this.isStatic = object.get("static").getAsBoolean();
        }
        if (object.has("abstract")) {
            this.isAbstract = object.get("abstract").getAsBoolean();
        }
        Serde.deserializeDocuments(this.params, object.get("params"));
        this.returns = (PropertyType)Serde.deserializeProperty(object.get("returns").getAsJsonObject());
    }

    public static DocumentMethod fromJava(MethodInfo info) {
        DocumentMethod document = new DocumentMethod();
        document.name = info.getName();
        document.returns = Serde.deserializeFromJavaType(info.getReturnType());
        document.isStatic = info.isStatic();
        document.isAbstract = info.isAbstract();
        info.getParams().stream().map(PropertyParam::fromJava).forEach(document.params::add);
        info.getAnnotations().stream().filter(annotation -> !(annotation instanceof RemapForJS)).map(Annotation::toString).forEach(document.builtinComments::add);
        return document;
    }

    @Override
    public DocumentMethod applyProperties() {
        DocumentMethod copy = this.copy();
        copy.findPropertiesOf(PropertyModify.class).forEach(modify -> {
            PropertyParam param = copy.params.get(modify.getOrdinal());
            copy.params.set(modify.getOrdinal(), new PropertyParam(modify.getName() != null ? modify.getName() : param.getName(), modify.getNewType() != null ? modify.getNewType() : param.getType(), param.isVarArg()));
        });
        copy.findProperty(PropertyReturns.class).ifPresent(propertyReturns -> {
            copy.returns = propertyReturns.getType();
        });
        return copy;
    }

    @Override
    public DocumentMethod copy() {
        DocumentMethod document = new DocumentMethod();
        document.name = this.name;
        document.params.addAll(this.params);
        document.returns = this.returns;
        document.properties.addAll(this.properties);
        document.isStatic = this.isStatic;
        document.isAbstract = this.isAbstract;
        return document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMethod that = (DocumentMethod)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.params, that.params) && Objects.equals(this.returns, that.returns);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.params, this.returns);
    }

    public String getName() {
        return this.name;
    }

    public List<PropertyParam> getParams() {
        return this.params;
    }

    public PropertyType<?> getReturns() {
        return this.returns;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }
}

