/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info.type;

import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoArray;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import com.probejs.info.type.TypeInfoWildcard;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class InfoTypeResolver {
    public static ITypeInfo resolveType(Type type) {
        return InfoTypeResolver.resolveType(type, t -> t);
    }

    public static ITypeInfo resolveType(Type type, Function<Type, Type> typeTransformer) {
        if (TypeInfoArray.test(type = typeTransformer.apply(type))) {
            return new TypeInfoArray(type, typeTransformer);
        }
        if (TypeInfoClass.test(type)) {
            return new TypeInfoClass(type, typeTransformer);
        }
        if (TypeInfoVariable.test(type)) {
            return new TypeInfoVariable(type, typeTransformer);
        }
        if (TypeInfoWildcard.test(type)) {
            return new TypeInfoWildcard(type, typeTransformer);
        }
        if (TypeInfoParameterized.test(type)) {
            return new TypeInfoParameterized(type, typeTransformer);
        }
        return null;
    }

    public static ITypeInfo getContainedTypeOrSelf(ITypeInfo typeInfo) {
        if (typeInfo instanceof TypeInfoParameterized) {
            TypeInfoParameterized paramType = (TypeInfoParameterized)typeInfo;
            ITypeInfo baseType = paramType.getBaseType();
            if (baseType.assignableFrom(InfoTypeResolver.resolveType(Collection.class)) && paramType.getParamTypes().size() > 0) {
                return paramType.getParamTypes().get(0);
            }
            if (baseType.assignableFrom(InfoTypeResolver.resolveType(Map.class)) && paramType.getParamTypes().size() > 1) {
                return paramType.getParamTypes().get(1);
            }
        }
        return typeInfo;
    }
}

