/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info;

import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.formatter.NameResolver;
import com.probejs.info.ConstructorInfo;
import com.probejs.info.FieldInfo;
import com.probejs.info.MethodInfo;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.SharedContextData;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassInfo {
    public static final Map<Class<?>, ClassInfo> CLASS_CACHE = new HashMap();
    public static final Map<String, ClassInfo> CLASS_NAME_CACHE = new HashMap<String, ClassInfo>();
    private final Class<?> clazzRaw;
    private final String name;
    private final int modifiers;
    private final boolean isInterface;
    private final List<ITypeInfo> parameters;
    private List<MethodInfo> methodInfo;
    private List<FieldInfo> fieldInfo;
    private List<ConstructorInfo> constructorInfo;
    private final ClassInfo superClass;
    private final List<ClassInfo> interfaces;
    private final List<Annotation> annotations;

    public static ClassInfo getOrCache(Class<?> clazz) {
        if (CLASS_CACHE.containsKey(clazz)) {
            return CLASS_CACHE.get(clazz);
        }
        ClassInfo info = new ClassInfo(clazz);
        CLASS_CACHE.put(clazz, info);
        CLASS_NAME_CACHE.put(info.getName(), info);
        return info;
    }

    private ClassInfo(Class<?> clazz) {
        this.clazzRaw = clazz;
        this.name = MethodInfo.getMappedOrDefaultClass(this.clazzRaw);
        this.modifiers = this.clazzRaw.getModifiers();
        this.isInterface = this.clazzRaw.isInterface();
        this.superClass = this.clazzRaw.getSuperclass() == Object.class || this.clazzRaw.getSuperclass() == null ? null : ClassInfo.getOrCache(this.clazzRaw.getSuperclass());
        this.interfaces = Arrays.stream(this.clazzRaw.getInterfaces()).map(ClassInfo::getOrCache).collect(Collectors.toList());
        this.parameters = Arrays.stream(this.clazzRaw.getTypeParameters()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
        this.annotations = new ArrayList<Annotation>();
        this.annotations.addAll(List.of(clazz.getAnnotations()));
        if (clazz.isAnnotationPresent(HideFromJS.class)) {
            this.methodInfo = List.of();
            this.fieldInfo = List.of();
            this.constructorInfo = List.of();
            return;
        }
        try {
            JavaMembers members = JavaMembers.lookupClass((SharedContextData)ProbeCommands.CONTEXT_DATA, clazz, clazz, (boolean)false);
            this.constructorInfo = members.getAccessibleConstructors().stream().map(ConstructorInfo::new).collect(Collectors.toList());
            this.methodInfo = members.getAccessibleMethods(false).stream().filter(m -> m.method.getDeclaringClass() == clazz || m.method.isDefault()).map(m -> new MethodInfo((JavaMembers.MethodInfo)m, clazz)).collect(Collectors.toList());
            this.fieldInfo = members.getAccessibleFields(false).stream().filter(f -> f.field.getDeclaringClass() == clazz).map(FieldInfo::new).collect(Collectors.toList());
        }
        catch (Throwable e) {
            ProbeJS.LOGGER.warn("Error occured when resolving class %s! Touching the class with KubeJS will likely to crash too!".formatted(clazz.getName()));
            this.constructorInfo = List.of();
            this.methodInfo = List.of();
            this.fieldInfo = List.of();
            NameResolver.putResolvedName(clazz, new NameResolver.ResolvedName(List.of("probejs", "internal", "NotResolved")));
        }
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public ClassInfo getSuperClass() {
        return this.superClass;
    }

    public List<ClassInfo> getInterfaces() {
        return this.interfaces;
    }

    public List<FieldInfo> getFieldInfo() {
        return this.fieldInfo;
    }

    public List<ConstructorInfo> getConstructorInfo() {
        return this.constructorInfo;
    }

    public List<MethodInfo> getMethodInfo() {
        return this.methodInfo;
    }

    public List<ITypeInfo> getParameters() {
        return this.parameters;
    }

    public boolean isEnum() {
        return this.clazzRaw.isEnum();
    }

    public Class<?> getClazzRaw() {
        return this.clazzRaw;
    }

    public String getName() {
        return this.name;
    }

    public ITypeInfo getSuperClassType() {
        return InfoTypeResolver.resolveType(this.clazzRaw.getGenericSuperclass());
    }

    public List<ITypeInfo> getInterfaceTypes() {
        return Arrays.stream(this.clazzRaw.getGenericInterfaces()).map(InfoTypeResolver::resolveType).collect(Collectors.toList());
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }
}

