/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.jdoc;

import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyUnderscored;
import com.probejs.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class FormatterType<T extends PropertyType<T>>
extends DocumentFormatter<T> {
    public static Map<Class<? extends PropertyType<?>>, Function<PropertyType<?>, FormatterType<?>>> FORMATTER_REGISTRY = new HashMap();
    protected Boolean underscored = null;

    public FormatterType(T document) {
        super(document);
        ((AbstractDocument)document).findProperty(PropertyUnderscored.class).ifPresent(property -> this.underscored(property.isUnderscored()));
    }

    @Override
    public boolean hasComment() {
        return false;
    }

    @Override
    public boolean canHide() {
        return false;
    }

    public Boolean getUnderscored() {
        return this.underscored != null && this.underscored != false;
    }

    public FormatterType<T> underscored(boolean underscored) {
        if (this.underscored == null) {
            this.underscored = underscored;
        }
        return this;
    }

    public FormatterType<T> underscored() {
        this.underscored(true);
        return this;
    }

    public static <T extends PropertyType<T>> void addFormatter(Class<T> clazz, Function<T, FormatterType<T>> constructor) {
        FORMATTER_REGISTRY.put(clazz, type -> (FormatterType)constructor.apply(type));
    }

    public static void init() {
        FormatterType.addFormatter(PropertyType.Clazz.class, Clazz::new);
        FormatterType.addFormatter(PropertyType.Native.class, Native::new);
        FormatterType.addFormatter(PropertyType.Variable.class, Variable::new);
        FormatterType.addFormatter(PropertyType.Union.class, Union::new);
        FormatterType.addFormatter(PropertyType.Intersection.class, Intersection::new);
        FormatterType.addFormatter(PropertyType.Parameterized.class, Parameterized::new);
        FormatterType.addFormatter(PropertyType.Array.class, Array::new);
        FormatterType.addFormatter(PropertyType.JSObject.class, JSObject::new);
        FormatterType.addFormatter(PropertyType.JSArray.class, JSArray::new);
    }

    public static class JSArray
    extends FormatterType<PropertyType.JSArray> {
        private final List<FormatterType<?>> types = new ArrayList();

        public JSArray(PropertyType.JSArray document) {
            super(document);
            document.getTypes().forEach(type -> this.types.add(Serde.getTypeFormatter(type)));
        }

        @Override
        public FormatterType<PropertyType.JSArray> underscored(boolean underscored) {
            this.types.forEach(type -> type.underscored(underscored));
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("[%s]".formatted(this.types.stream().map(IFormatter::formatFirst).collect(Collectors.joining(", "))));
        }
    }

    public static class JSObject
    extends FormatterType<PropertyType.JSObject> {
        private final Map<PropertyType.JSObjectKey, FormatterType<?>> keyValues = new HashMap();

        public JSObject(PropertyType.JSObject document) {
            super(document);
            document.getKeyValues().forEach((key, value) -> this.keyValues.put((PropertyType.JSObjectKey)key, Serde.getTypeFormatter(value)));
        }

        public JSObject underscored(boolean underscored) {
            this.keyValues.values().forEach(value -> value.underscored(underscored));
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of("{%s}".formatted(this.keyValues.entrySet().stream().map(pair -> {
                PropertyType.JSObjectKey key = (PropertyType.JSObjectKey)pair.getKey();
                FormatterType value = (FormatterType)pair.getValue();
                return "%s: %s".formatted(key.format(), value.formatFirst());
            }).collect(Collectors.joining(", "))));
        }
    }

    public static class Array
    extends FormatterType<PropertyType.Array> {
        private final FormatterType<?> formatter;

        public Array(PropertyType.Array type) {
            super(type);
            this.formatter = Serde.getTypeFormatter(type.getComponent());
        }

        public Array underscored(boolean underscored) {
            this.formatter.underscored(underscored);
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(this.formatter.formatFirst() + "[]");
        }
    }

    public static class Parameterized
    extends FormatterType<PropertyType.Parameterized> {
        private final FormatterType<?> base;
        private final List<FormatterType<?>> params;

        public Parameterized(PropertyType.Parameterized type) {
            super(type);
            this.base = Serde.getTypeFormatter(type.getBase());
            this.params = type.getParams().stream().map(Serde::getTypeFormatter).collect(Collectors.toList());
        }

        public Parameterized underscored(boolean underscored) {
            this.base.underscored(underscored);
            this.params.forEach(param -> param.underscored(underscored));
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            String baseString = this.base.formatFirst();
            return List.of(!baseString.equals("any") ? "%s<%s>".formatted(baseString, this.params.stream().map(IFormatter::formatFirst).collect(Collectors.joining(", "))) : "any");
        }
    }

    public static class Intersection
    extends Joint<PropertyType.Intersection> {
        public Intersection(PropertyType.Intersection type) {
            super(type);
        }
    }

    public static class Union
    extends Joint<PropertyType.Union> {
        public Union(PropertyType.Union type) {
            super(type);
        }
    }

    public static abstract class Joint<T extends PropertyType.Joint<T>>
    extends FormatterType<T> {
        private final List<FormatterType<?>> types;

        public Joint(T type) {
            super(type);
            this.types = ((PropertyType.Joint)type).getTypes().stream().map(Serde::getTypeFormatter).collect(Collectors.toList());
        }

        @Override
        public Joint<T> underscored(boolean underscored) {
            if (!((PropertyType.Joint)this.document).hasProperty(PropertyUnderscored.class)) {
                this.types.forEach(type -> type.underscored(underscored));
            }
            return this;
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + this.types.stream().map(t -> (t instanceof Joint ? "(%s)" : "%s").formatted(t.formatFirst())).collect(Collectors.joining(((PropertyType.Joint)this.document).getDelimiter())));
        }
    }

    public static class Variable
    extends Named<PropertyType.Variable> {
        public Variable(PropertyType.Variable type) {
            super(type);
        }

        public Variable underscored(boolean underscored) {
            return this;
        }
    }

    public static class Native
    extends Named<PropertyType.Native> {
        public Native(PropertyType.Native type) {
            super(type);
        }

        public Native underscored(boolean underscored) {
            return this;
        }
    }

    public static class Clazz
    extends Named<PropertyType.Clazz> {
        public Clazz(PropertyType.Clazz type) {
            super(type);
        }

        public Clazz underscored(boolean underscored) {
            if (!NameResolver.resolvedPrimitives.contains(((PropertyType.Clazz)this.document).getClassName())) {
                super.underscored(underscored);
            }
            return this;
        }
    }

    public static abstract class Named<T extends PropertyType.Named<T>>
    extends FormatterType<T> {
        public Named(T type) {
            super(type);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + ((PropertyType.Named)this.document).getTypeName() + (this.getUnderscored() != false ? "_" : ""));
        }
    }
}

