/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter.formatter.jdoc;

import com.probejs.formatter.formatter.IFormatter;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.property.PropertyComment;
import java.util.ArrayList;
import java.util.List;

public abstract class DocumentFormatter<T extends AbstractDocument<T>>
implements IFormatter {
    protected final T document;

    public DocumentFormatter(T document) {
        this.document = document;
    }

    protected abstract List<String> formatDocument(Integer var1, Integer var2);

    public boolean hasComment() {
        return true;
    }

    public boolean canHide() {
        return true;
    }

    @Override
    public final List<String> format(Integer indent, Integer stepIndent) {
        if (((AbstractDocument)this.document).isHidden() && this.canHide()) {
            return List.of();
        }
        ArrayList<String> lines = new ArrayList<String>();
        PropertyComment comments = ((AbstractDocument)this.document).getMergedComment();
        if (!comments.isEmpty() && this.hasComment()) {
            lines.addAll(comments.formatLines(indent));
        }
        lines.addAll(this.formatDocument(indent, stepIndent));
        return lines;
    }
}

