/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.formatter;

import com.google.gson.Gson;
import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.compiler.SpecialCompiler;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.IFormatter;
import com.probejs.formatter.formatter.jdoc.FormatterClass;
import com.probejs.formatter.formatter.jdoc.FormatterMethod;
import com.probejs.formatter.formatter.special.FormatterRegistry;
import com.probejs.info.ClassInfo;
import com.probejs.info.MethodInfo;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentMethod;
import dev.latvian.mods.rhino.util.EnumTypeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class SpecialTypes {
    public static Set<Class<?>> skippedSpecials = new HashSet();

    private static boolean isFunctionalInterface(Class<?> clazz) {
        if (clazz.isAnnotationPresent(FunctionalInterface.class)) {
            return true;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            if (!SpecialTypes.isFunctionalInterface(superInterface)) continue;
            return true;
        }
        return false;
    }

    public static void processFunctionalInterfaces(Set<Class<?>> globalClasses) {
        for (Class<?> clazz : globalClasses) {
            ClassInfo info;
            if (!clazz.isInterface() || skippedSpecials.contains(clazz) || !SpecialTypes.isFunctionalInterface(clazz) || (info = ClassInfo.getOrCache(clazz)).getMethodInfo().stream().filter(MethodInfo::isAbstract).count() != 1L) continue;
            FormatterClass.SPECIAL_FORMATTER_REGISTRY.put((Object)info.getName(), document -> (indent, stepIndent) -> {
                DocumentMethod documentMethod = document.getMethods().stream().filter(DocumentMethod::isAbstract).map(DocumentMethod::applyProperties).findFirst().get();
                return List.of("((%s)=>%s)".formatted(documentMethod.getParams().stream().map(FormatterMethod.FormatterParam::new).map(IFormatter::formatFirst).collect(Collectors.joining(", ")), Serde.getTypeFormatter(documentMethod.getReturns()).underscored().formatFirst()));
            });
        }
    }

    public static void processEnums(Set<Class<?>> globalClasses) {
        for (Class<?> clazz : globalClasses) {
            if (!clazz.isEnum()) continue;
            try {
                EnumTypeWrapper wrapper = EnumTypeWrapper.get(clazz);
                NameResolver.putSpecialAssignments(clazz, () -> wrapper.nameValues.keySet().stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).collect(Collectors.toList()));
            }
            catch (Exception ignored) {
                ProbeJS.LOGGER.warn("Failed to process enum: %s".formatted(clazz.getName()));
            }
        }
    }

    public static <T> void assignRegistry(Class<T> clazz, class_5321<class_2378<T>> registry) {
        SpecialCompiler.specialCompilers.add(new FormatterRegistry<T>(registry, clazz));
        List<String> remappedName = Arrays.stream(MethodInfo.getMappedOrDefaultClass(clazz).split("\\.")).toList();
        NameResolver.putSpecialAssignments(clazz, () -> List.of("Special.%s".formatted(remappedName.get(remappedName.size() - 1))));
    }

    private static List<Class<?>> getParentInterfaces(List<Class<?>> putative, Class<?> o) {
        ArrayList result = new ArrayList();
        for (Class<?> clazz : putative) {
            if (!clazz.isAssignableFrom(o)) {
                result.addAll(SpecialTypes.getParentInterfaces(List.of(clazz.getInterfaces()), o));
                continue;
            }
            result.add(clazz);
        }
        return result;
    }

    public static <T> void assignRegistries() {
        ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().forEach(entry -> {
            class_5321 key = entry.comp_350();
            class_2378 registry = entry.comp_351();
            Class<Object> putativeParent = null;
            for (Object o : registry) {
                if (putativeParent == null) {
                    putativeParent = o.getClass();
                    continue;
                }
                while (!putativeParent.isAssignableFrom(o.getClass())) {
                    putativeParent = putativeParent.getSuperclass();
                }
            }
            if (putativeParent == null) {
                return;
            }
            while (putativeParent.isSynthetic()) {
                putativeParent = putativeParent.getSuperclass();
            }
            if (putativeParent == Object.class) {
                List<Class<?>> putativeInterfaces = new ArrayList();
                for (Object o : registry) {
                    if (putativeInterfaces.isEmpty()) {
                        putativeInterfaces.addAll(List.of(o.getClass().getInterfaces()));
                        continue;
                    }
                    putativeInterfaces = SpecialTypes.getParentInterfaces(putativeInterfaces, o.getClass());
                }
                if (!putativeInterfaces.isEmpty()) {
                    putativeParent = (Class)putativeInterfaces.get(0);
                }
            }
            SpecialTypes.assignRegistry(putativeParent, key);
        });
    }
}

