/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.formatter.NameResolver;
import com.probejs.jdoc.document.DocumentClass;
import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.class_1078;
import net.minecraft.class_2477;

public class SchemaCompiler {
    public static JsonObject toLangSchema() {
        JsonObject properties = new JsonObject();
        class_2477 class_24772 = class_2477.method_10517();
        if (class_24772 instanceof class_1078) {
            class_1078 clientLanguage = (class_1078)class_24772;
            clientLanguage.field_5330.entrySet().stream().filter(e -> {
                String s = (String)e.getKey();
                return !s.startsWith("_") && !s.startsWith("$");
            }).forEach(entry -> {
                JsonObject typeString = new JsonObject();
                typeString.addProperty("type", "string");
                typeString.addProperty("description", (String)entry.getValue());
                properties.add((String)entry.getKey(), (JsonElement)typeString);
            });
        }
        JsonObject schema = new JsonObject();
        schema.addProperty("type", "object");
        schema.add("properties", (JsonElement)properties);
        return schema;
    }

    public static JsonObject toDocSchema(List<DocumentClass> mergedDocs) {
        JsonObject schema = new JsonObject();
        JsonArray enums = new JsonArray();
        mergedDocs.stream().map(DocumentClass::getName).forEach(arg_0 -> ((JsonArray)enums).add(arg_0));
        NameResolver.resolvedPrimitives.forEach(arg_0 -> ((JsonArray)enums).add(arg_0));
        JsonObject type = new JsonObject();
        type.add("enum", (JsonElement)enums);
        type.addProperty("type", "string");
        JsonObject definition = new JsonObject();
        definition.add("typeClassname", (JsonElement)type);
        schema.add("definitions", (JsonElement)definition);
        return schema;
    }

    public static void compile(List<DocumentClass> mergedDocs) throws IOException {
        Path schemaLang = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.lang-schema.json");
        BufferedWriter writerLang = Files.newBufferedWriter(schemaLang, new OpenOption[0]);
        writerLang.write(ProbeJS.GSON.toJson((JsonElement)SchemaCompiler.toLangSchema()));
        writerLang.flush();
        Path schemaClassNames = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.class-definitions.json");
        BufferedWriter writerClazz = Files.newBufferedWriter(schemaClassNames, new OpenOption[0]);
        writerClazz.write(ProbeJS.GSON.toJson((JsonElement)SchemaCompiler.toDocSchema(mergedDocs)));
        writerClazz.flush();
        Path schemaDoc = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.doc-schema.json");
        Platform.getMod((String)"probejs").findResource(new String[]{"probe.doc-schema.json"}).ifPresent(path -> {
            try {
                Files.copy(path, schemaDoc, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

