/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.compiler;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.compiler.DummyBindingEvent;
import com.probejs.compiler.RawCompiler;
import com.probejs.compiler.RegistryCompiler;
import com.probejs.compiler.SchemaCompiler;
import com.probejs.compiler.SpecialCompiler;
import com.probejs.event.CapturedEvent;
import com.probejs.formatter.ClassResolver;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.SpecialTypes;
import com.probejs.formatter.formatter.FormatterNamespace;
import com.probejs.formatter.formatter.jdoc.FormatterClass;
import com.probejs.formatter.formatter.jdoc.FormatterType;
import com.probejs.info.Walker;
import com.probejs.jdoc.Manager;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.plugin.CapturedClasses;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;

public class DocCompiler {
    public static void compileGlobal(Collection<DocumentClass> globalClasses) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("globals.d.ts"), new OpenOption[0]);
        ArrayListMultimap namespaces = ArrayListMultimap.create();
        for (DocumentClass clazz : globalClasses) {
            FormatterClass formatter = new FormatterClass(clazz);
            NameResolver.ResolvedName resolvedName = NameResolver.getResolvedName(clazz.getName());
            if (resolvedName.getNamespace().isEmpty()) {
                writer.write(formatter.formatString(0, 4) + "\n");
                if (!clazz.isInterface()) continue;
                writer.write("declare const %s: %s;\n".formatted(resolvedName.getFullName(), resolvedName.getFullName()));
                continue;
            }
            clazz.getConstructors().forEach(constructor -> constructor.addProperty(new PropertyComment("Internal constructor, this means that it's not valid unless you use `java()`.")));
            namespaces.put((Object)resolvedName.getNamespace(), (Object)formatter.setInternal(true));
        }
        namespaces.putAll((Object)"Special", SpecialCompiler.compileSpecial());
        for (String key : namespaces.keySet()) {
            Collection formatters = namespaces.get((Object)key);
            FormatterNamespace namespace = new FormatterNamespace(key, formatters);
            writer.write(namespace.formatString(0, 4) + "\n");
        }
        writer.flush();
    }

    private static String formatJavaType(DocumentClass c) {
        FormatterType.Clazz formatter = new FormatterType.Clazz(new PropertyType.Clazz(c.getName()));
        if (c.isInterface()) {
            return "declare function java(name: %s): %s;\n".formatted(ProbeJS.GSON.toJson((Object)c.getName()), formatter.formatFirst());
        }
        return "declare function java(name: %s): typeof %s;\n".formatted(ProbeJS.GSON.toJson((Object)c.getName()), formatter.formatFirst());
    }

    public static void compileJava(Collection<DocumentClass> globalClasses) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("java.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (DocumentClass c : globalClasses) {
            if (!ServerScriptManager.instance.scriptManager.isClassAllowed(c.getName())) continue;
            writer.write(DocCompiler.formatJavaType(c));
        }
        writer.flush();
    }

    public static Set<Class<?>> readCachedClasses(String fileName) throws IOException {
        HashSet cachedClasses = new HashSet();
        Path cachedClassesPath = ProbePaths.CACHE.resolve(fileName);
        if (Files.exists(cachedClassesPath, new LinkOption[0])) {
            try {
                List cachedList = (List)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedClassesPath), List.class);
                cachedList.forEach(c -> {
                    try {
                        Class<?> clazz = Class.forName((String)c);
                        cachedClasses.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(c));
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedClasses;
    }

    public static void writeCachedClasses(String fileName, Set<Class<?>> javaClasses) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(ProbePaths.CACHE.resolve(fileName), new OpenOption[0]);
        JsonArray outJson = new JsonArray();
        for (Class<?> clazz : javaClasses) {
            outJson.add(clazz.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static Map<String, CapturedEvent> readCachedEvents(String fileName) throws IOException {
        HashMap<String, CapturedEvent> cachedEvents = new HashMap<String, CapturedEvent>();
        Path cachedEventPath = ProbePaths.CACHE.resolve(fileName);
        if (Files.exists(cachedEventPath, new LinkOption[0])) {
            try {
                JsonObject cachedMap = (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedEventPath), JsonObject.class);
                for (Map.Entry entry : cachedMap.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    CapturedEvent.fromJson(value.getAsJsonObject()).ifPresent(event -> cachedEvents.put(key, (CapturedEvent)event));
                }
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedEvents;
    }

    public static Map<String, Class<?>> readCachedForgeEvents(String fileName) throws IOException {
        HashMap cachedEvents = new HashMap();
        Path cachedEventPath = ProbePaths.CACHE.resolve(fileName);
        if (Files.exists(cachedEventPath, new LinkOption[0])) {
            try {
                Map cachedMap = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedEventPath), Map.class);
                cachedMap.forEach((k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        try {
                            Class<?> clazz = Class.forName((String)v);
                            if (EventJS.class.isAssignableFrom(clazz)) {
                                cachedEvents.put((String)k, clazz);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(v));
                        }
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedEvents;
    }

    public static void writeCachedEvents(String fileName, Map<String, CapturedEvent> events) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(ProbePaths.CACHE.resolve(fileName), new OpenOption[0]);
        JsonObject outJson = new JsonObject();
        for (Map.Entry<String, CapturedEvent> entry : events.entrySet()) {
            String eventName = entry.getKey();
            CapturedEvent eventClass = entry.getValue();
            outJson.add(eventName, (JsonElement)eventClass.toJson());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static void writeCachedForgeEvents(String fileName, Map<String, Class<?>> events) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(ProbePaths.CACHE.resolve(fileName), new OpenOption[0]);
        JsonObject outJson = new JsonObject();
        for (Map.Entry<String, Class<?>> entry : events.entrySet()) {
            String eventName = entry.getKey();
            Class<?> eventClass = entry.getValue();
            outJson.addProperty(eventName, eventClass.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.flush();
    }

    public static Set<Class<?>> fetchClasses(Map<class_2960, RecipeTypeJS> typeMap, DummyBindingEvent bindingEvent, Set<Class<?>> cachedClasses) {
        HashSet touchableClasses = new HashSet(bindingEvent.getClassDumpMap().values());
        touchableClasses.addAll(cachedClasses);
        touchableClasses.addAll(typeMap.values().stream().map(recipeTypeJS -> ((RecipeJS)recipeTypeJS.factory.get()).getClass()).toList());
        bindingEvent.getConstantDumpMap().values().stream().map(DummyBindingEvent::getConstantClassRecursive).forEach(touchableClasses::addAll);
        touchableClasses.addAll(CapturedClasses.getCapturedEvents().values().stream().map(CapturedEvent::getCaptured).toList());
        touchableClasses.addAll(CapturedClasses.getCapturedRawEvents().values());
        touchableClasses.addAll(CapturedClasses.getCapturedJavaClasses());
        Walker walker = new Walker(touchableClasses);
        return walker.walk();
    }

    public static String formatMaybeParameterized(Class<?> clazz) {
        if (clazz.getTypeParameters().length == 0) {
            return new FormatterType.Clazz(new PropertyType.Clazz(clazz.getName())).formatFirst();
        }
        return new FormatterType.Parameterized(new PropertyType.Parameterized(new PropertyType.Clazz(clazz.getName()), Collections.nCopies(clazz.getTypeParameters().length, new PropertyType.Clazz(Object.class.getName())))).formatFirst();
    }

    public static String formatMaybeParameterized(DocumentClass clazz) {
        if (clazz.getGenerics().isEmpty()) {
            return new FormatterType.Clazz(new PropertyType.Clazz(clazz.getName())).formatFirst();
        }
        return new FormatterType.Parameterized(new PropertyType.Parameterized(new PropertyType.Clazz(clazz.getName()), Collections.nCopies(clazz.getGenerics().size(), new PropertyType.Clazz(Object.class.getName())))).formatFirst();
    }

    public static void compileEvents(Map<String, CapturedEvent> cachedEvents, Map<String, Class<?>> cachedForgeEvents, Map<String, DocumentClass> globalClasses) throws IOException {
        Class<? extends EventJS> event;
        String id;
        cachedEvents.putAll(CapturedClasses.capturedEvents);
        cachedForgeEvents.putAll(CapturedClasses.capturedRawEvents);
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("events.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        writer.write("/// <reference path=\"./registries.d.ts\" />\n");
        HashSet<CapturedEvent> wildcards = new HashSet<CapturedEvent>();
        for (Map.Entry<String, CapturedEvent> entry : cachedEvents.entrySet()) {
            DocumentClass clazz;
            CapturedEvent capturedEvent = entry.getValue();
            id = capturedEvent.getId();
            event = capturedEvent.getCaptured();
            String sub = capturedEvent.getSub();
            String name = id + (String)(sub == null ? "" : "." + sub);
            if (capturedEvent.hasSub()) {
                wildcards.add(capturedEvent);
            }
            if ((clazz = globalClasses.get(event.getName())) == null) continue;
            PropertyComment mergedComment = clazz.getMergedComment();
            mergedComment.getLines().addAll(DocCompiler.getAdditionalEventComments(capturedEvent));
            writer.write(String.join((CharSequence)"\n", mergedComment.formatLines(0)) + "\n");
            writer.write("declare function onEvent(name: %s, handler: (event: %s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)name), DocCompiler.formatMaybeParameterized(clazz)));
        }
        HashSet<String> writtenWildcards = new HashSet<String>();
        for (CapturedEvent capturedEvent : wildcards) {
            id = ProbeJS.GSON.toJson((Object)capturedEvent.getId());
            if (writtenWildcards.contains(id = id.substring(1, id.length() - 1))) continue;
            writtenWildcards.add(id);
            event = capturedEvent.getCaptured();
            DocumentClass clazz = globalClasses.get(event.getName());
            if (clazz == null) continue;
            PropertyComment mergedComment = clazz.getMergedComment();
            mergedComment.getLines().addAll(DocCompiler.getAdditionalEventComments(capturedEvent));
            writer.write("declare function onEvent(name: `%s`, handler: (event: %s) => void);\n".formatted(id, DocCompiler.formatMaybeParameterized(clazz)));
        }
        for (Map.Entry entry : cachedForgeEvents.entrySet()) {
            String name = (String)entry.getKey();
            event = (Class<? extends EventJS>)entry.getValue();
            writer.write("declare function onForgeEvent(name: %s, handler: (event: %s) => void);\n".formatted(ProbeJS.GSON.toJson((Object)name), DocCompiler.formatMaybeParameterized(event)));
        }
        RegistryCompiler.compileEventRegistries(writer);
        writer.flush();
    }

    public static void compileConstants(DummyBindingEvent bindingEvent) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("constants.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, Object> entry : bindingEvent.getConstantDumpMap().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            String resolved = NameResolver.formatValue(value);
            writer.write("declare const %s: %s;\n".formatted(name, Objects.requireNonNull(Serde.getValueFormatter(Serde.getValueProperty(value))).formatFirst()));
        }
        writer.flush();
    }

    public static void compileJSConfig() throws IOException {
        DocCompiler.writeMergedConfig(KubeJSPaths.DIRECTORY.resolve("jsconfig.json"), "{\n    \"compilerOptions\": {\n        \"lib\": [\"ES5\", \"ES2015\"],\n        \"typeRoots\": [\"./probe/generated\", \"./probe/user\"],\n        \"target\": \"ES2015\"\n    }\n}");
    }

    public static void compileVSCodeConfig() throws IOException {
        DocCompiler.writeMergedConfig(ProbePaths.WORKSPACE_SETTINGS.resolve("settings.json"), "{\n    \"json.schemas\": [\n            {\n                \"fileMatch\": [\n                    \"/lang/*.json\"\n                ],\n                \"url\": \"./.vscode/probe.lang-schema.json\"\n            },\n            {\n                \"fileMatch\": [\n                    \"/probe/docs/*.json\"\n                ],\n                \"url\": \"./.vscode/probe.doc-schema.json\"\n            }\n    ]\n}\n");
    }

    private static List<String> getAdditionalEventComments(CapturedEvent event) {
        ArrayList<String> comments = new ArrayList<String>();
        if (!event.getScriptTypes().isEmpty()) {
            comments.add("");
            comments.add("The event fires on: %s.".formatted(event.getFormattedTypeString()));
        }
        comments.add("");
        comments.add("The event is %scancellable.".formatted(event.isCancellable() ? "" : "**not** "));
        return comments;
    }

    private static void writeMergedConfig(Path path, String config) throws IOException {
        JsonObject read;
        JsonObject updates = (JsonObject)ProbeJS.GSON.fromJson(config, JsonObject.class);
        JsonObject jsonObject = read = Files.exists(path, new LinkOption[0]) ? (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(path), JsonObject.class) : new JsonObject();
        if (read == null) {
            read = new JsonObject();
        }
        JsonObject original = read;
        updates.entrySet().forEach(entry -> original.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));
        jsonWriter.setIndent("    ");
        ProbeJS.GSON_WRITER.toJson((Object)original, JsonObject.class, jsonWriter);
        jsonWriter.flush();
    }

    private static void exportClasses(List<DocumentClass> documents, Path path) throws IOException {
        JsonArray classes = new JsonArray();
        documents.forEach(document -> classes.add((JsonElement)document.serialize()));
        BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
        JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)writer);
        jsonWriter.setIndent("    ");
        ProbeJS.GSON_WRITER.toJson((Object)classes, JsonArray.class, jsonWriter);
        jsonWriter.flush();
    }

    private static void exportSerializedClasses(List<DocumentClass> documents, List<DocumentClass> mergedDocuments) throws IOException {
        DocCompiler.exportClasses(documents, ProbePaths.CACHE.resolve("javaClasses.json"));
        DocCompiler.exportClasses(mergedDocuments, ProbePaths.CACHE.resolve("mergedClasses.json"));
    }

    public static void compile() throws IOException {
        DummyBindingEvent bindingEvent = new DummyBindingEvent(ServerScriptManager.instance.scriptManager);
        HashMap<class_2960, RecipeTypeJS> typeMap = new HashMap<class_2960, RecipeTypeJS>();
        RegisterRecipeHandlersEvent recipeEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(recipeEvent));
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addBindings((BindingsEvent)bindingEvent));
        Map<String, CapturedEvent> cachedEvents = DocCompiler.readCachedEvents("cachedEvents.json");
        Map<String, Class<?>> cachedForgeEvents = DocCompiler.readCachedForgeEvents("cachedForgeEvents.json");
        Set<Class<?>> cachedJavaClasses = DocCompiler.readCachedClasses("cachedJava.json");
        HashSet cachedClasses = new HashSet();
        cachedEvents.values().forEach(v -> cachedClasses.add(v.getCaptured()));
        cachedClasses.addAll(cachedForgeEvents.values());
        cachedClasses.addAll(cachedJavaClasses);
        cachedClasses.addAll(RegistryCompiler.getRegistryClasses());
        Set<Class<?>> globalClasses = DocCompiler.fetchClasses(typeMap, bindingEvent, cachedClasses);
        globalClasses.removeIf(c -> ClassResolver.skipped.contains(c));
        bindingEvent.getClassDumpMap().forEach((s, c) -> NameResolver.putResolvedName(c, s));
        SpecialTypes.processFunctionalInterfaces(globalClasses);
        SpecialTypes.processEnums(globalClasses);
        List<DocumentClass> documents = Manager.loadJavaClasses(globalClasses);
        Manager.downloadDocs();
        List<DocumentClass> modDocs = Manager.loadModDocuments();
        List<DocumentClass> fetchedDocs = Manager.loadFetchedClassDoc();
        List<DocumentClass> userDocs = Manager.loadUserDocuments();
        Map<String, DocumentClass> mergedDocsMap = Manager.mergeDocuments(documents, fetchedDocs, modDocs, userDocs);
        List<DocumentClass> mergedDocs = mergedDocsMap.values().stream().toList();
        NameResolver.priorSortClasses(mergedDocs).forEach(NameResolver::resolveName);
        DocCompiler.exportSerializedClasses(documents, mergedDocs);
        DocCompiler.compileGlobal(mergedDocs);
        RegistryCompiler.compileRegistries();
        DocCompiler.compileEvents(cachedEvents, cachedForgeEvents, mergedDocsMap);
        DocCompiler.compileConstants(bindingEvent);
        DocCompiler.compileJava(documents);
        DocCompiler.compileAdditionalTypeNames();
        RawCompiler.compileRaw();
        DocCompiler.compileJSConfig();
        DocCompiler.compileVSCodeConfig();
        cachedJavaClasses.addAll(CapturedClasses.capturedJavaClasses);
        SchemaCompiler.compile(mergedDocs);
        DocCompiler.writeCachedEvents("cachedEvents.json", cachedEvents);
        DocCompiler.writeCachedForgeEvents("cachedForgedEvents.json", cachedForgeEvents);
        DocCompiler.writeCachedClasses("cachedJava.json", cachedJavaClasses);
    }

    public static void compileAdditionalTypeNames() throws IOException {
        Path path = ProbePaths.GENERATED.resolve("names.d.ts");
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("names.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, List<NameResolver.ResolvedName>> entry : NameResolver.resolvedNames.entrySet()) {
            List<NameResolver.ResolvedName> exportedNames = entry.getValue();
            if (exportedNames.size() <= 1) continue;
            for (int i = 1; i < exportedNames.size(); ++i) {
                writer.write("const %s: typeof %s\n".formatted(exportedNames.get(i).getLastName(), exportedNames.get(0).getLastName()));
            }
        }
        writer.flush();
    }
}

