/*
 * Decompiled with CFR 0.152.
 */
package com.probejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.compiler.DocCompiler;
import com.probejs.compiler.SnippetCompiler;
import com.probejs.formatter.ClassResolver;
import com.probejs.formatter.NameResolver;
import com.probejs.formatter.formatter.jdoc.FormatterClass;
import com.probejs.info.ClassInfo;
import com.probejs.jdoc.document.DocumentClass;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.SharedContextData;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.util.Remapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;

public class ProbeCommands {
    public static Context CONTEXT;
    public static Scriptable SCOPE;
    public static SharedContextData CONTEXT_DATA;
    public static class_3218 COMMAND_LEVEL;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"probejs").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires(source -> source.method_9211().method_3724() && source.method_9259(2))).executes(context -> {
            COMMAND_LEVEL = ((class_2168)context.getSource()).method_9225();
            Instant start = Instant.now();
            try {
                if (CONTEXT == null) {
                    CONTEXT = Context.enterWithNewFactory();
                    SCOPE = CONTEXT.initStandardObjects();
                    CONTEXT_DATA = SharedContextData.get((Scriptable)SCOPE);
                    CONTEXT_DATA.setExtraProperty("Type", (Object)ScriptType.SERVER);
                    CONTEXT_DATA.setExtraProperty("Console", (Object)ScriptType.SERVER.console);
                    CONTEXT_DATA.setRemapper((Remapper)RemappingHelper.getMinecraftRemapper());
                }
                SnippetCompiler.compile();
                ClassResolver.init();
                NameResolver.init();
                DocCompiler.compile();
            }
            catch (Exception e) {
                ProbeJS.LOGGER.error(e.getMessage());
                for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                    ProbeJS.LOGGER.error((Object)stackTraceElement);
                }
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Uncaught exception happened in wrapper, please report to the Github issue with complete latest.log."), false);
            }
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            long sub = TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("ProbeJS typing generation finished in %s.%03ds.".formatted(duration.getSeconds(), sub)), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear_cache").requires(source -> source.method_9211().method_3724())).executes(context -> {
            for (File file : Objects.requireNonNull(ProbePaths.CACHE.toFile().listFiles())) {
                if (!file.isFile()) continue;
                if (file.delete()) {
                    ProbeJS.LOGGER.info("Removed %s".formatted(file.getName()));
                    continue;
                }
                ProbeJS.LOGGER.info("Failed to remove %s".formatted(file.getName()));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"configure").requires(source -> source.method_9211().method_3724())).then(class_2170.method_9247((String)"toggle_bean").executes(context -> {
            ProbeConfig.INSTANCE.dumpMethod = !ProbeConfig.INSTANCE.dumpMethod;
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Keep method while beaning set to: %s".formatted(ProbeConfig.INSTANCE.dumpMethod)), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(class_2170.method_9247((String)"toggle_aggressive").executes(context -> {
            ProbeConfig.INSTANCE.noAggressiveProbing = !ProbeConfig.INSTANCE.noAggressiveProbing;
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Aggressive mode is now: %s".formatted(ProbeConfig.INSTANCE.noAggressiveProbing ? "disabled" : "enabled")), false);
            ProbeConfig.INSTANCE.save();
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Changes will be applied next time you start the game."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"toggle_snippet_order").executes(context -> {
            ProbeConfig.INSTANCE.vanillaOrder = !ProbeConfig.INSTANCE.vanillaOrder;
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("In snippets, which will appear first: %s".formatted(ProbeConfig.INSTANCE.vanillaOrder ? "mod_id" : "member_type")), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        }))).then(class_2170.method_9247((String)"toggle_classname_snippets").executes(context -> {
            ProbeConfig.INSTANCE.exportClassNames = !ProbeConfig.INSTANCE.exportClassNames;
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Export class name as snippets set to: %s".formatted(ProbeConfig.INSTANCE.exportClassNames)), false);
            ProbeConfig.INSTANCE.save();
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(source -> source.method_9211().method_3724())).then(class_2170.method_9244((String)"className", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9264(ClassInfo.CLASS_CACHE.values().stream().map(ClassInfo::getName), (SuggestionsBuilder)builder)).executes(ctx -> {
            String className = StringArgumentType.getString((CommandContext)ctx, (String)"className");
            ClassInfo info = ClassInfo.CLASS_NAME_CACHE.get(className);
            String[] nameParts = info.getName().split("\\.");
            JsonObject document = DocumentClass.fromJava(info).serialize();
            JsonArray outArray = new JsonArray();
            outArray.add((JsonElement)document);
            try {
                BufferedWriter writer = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve(nameParts[nameParts.length - 1] + ".json"), new OpenOption[0]);
                JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)writer);
                jsonWriter.setIndent("    ");
                ProbeJS.GSON_WRITER.toJson((Object)outArray, JsonArray.class, jsonWriter);
                jsonWriter.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"test").requires(source -> true)).executes(context -> {
            try {
                DocumentClass document = DocumentClass.fromJava(ClassInfo.getOrCache(IngredientJS.class));
                ProbeJS.LOGGER.info((Object)document.isAbstract());
                ProbeJS.LOGGER.info(ProbeJS.GSON.toJson((JsonElement)document.serialize()));
                ProbeJS.LOGGER.info(String.join((CharSequence)"\n", new FormatterClass(document).format(0, 4)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 1;
        })));
    }
}

