/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.api.event;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public final class HarvestWithEaseEvents {
    public static final class_2960 PRIORITY_PHASE = new class_2960("harvestwithease", "priority");
    public static final class_2960 DEFERRED_PHASE = new class_2960("harvestwithease", "deferred");
    public static final Event<HarvestCheck> HARVEST_CHECK = EventFactory.createWithPhases(HarvestCheck.class, listeners -> (world, crop, pos, player, hand, first, event) -> {
        for (HarvestCheck listener : listeners) {
            event.setCanHarvest(listener.check(world, crop, pos, player, hand, first, event));
            if (!event.isCanceled()) continue;
            return event.canHarvest();
        }
        return event.canHarvest();
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});
    public static final Event<BeforeHarvest> BEFORE_HARVEST = EventFactory.createWithPhases(BeforeHarvest.class, listeners -> (world, crop, pos, face, result, player, hand, first) -> {
        for (BeforeHarvest listener : listeners) {
            listener.beforeHarvest(world, crop, pos, face, result, player, hand, first);
        }
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});
    public static final Event<HarvestDrops> HARVEST_DROPS = EventFactory.createWithPhases(HarvestDrops.class, listeners -> (world, crop, pos, face, result, player, hand, first, event) -> {
        for (HarvestDrops listener : listeners) {
            event.setDrops(listener.getDrops(world, crop, pos, face, result, player, hand, first, event));
            if (!event.isCanceled()) continue;
            return event.getDrops();
        }
        return event.getDrops();
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});
    public static final Event<AfterHarvest> AFTER_HARVEST = EventFactory.createWithPhases(AfterHarvest.class, listeners -> (world, crop, pos, face, result, player, hand, first) -> {
        for (AfterHarvest listener : listeners) {
            listener.afterHarvest(world, crop, pos, face, result, player, hand, first);
        }
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});

    private HarvestWithEaseEvents() {
    }

    @FunctionalInterface
    public static interface AfterHarvest {
        public void afterHarvest(class_3218 var1, class_2680 var2, class_2338 var3, class_2350 var4, class_3965 var5, class_3222 var6, class_1268 var7, boolean var8);
    }

    @FunctionalInterface
    public static interface HarvestDrops {
        public List<class_1799> getDrops(class_3218 var1, class_2680 var2, class_2338 var3, class_2350 var4, class_3965 var5, class_3222 var6, class_1268 var7, boolean var8, HarvestDropsEvent var9);
    }

    public static class HarvestDropsEvent
    extends HarvestWithEaseEvent {
        private List<class_1799> drops;
        private final List<class_1799> defaultDrops;

        public HarvestDropsEvent(class_3218 world, class_2680 crop, class_2338 pos, class_3222 player, class_1268 hand) {
            this.defaultDrops = this.initDrops(world, crop, pos, player, hand);
            this.drops = new ArrayList<class_1799>(this.defaultDrops.stream().map(item -> item.method_7972()).toList());
        }

        public boolean haveDropsChanged() {
            if (this.defaultDrops.size() == this.drops.size()) {
                for (int c = 0; c < this.defaultDrops.size(); ++c) {
                    if (class_1799.method_7973((class_1799)this.defaultDrops.get(c), (class_1799)this.drops.get(c))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public List<class_1799> getDrops() {
            return this.drops;
        }

        @Override
        public boolean isCancelable() {
            return true;
        }

        private List<class_1799> initDrops(class_3218 world, class_2680 crop, class_2338 pos, class_3222 player, class_1268 hand) {
            List drops = class_2248.method_9609((class_2680)crop, (class_3218)world, (class_2338)pos, (class_2586)(crop.method_31709() ? world.method_8321(pos) : null), (class_1297)player, (class_1799)player.method_5998(hand));
            boolean seedRemoved = false;
            for (class_1799 stack : drops) {
                if (seedRemoved || !stack.method_7929(crop.method_26204().method_9574((class_1922)world, pos, crop))) continue;
                stack.method_7934(1);
                seedRemoved = true;
            }
            return drops;
        }

        private void setDrops(List<class_1799> drops) {
            if (drops != null) {
                this.drops = drops;
            }
        }
    }

    @FunctionalInterface
    public static interface BeforeHarvest {
        public void beforeHarvest(class_3218 var1, class_2680 var2, class_2338 var3, class_2350 var4, class_3965 var5, class_3222 var6, class_1268 var7, boolean var8);
    }

    @FunctionalInterface
    public static interface HarvestCheck {
        public boolean check(class_1937 var1, class_2680 var2, class_2338 var3, class_1657 var4, class_1268 var5, boolean var6, HarvestCheckEvent var7);
    }

    public static class HarvestCheckEvent
    extends HarvestWithEaseEvent {
        public boolean canHarvest = true;

        public boolean canHarvest() {
            return this.canHarvest;
        }

        @Override
        public boolean isCancelable() {
            return true;
        }

        private void setCanHarvest(boolean canHarvest) {
            this.canHarvest = canHarvest;
        }
    }

    private static abstract class HarvestWithEaseEvent {
        private boolean isCanceled = false;

        private HarvestWithEaseEvent() {
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setCanceled(boolean cancel) {
            if (!this.isCancelable()) {
                throw new UnsupportedOperationException("Attempted to call setCanceled() on a non-cancelable event of type: " + this.getClass().getCanonicalName());
            }
            this.isCanceled = cancel;
        }

        public abstract boolean isCancelable();
    }
}

