/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.api;

import crystalspider.harvestwithease.config.ModConfig;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HarvestWithEaseAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"harvestwithease");

    private HarvestWithEaseAPI() {
    }

    public static boolean isCrop(class_2248 block) {
        return block instanceof class_2302 || block instanceof class_2421 || block instanceof class_2282 || ModConfig.getCrops().contains(HarvestWithEaseAPI.getKey(block));
    }

    public static class_2758 getAge(class_2680 blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (class_2758)blockState.method_28501().stream().filter(property -> property.method_11899().equals("age")).findFirst().orElseThrow();
    }

    public static boolean isMature(class_2680 blockState, class_2758 age) {
        return blockState.method_28500((class_2769)age).orElse(0) >= (Integer)Collections.max(age.method_11898());
    }

    public static boolean isMature(class_2680 blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestWithEaseAPI.isMature(blockState, HarvestWithEaseAPI.getAge(blockState));
    }

    public static boolean isTallCrop(class_1937 world, class_2680 blockState, class_2338 blockPos) {
        return blockState.method_26164(class_3481.field_20341) && world.method_8320(blockPos.method_10074()).method_27852(blockState.method_26204()) || world.method_8320(blockPos.method_10084()).method_27852(blockState.method_26204());
    }

    public static boolean isTierForMultiHarvest(class_1831 tool) {
        class_1832 toolTier = tool.method_8022();
        String configTier = ModConfig.getMultiHarvestStartingTier();
        return toolTier.method_8024() >= HarvestWithEaseAPI.getTierLevel(configTier);
    }

    public static boolean isTierIn(List<class_1832> tiers, String tierRef) {
        return tiers.stream().anyMatch(tier -> HarvestWithEaseAPI.matchesTier(tierRef, tier));
    }

    public static boolean isTierIn(List<class_1832> tiers, class_1832 tier) {
        return HarvestWithEaseAPI.isTierIn(tiers, tier.toString());
    }

    public static int getTierLevel(class_1832 tier) {
        return tier.method_8024();
    }

    public static int getTierLevel(String tierRef) {
        try {
            return tierRef.equalsIgnoreCase("none") ? -1 : HarvestWithEaseAPI.getTierLevel((class_1832)Stream.of(class_1834.values()).filter(tier -> HarvestWithEaseAPI.matchesTier(tierRef, (class_1832)tier)).findFirst().orElseThrow());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static boolean matchesTier(String tierRef, class_1832 tier) {
        return tier.toString().equalsIgnoreCase(tierRef);
    }

    private static String getKey(class_2248 block) {
        Optional key = class_2378.field_11146.method_29113((Object)block);
        if (key.isPresent()) {
            return ((class_5321)key.get()).method_29177().toString();
        }
        LOGGER.debug("Couldn't get key for block [" + block + "].");
        return "";
    }
}

