/*
 * Decompiled with CFR 0.152.
 */
package com.github.reoseah.catwalksinc.item;

import com.github.reoseah.catwalksinc.CIncItems;
import com.github.reoseah.catwalksinc.block.Paintable;
import com.github.reoseah.catwalksinc.item.CustomDurabilityItem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3956;
import net.minecraft.class_5556;
import org.jetbrains.annotations.Nullable;

public class PaintRollerItem
extends class_1792
implements CustomDurabilityItem {
    public static final Map<class_1767, PaintRollerItem> INSTANCES = new EnumMap<class_1767, PaintRollerItem>(class_1767.class);
    protected final class_1767 color;

    public static PaintRollerItem byColor(class_1767 color) {
        return INSTANCES.get(color);
    }

    public PaintRollerItem(class_1767 color, class_1792.class_1793 settings) {
        super(settings);
        this.color = color;
        INSTANCES.put(color, this);
    }

    public String method_7876() {
        return CIncItems.PAINT_ROLLER.method_7876();
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)new class_2588("misc.catwalksinc." + this.color.method_15434()).method_27692(class_124.field_1080));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1792 blockItem;
        class_2338 pos;
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos = context.method_8037());
        class_2248 block = state.method_26204();
        if (block == class_2246.field_27097 && (Integer)state.method_11654((class_2769)class_5556.field_27206) > 0 && context.method_8036() != null) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_5556.field_27206) - 1)));
            context.method_8036().method_6122(context.method_20287(), new class_1799((class_1935)CIncItems.PAINT_ROLLER));
            return class_1269.field_5812;
        }
        if (block instanceof Paintable) {
            int amount;
            Paintable paintable = (Paintable)block;
            if (paintable.canPaintBlock(this.color, state, (class_1922)world, pos) && (amount = paintable.getPaintConsumption(this.color, state, (class_1922)world, pos)) <= this.getMaxPaint() - this.getDamage(context.method_8041())) {
                paintable.paintBlock(this.color, state, (class_1936)world, pos);
                if (context.method_8036() != null) {
                    this.damage(context.method_8041(), amount, context.method_8036(), (T player) -> {
                        player.method_20236(context.method_20287());
                        player.method_6122(context.method_20287(), new class_1799((class_1935)CIncItems.PAINT_ROLLER));
                    });
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        if (!state.method_31709() && (blockItem = state.method_26204().method_8389()) instanceof class_1747 && ((class_1747)blockItem).method_7711() == block) {
            class_1792 class_17922;
            class_1715 inventory = new class_1715(new class_1703(null, -1){

                public boolean method_7597(class_1657 player) {
                    return false;
                }
            }, 3, 3);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) {
                        inventory.method_5447(i * 3 + j, class_1769.method_7803((class_1767)this.color).method_7854());
                        continue;
                    }
                    inventory.method_5447(i * 3 + j, blockItem.method_7854());
                }
            }
            class_1799 result = world.method_8433().method_8132(class_3956.field_17545, (class_1263)inventory, world).map(recipe -> recipe.method_8116((class_1263)inventory)).orElse(null);
            if (result != null && !result.method_7985() && (class_17922 = result.method_7909()) instanceof class_1747) {
                class_1747 resultItem = (class_1747)class_17922;
                class_2248 resultBlock = resultItem.method_7711();
                class_2680 resultState = resultBlock.method_9564();
                for (class_2769 property : resultState.method_28501()) {
                    if (!state.method_28498(property)) {
                        return class_1269.field_5814;
                    }
                    resultState = (class_2680)resultState.method_11657(property, state.method_11654(property));
                }
                world.method_8501(pos, resultState);
                this.damage(context.method_8041(), 1, context.method_8036(), (T player) -> {
                    player.method_20236(context.method_20287());
                    player.method_6122(context.method_20287(), new class_1799((class_1935)CIncItems.PAINT_ROLLER));
                });
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public int getMaxPaint() {
        return 32;
    }

    public int getDamage(class_1799 stack) {
        return stack.method_7969() == null ? 0 : stack.method_7969().method_10550("DyeUsed");
    }

    public void setDamage(class_1799 stack, int damage) {
        stack.method_7948().method_10569("DyeUsed", Math.max(0, damage));
    }

    public boolean damage(class_1799 stack, int amount, Random random, @Nullable class_3222 player) {
        if (player != null && amount != 0) {
            class_174.field_1185.method_8960(player, stack, this.getDamage(stack) + amount);
        }
        int i = this.getDamage(stack) + amount;
        this.setDamage(stack, i);
        return i >= this.getMaxPaint();
    }

    public <T extends class_1309> void damage(class_1799 stack, int amount, T entity, Consumer<T> breakCallback) {
        if (!(entity.field_6002.field_9236 || entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477 || !this.damage(stack, amount, entity.method_6051(), entity instanceof class_3222 ? (class_3222)entity : null))) {
            breakCallback.accept(entity);
            class_1792 item = stack.method_7909();
            stack.method_7934(1);
            if (entity instanceof class_1657) {
                ((class_1657)entity).method_7259(class_3468.field_15383.method_14956((Object)item));
            }
            this.setDamage(stack, 0);
        }
    }

    @Override
    public double getDurabilityBarProgress(class_1799 stack) {
        return (double)this.getDamage(stack) / (double)this.getMaxPaint();
    }

    @Override
    public boolean hasDurabilityBar(class_1799 stack) {
        return this.getDamage(stack) > 0;
    }
}

