/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_2960;

public class CRBlockPartials {
    public static final Map<class_1767, PartialModel> TOOLBOX_BODIES = new EnumMap<class_1767, PartialModel>(class_1767.class);
    public static final Map<class_1767, PartialModel> CONDUCTOR_WHISTLE_FLAGS = new EnumMap<class_1767, PartialModel>(class_1767.class);
    public static final Map<String, PartialModel> CUSTOM_CONDUCTOR_CAPS = new HashMap<String, PartialModel>();
    public static final Map<String, PartialModel> CUSTOM_CONDUCTOR_ONLY_CAPS = new HashMap<String, PartialModel>();
    public static final Map<String, class_2960> CUSTOM_CONDUCTOR_SKINS = new HashMap<String, class_2960>();
    public static final Set<String> NO_TILT_CAPS = new HashSet<String>();
    public static final Map<String, class_2960> CUSTOM_CONDUCTOR_SKINS_FOR_NAME = new HashMap<String, class_2960>();
    public static final PartialModel SEMAPHORE_ARM_RED = CRBlockPartials.block("semaphore/red_arm");
    public static final PartialModel SEMAPHORE_ARM_YELLOW = CRBlockPartials.block("semaphore/yellow_arm");
    public static final PartialModel SEMAPHORE_ARM_RED_FLIPPED = CRBlockPartials.block("semaphore/red_arm_flipped");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_FLIPPED = CRBlockPartials.block("semaphore/yellow_arm_flipped");
    public static final PartialModel SEMAPHORE_ARM_RED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/red_arm_down");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_UPSIDE_DOWN = CRBlockPartials.block("semaphore/yellow_arm_down");
    public static final PartialModel SEMAPHORE_ARM_RED_FLIPPED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/red_arm_flipped_down");
    public static final PartialModel SEMAPHORE_ARM_YELLOW_FLIPPED_UPSIDE_DOWN = CRBlockPartials.block("semaphore/yellow_arm_flipped_down");
    public static final PartialModel SEMAPHORE_LAMP_RED = CRBlockPartials.block("semaphore/red_lamp");
    public static final PartialModel SEMAPHORE_LAMP_YELLOW = CRBlockPartials.block("semaphore/yellow_lamp");
    public static final PartialModel SEMAPHORE_LAMP_WHITE = CRBlockPartials.block("semaphore/white_lamp");
    public static final EnumMap<TrackShape, TrackCasingSpec> TRACK_CASINGS = new EnumMap(TrackShape.class);
    public static final PartialModel TRACK_CASING_FLAT = CRBlockPartials.block("track_casing/flat");
    public static final PartialModel TRACK_CASING_FLAT_THICK = CRBlockPartials.block("track_casing/flat_thick");
    public static final PartialModel COUPLER_COUPLE;
    public static final PartialModel COUPLER_DECOUPLE;
    public static final PartialModel COUPLER_BOTH;
    public static final PartialModel COUPLER_NONE;
    public static final PartialModel ANDESITE_SWITCH_FLAG;
    public static final PartialModel ANDESITE_SWITCH_HANDLE;
    public static final PartialModel BRASS_SWITCH_FLAG;
    public static final PartialModel SWITCH_NONE;
    public static final PartialModel SWITCH_RIGHT_STRAIGHT;
    public static final PartialModel SWITCH_RIGHT_TURN;
    public static final PartialModel SWITCH_LEFT_STRAIGHT;
    public static final PartialModel SWITCH_LEFT_TURN;
    public static final PartialModel SWITCH_3WAY_STRAIGHT;
    public static final PartialModel SWITCH_3WAY_LEFT;
    public static final PartialModel SWITCH_3WAY_RIGHT;
    public static final PartialModel SWITCH_2WAY_LEFT;
    public static final PartialModel SWITCH_2WAY_RIGHT;
    public static final PartialModel MONORAIL_SEGMENT_TOP;
    public static final PartialModel MONORAIL_SEGMENT_BOTTOM;
    public static final PartialModel MONORAIL_SEGMENT_MIDDLE;
    public static final PartialModel MONORAIL_TRACK_ASSEMBLING_OVERLAY;
    public static final PartialModel MONOBOGEY_FRAME;
    public static final PartialModel MONOBOGEY_WHEEL;
    public static final PartialModel SINGLEAXLE_FRAME;
    public static final PartialModel LEAFSPRING_FRAME;
    public static final PartialModel COILSPRING_FRAME;
    public static final PartialModel FREIGHT_FRAME;
    public static final PartialModel ARCHBAR_FRAME;
    public static final PartialModel PASSENGER_FRAME;
    public static final PartialModel MODERN_FRAME;
    public static final PartialModel BLOMBERG_FRAME;
    public static final PartialModel Y25_FRAME;
    public static final PartialModel HEAVYWEIGHT_FRAME;
    public static final PartialModel RADIAL_FRAME;
    public static final PartialModel CR_BOGEY_WHEELS;
    public static final PartialModel DIESEL_STACK_FAN;
    public static final PartialModel CONDUCTOR_ANTENNA;

    public static void registerCustomCap(String itemName, String modelLoc) {
        CUSTOM_CONDUCTOR_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
    }

    public static void registerCustomCap(String itemName, String modelLoc, boolean preventTilting) {
        CUSTOM_CONDUCTOR_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
        if (preventTilting) {
            NO_TILT_CAPS.add(itemName);
        }
    }

    public static void registerCustomConductorOnlyCap(String itemName, String modelLoc) {
        CUSTOM_CONDUCTOR_ONLY_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
    }

    public static void registerCustomConductorOnlyCap(String itemName, String modelLoc, boolean preventTilting) {
        CUSTOM_CONDUCTOR_ONLY_CAPS.put(itemName, new PartialModel(Railways.asResource("item/dev_caps/" + modelLoc)));
        if (preventTilting) {
            NO_TILT_CAPS.add(itemName);
        }
    }

    public static boolean shouldPreventTiltingCap(String name) {
        return NO_TILT_CAPS.contains(name);
    }

    public static void registerCustomSkin(String itemName, String textureLoc) {
        CUSTOM_CONDUCTOR_SKINS.put(itemName, Railways.asResource("textures/entity/custom_conductors/" + textureLoc));
    }

    public static void registerCustomConductorNameBasedSkin(String conductorName, String textureLoc) {
        CUSTOM_CONDUCTOR_SKINS_FOR_NAME.put(conductorName, Railways.asResource("textures/entity/custom_conductors/" + textureLoc));
    }

    private static PartialModel createBlock(String path) {
        return new PartialModel(Create.asResource((String)("block/" + path)));
    }

    private static PartialModel block(String path) {
        return new PartialModel(Railways.asResource("block/" + path));
    }

    public static void init() {
    }

    static {
        PartialModel xo = CRBlockPartials.block("track_casing/xo");
        PartialModel zo = CRBlockPartials.block("track_casing/zo");
        PartialModel pd = CRBlockPartials.block("track_casing/pd");
        PartialModel nd = CRBlockPartials.block("track_casing/nd");
        PartialModel cr_o = CRBlockPartials.block("track_casing/cr_o");
        TrackCasingSpec spec_3x3 = new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(1.0, 1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0).addTransform(1.0, 0.0).addTransform(-1.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, -1.0).addTransform(-1.0, -1.0);
        TrackCasingSpec flat_x = new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(0.0, 1.0).addTransform(0.0, -1.0);
        TrackCasingSpec flat_z = new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(1.0, 0.0).addTransform(-1.0, 0.0);
        TRACK_CASINGS.put(TrackShape.XO, new TrackCasingSpec(xo, ModelTransform.ZERO, 8).withAltSpec(flat_x));
        TRACK_CASINGS.put(TrackShape.ZO, new TrackCasingSpec(zo, ModelTransform.ZERO, 8).withAltSpec(flat_z));
        TRACK_CASINGS.put(TrackShape.PD, new TrackCasingSpec(pd, ModelTransform.ZERO, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(1.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0)));
        TRACK_CASINGS.put(TrackShape.ND, new TrackCasingSpec(nd, ModelTransform.ZERO, 8).withAltSpec(new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(-1.0, 0.0).addTransform(-1.0, -1.0).addTransform(0.0, 1.0).addTransform(1.0, 1.0)));
        TRACK_CASINGS.put(TrackShape.TE, new TrackCasingSpec(xo, ModelTransform.ZERO, 8).withAltSpec(flat_x));
        TRACK_CASINGS.put(TrackShape.TW, new TrackCasingSpec(xo, ModelTransform.ZERO, 8).withAltSpec(flat_x));
        TRACK_CASINGS.put(TrackShape.TN, new TrackCasingSpec(zo, ModelTransform.ZERO, 8).withAltSpec(flat_z));
        TRACK_CASINGS.put(TrackShape.TS, new TrackCasingSpec(zo, ModelTransform.ZERO, 8).withAltSpec(flat_z));
        TRACK_CASINGS.put(TrackShape.CR_O, new TrackCasingSpec(cr_o, ModelTransform.ZERO, 8).withAltSpec(spec_3x3));
        TRACK_CASINGS.put(TrackShape.CR_D, new TrackCasingSpec(TRACK_CASING_FLAT, ModelTransform.ZERO, 3).addTransform(1.0, 2.0).addTransform(0.0, 2.0).addTransform(-1.0, 2.0).addTransform(2.0, 1.0).addTransform(1.0, 1.0).addTransform(0.0, 1.0).addTransform(-1.0, 1.0).addTransform(-2.0, 1.0).addTransform(2.0, 0.0).addTransform(1.0, 0.0).addTransform(-1.0, 0.0).addTransform(-2.0, 0.0).addTransform(1.0, -1.0).addTransform(0.0, -1.0).addTransform(-1.0, -1.0).addTransform(0.0, -2.0).withAltSpec(spec_3x3));
        TRACK_CASINGS.put(TrackShape.CR_PDX, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_PDZ, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_NDX, spec_3x3);
        TRACK_CASINGS.put(TrackShape.CR_NDZ, spec_3x3);
        TRACK_CASINGS.put(TrackShape.AN, new TrackCasingSpec(CRBlockPartials.block("track_casing/an"), ModelTransform.ZERO, 5).overlayShift(0.0, 0.1875));
        TRACK_CASINGS.put(TrackShape.AS, new TrackCasingSpec(CRBlockPartials.block("track_casing/as"), ModelTransform.ZERO, 5).overlayShift(0.0, -0.1875));
        TRACK_CASINGS.put(TrackShape.AE, new TrackCasingSpec(CRBlockPartials.block("track_casing/ae"), ModelTransform.ZERO, 5).overlayShift(-0.1875, 0.0));
        TRACK_CASINGS.put(TrackShape.AW, new TrackCasingSpec(CRBlockPartials.block("track_casing/aw"), ModelTransform.ZERO, 5).overlayShift(0.1875, 0.0));
        COUPLER_COUPLE = CRBlockPartials.block("track_overlay/coupler_couple");
        COUPLER_DECOUPLE = CRBlockPartials.block("track_overlay/coupler_decouple");
        COUPLER_BOTH = CRBlockPartials.block("track_overlay/coupler_both");
        COUPLER_NONE = CRBlockPartials.block("track_overlay/coupler_none");
        ANDESITE_SWITCH_FLAG = CRBlockPartials.block("track_switch_andesite/flag");
        ANDESITE_SWITCH_HANDLE = CRBlockPartials.block("track_switch_andesite/handle");
        BRASS_SWITCH_FLAG = CRBlockPartials.block("track_switch_brass/flag");
        SWITCH_NONE = CRBlockPartials.block("track_overlay/switch_none");
        SWITCH_RIGHT_STRAIGHT = CRBlockPartials.block("track_overlay/switch_right_straight");
        SWITCH_RIGHT_TURN = CRBlockPartials.block("track_overlay/switch_right_turn");
        SWITCH_LEFT_STRAIGHT = CRBlockPartials.block("track_overlay/switch_left_straight");
        SWITCH_LEFT_TURN = CRBlockPartials.block("track_overlay/switch_left_turn");
        SWITCH_3WAY_STRAIGHT = CRBlockPartials.block("track_overlay/switch_3way_straight");
        SWITCH_3WAY_LEFT = CRBlockPartials.block("track_overlay/switch_3way_left");
        SWITCH_3WAY_RIGHT = CRBlockPartials.block("track_overlay/switch_3way_right");
        SWITCH_2WAY_LEFT = CRBlockPartials.block("track_overlay/switch_2way_left");
        SWITCH_2WAY_RIGHT = CRBlockPartials.block("track_overlay/switch_2way_right");
        MONORAIL_SEGMENT_TOP = CRBlockPartials.block("monorail/monorail/segment_top");
        MONORAIL_SEGMENT_BOTTOM = CRBlockPartials.block("monorail/monorail/segment_bottom");
        MONORAIL_SEGMENT_MIDDLE = CRBlockPartials.block("monorail/monorail/segment_middle");
        MONORAIL_TRACK_ASSEMBLING_OVERLAY = CRBlockPartials.block("monorail/monorail/assembling_overlay");
        MONOBOGEY_FRAME = CRBlockPartials.block("bogey/monorail/frame");
        MONOBOGEY_WHEEL = CRBlockPartials.block("bogey/monorail/wheel");
        SINGLEAXLE_FRAME = CRBlockPartials.block("bogey/singleaxle/singleaxle_frame");
        LEAFSPRING_FRAME = CRBlockPartials.block("bogey/leafspring/leafspring_frame");
        COILSPRING_FRAME = CRBlockPartials.block("bogey/coilspring/coilspring_frame");
        FREIGHT_FRAME = CRBlockPartials.block("bogey/freight/freight_frame");
        ARCHBAR_FRAME = CRBlockPartials.block("bogey/archbar/archbar_frame");
        PASSENGER_FRAME = CRBlockPartials.block("bogey/passenger/passenger_frame");
        MODERN_FRAME = CRBlockPartials.block("bogey/modern/modern_frame");
        BLOMBERG_FRAME = CRBlockPartials.block("bogey/blomberg/blomberg_frame");
        Y25_FRAME = CRBlockPartials.block("bogey/y25/y25_frame");
        HEAVYWEIGHT_FRAME = CRBlockPartials.block("bogey/heavyweight/heavyweight_frame");
        RADIAL_FRAME = CRBlockPartials.block("bogey/radial/radial_frame");
        CR_BOGEY_WHEELS = CRBlockPartials.block("bogey/wheels/cr_bogey_wheels");
        DIESEL_STACK_FAN = CRBlockPartials.block("smokestack/block_diesel_fan");
        CONDUCTOR_ANTENNA = CRBlockPartials.block("conductor_antenna");
        for (class_1767 color : class_1767.values()) {
            TOOLBOX_BODIES.put(color, CRBlockPartials.createBlock(Lang.asId((String)color.name()) + "_toolbox"));
            CONDUCTOR_WHISTLE_FLAGS.put(color, CRBlockPartials.block("conductor_whistle/flag_" + Lang.asId((String)color.name())));
        }
    }

    public static final class TrackCasingSpec {
        public final PartialModel model;
        public final ModelTransform transform;
        public final List<ModelTransform> additionalTransforms = new ArrayList<ModelTransform>();
        private TrackCasingSpec altSpec;
        private final int topSurfacePixelHeight;
        private double xShift = 0.0;
        private double zShift = 0.0;

        public TrackCasingSpec(PartialModel model, ModelTransform transform, int topSurfacePixelHeight) {
            this.model = model;
            this.transform = transform;
            this.topSurfacePixelHeight = topSurfacePixelHeight;
        }

        public TrackCasingSpec addTransform(ModelTransform transform) {
            this.additionalTransforms.add(transform);
            return this;
        }

        public TrackCasingSpec addTransform(double x, double z) {
            return this.addTransform(ModelTransform.of(x, z));
        }

        public TrackCasingSpec withAltSpec(@Nullable TrackCasingSpec altSpec) {
            this.altSpec = altSpec;
            return this;
        }

        public TrackCasingSpec getAltSpec() {
            return this.altSpec != null ? this.altSpec : this;
        }

        public int getTopSurfacePixelHeight(boolean alt) {
            return alt && this.altSpec != null ? this.altSpec.topSurfacePixelHeight : this.topSurfacePixelHeight;
        }

        public TrackCasingSpec overlayShift(double x, double z) {
            this.xShift = x;
            this.zShift = z;
            return this;
        }

        public double getXShift() {
            return this.xShift;
        }

        public double getZShift() {
            return this.zShift;
        }
    }

    public record ModelTransform(double x, double y, double z, float rx, float ry, float rz) {
        public static final ModelTransform ZERO = new ModelTransform(0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f);

        public static ModelTransform of(double x, double y, double z, float rx, float ry, float rz) {
            return new ModelTransform(x, y, z, rx, ry, rz);
        }

        public static ModelTransform of(double x, double y, double z) {
            return ModelTransform.of(x, y, z, 0.0f, 0.0f, 0.0f);
        }

        public static ModelTransform of(double x, double z) {
            return ModelTransform.of(x, 0.0, z);
        }
    }
}

