/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.railwayteam.railways.Config;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.SwitchDataUpdatePacket;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarriageContraptionEntity.class}, remap=false)
public abstract class MixinCarriageContraptionEntity
extends OrientedContraptionEntity {
    @Shadow
    private Carriage carriage;
    private boolean snr$fakePlayer = false;
    boolean switchMessage = false;

    private MixinCarriageContraptionEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"control"}, at={@At(value="HEAD")})
    private void recordFakePlayer(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (player.method_7334() == ConductorEntity.FAKE_PLAYER_PROFILE) {
            this.snr$fakePlayer = true;
        }
    }

    @WrapOperation(method={"control"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;closerThan(Lnet/minecraft/core/Position;D)Z", remap=true)})
    private boolean snr$closerThan(class_243 instance, class_2374 pos, double distance, Operation<Boolean> original) {
        if (this.snr$fakePlayer) {
            this.snr$fakePlayer = false;
            return true;
        }
        return instance.method_24802(pos, distance);
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;maxSpeed()F")})
    private void showSwitchOverlay(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        Optional targetState;
        Navigation nav = this.carriage.train.navigation;
        class_3499.class_3501 info = (class_3499.class_3501)this.contraption.getBlocks().get(controlsLocalPos);
        class_2350 initialOrientation = this.getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.field_15596.method_28498((class_2769)ControlsBlock.field_11177)) {
            inverted = !((class_2350)info.field_15596.method_11654((class_2769)ControlsBlock.field_11177)).equals((Object)initialOrientation);
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        if (inverted) {
            targetSpeed *= -1;
        }
        boolean spaceDown = heldControls.contains(4);
        double directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
        Railways.temporarilySkipSwitches = true;
        boolean forward = !this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted);
        Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> lookAheadData = ((IGenerallySearchableNavigation)nav).findNearestApproachableSwitch(forward);
        Railways.temporarilySkipSwitches = false;
        TrackSwitch lookAhead = lookAheadData == null ? null : (TrackSwitch)((Object)lookAheadData.getFirst());
        boolean headOn = lookAheadData != null && (Boolean)((Pair)lookAheadData.getSecond()).getFirst() != false;
        Optional optional = targetState = lookAheadData == null ? Optional.empty() : (Optional)((Pair)lookAheadData.getSecond()).getSecond();
        if (lookAhead != null) {
            if (((Boolean)Config.FLIP_DISTANT_SWITCHES.get()).booleanValue() && spaceDown && lookAhead.isAutomatic() && !lookAhead.isLocked() && !this.carriage.train.navigation.isActive()) {
                if (headOn) {
                    lookAhead.trySetSwitchState(TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward));
                } else {
                    targetState.ifPresent(lookAhead::trySetSwitchState);
                }
            }
            boolean wrong = headOn ? TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward) != lookAhead.getSwitchState() : targetState.isPresent() && lookAhead.getSwitchState() != targetState.get();
            this.displayApproachSwitchMessage(player, lookAhead, wrong);
        } else {
            this.cleanUpApproachSwitchMessage(player);
        }
    }

    private void displayApproachSwitchMessage(class_1657 player, TrackSwitch sw, boolean isWrong) {
        this.sendSwitchInfo(player, sw.getSwitchState(), sw.isAutomatic(), isWrong, sw.isLocked());
        this.switchMessage = true;
    }

    private void cleanUpApproachSwitchMessage(class_1657 player) {
        if (!this.switchMessage) {
            return;
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)SwitchDataUpdatePacket.clear());
        }
        this.switchMessage = false;
    }

    private void sendSwitchInfo(class_1657 player, TrackSwitchBlock.SwitchState state, boolean automatic, boolean isWrong, boolean isLocked) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)new SwitchDataUpdatePacket(state, automatic, isWrong, isLocked));
        }
    }

    @Inject(method={"updateTrackGraph"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;graph:Lcom/simibubi/create/content/trains/graph/TrackGraph;", opcode=3, ordinal=0)}, cancellable=true)
    private void cancelDerailing(CallbackInfo ci) {
        if (((Boolean)Config.SKIP_CLIENT_DERAILING.get()).booleanValue()) {
            ci.cancel();
        }
    }
}

