/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class CRBogeyRenderer {

    public static class RadialBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 3);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.RADIAL_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.RADIAL_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 3);
            for (int side = -1; side < 2; ++side) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[side + 1];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side * 1.5).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class HeavyweightBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 3);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.HEAVYWEIGHT_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.HEAVYWEIGHT_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 3);
            for (int side = -1; side < 2; ++side) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[side + 1];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side * 1.5).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class Y25BogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.Y25_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.Y25_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class BlombergBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.BLOMBERG_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.BLOMBERG_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class ModernBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.MODERN_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.MODERN_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class PassengerBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.PASSENGER_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.PASSENGER_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class ArchbarBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.ARCHBAR_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.LARGE;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.ARCHBAR_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class FreightBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.FREIGHT_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.SMALL;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.FREIGHT_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.method_22903();
                }
                BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
                ((BogeyRenderer.BogeyModelData)wheel.translate(0.0, 0.75, (double)side).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
                if (inInstancedContraption) continue;
                ms.method_22909();
            }
        }
    }

    public static class CoilspringBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.COILSPRING_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.COILSPRING_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
        }
    }

    public static class LeafspringBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.LEAFSPRING_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.LARGE;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.LEAFSPRING_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
        }
    }

    public static class SingleaxleBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
            this.createModelInstance(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstance(materialManager, new PartialModel[]{CRBlockPartials.SINGLEAXLE_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.SMALL;
        }

        public void render(class_2487 bogeyData, float wheelAngle, class_4587 ms, int light, class_4588 vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            this.getTransform(CRBlockPartials.SINGLEAXLE_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0).render(ms, light, vb);
            ((BogeyRenderer.BogeyModelData)this.getTransform(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0).render(ms, light, vb);
        }
    }
}

