/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRSounds;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConductorWhistleItem
extends TrackTargetingBlockItem {
    public static final String SPECIAL_MARKER = "<ConductorFlag>";

    public ConductorWhistleItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties, EdgePointType.STATION);
    }

    static boolean isTrack(class_2248 block) {
        return AllTags.AllBlockTags.TRACKS.matches(block);
    }

    static boolean isTrack(class_2680 state) {
        return AllTags.AllBlockTags.TRACKS.matches(state);
    }

    static boolean isTrack(class_1937 level, class_2338 pos) {
        return ConductorWhistleItem.isTrack(level.method_8320(pos));
    }

    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, class_1799 stack) {
        return false;
    }

    private static class_1269 fail(class_1657 player, String message) {
        player.method_7353((class_2561)Components.translatable((String)("railways.whistle.failure." + message)).method_27692(class_124.field_1061), true);
        player.method_7353((class_2561)Components.translatable((String)("railways.whistle.failure." + message)).method_27692(class_124.field_1061), false);
        return class_1269.field_5814;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_25928("SelectedTrain") && tag.method_25928("SelectedConductor")) {
            UUID trainId = tag.method_25926("SelectedTrain");
            UUID conductorId = tag.method_25926("SelectedConductor");
            String trainName = "NOT FOUND";
            GlobalRailwayManager railways = Create.RAILWAYS.sided((class_1936)level);
            if (railways != null && railways.trains.containsKey(trainId)) {
                trainName = ((Train)railways.trains.get((Object)trainId)).name.getString();
            }
            tooltip.add((class_2561)Components.translatable((String)"railways.whistle.tool.bound").method_27692(class_124.field_1077));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.train_id", trainName, trainId.toString().substring(0, 5)));
            tooltip.add((class_2561)Components.translatable((String)"railways.whistle.tool.bound_usage"));
        } else {
            tooltip.add((class_2561)Components.translatable((String)"railways.whistle.tool.not_bound").method_27692(class_124.field_1079));
        }
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 pStack, @NotNull class_1657 pPlayer, @NotNull class_1309 pInteractionTarget, @NotNull class_1268 pUsedHand) {
        ConductorEntity conductor;
        class_1297 class_12972;
        if (pPlayer.field_6002.field_9236) {
            return class_1269.field_5811;
        }
        if (pInteractionTarget instanceof ConductorEntity && (class_12972 = (conductor = (ConductorEntity)pInteractionTarget).method_5854()) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)class_12972;
            Train train = cce.getCarriage().train;
            if (train.owner == pPlayer.method_5667() || !((Boolean)Config.CONDUCTOR_WHISTLE_REQUIRES_OWNING.get()).booleanValue()) {
                class_2487 stackTag = pStack.method_7948();
                stackTag.method_25927("SelectedTrain", train.id);
                stackTag.method_25927("SelectedConductor", conductor.method_5667());
                stackTag.method_10567("SelectedColor", ((Byte)conductor.method_5841().method_12789(ConductorEntity.COLOR)).byteValue());
                pPlayer.method_7353((class_2561)Components.translatable((String)"railways.whistle.set"), true);
                pStack.method_7980(stackTag);
                pPlayer.method_6122(pUsedHand, pStack);
                AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.field_6002, null, conductor.method_23317(), conductor.method_23318(), conductor.method_23321(), 0.5f, 1.1f);
                return class_1269.field_5812;
            }
            pPlayer.method_7353((class_2561)Components.translatable((String)"railways.whistle.not_owner").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        return super.method_7847(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1799 stack = pContext.method_8041();
        class_2338 pos = pContext.method_8037();
        class_1937 level = pContext.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = pContext.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        if (player.method_21749() && stack.method_7985()) {
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)Components.translatable((String)"railways.whistle.clear"), true);
            stack.method_7980(null);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 0.5f);
            return class_1269.field_5812;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ITrackBlock) {
            class_1799 scheduleStack;
            ITrackBlock track = (ITrackBlock)class_22482;
            level.method_8396(null, pos, (class_3414)CRSounds.CONDUCTOR_WHISTLE.get(), class_3419.field_15245, 2.0f, 1.0f);
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            class_243 lookAngle = player.method_5720();
            boolean front = track.getNearestTrackAxis((class_1922)level, pos, state, lookAngle).getSecond() == class_2350.class_2352.field_11056;
            EdgePointType type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            ConductorWhistleItem.withGraphLocation((class_1937)level, (class_2338)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.method_7353((class_2561)Lang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            class_2487 stackTag = stack.method_7969();
            if (stackTag == null || !stackTag.method_25928("SelectedTrain") || !stackTag.method_25928("SelectedConductor")) {
                return ConductorWhistleItem.fail(player, "not_bound");
            }
            UUID trainId = stackTag.method_25926("SelectedTrain");
            UUID conductorId = stackTag.method_25926("SelectedConductor");
            if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                return ConductorWhistleItem.fail(player, "train_missing");
            }
            Train train = (Train)Create.RAILWAYS.trains.get(trainId);
            boolean foundConductor = false;
            Carriage conductorCarriage = null;
            for (Carriage carriage : train.carriages) {
                if (!((ICarriageConductors)carriage).getControllingConductors().contains(conductorId)) continue;
                foundConductor = true;
                conductorCarriage = carriage;
                break;
            }
            if (!foundConductor) {
                return ConductorWhistleItem.fail(player, "conductor_missing");
            }
            stackTag.method_10566("SelectedPos", (class_2520)class_2512.method_10692((class_2338)pos));
            stackTag.method_10556("SelectedDirection", front);
            stackTag.method_10551("Bezier");
            stack.method_7980(stackTag);
            class_2350[] directions = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036};
            class_2350 successDirection = null;
            for (class_2350 direction : directions) {
                class_2338 placePos = pos.method_10093(direction);
                class_243 hitPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5).method_1031((double)direction.method_10148() * 0.5, (double)direction.method_10164() * 0.5, (double)direction.method_10165() * 0.5);
                class_1750 ctx = new class_1750(player, pContext.method_20287(), stack, new class_3965(hitPos, direction.method_10153(), placePos, false));
                if (!level.method_8320(placePos).method_26166(ctx)) continue;
                successDirection = direction;
                break;
            }
            if (successDirection == null) {
                stackTag.method_10551("SelectedPos");
                stackTag.method_10551("SelectedDirection");
                stack.method_7980(stackTag);
                return ConductorWhistleItem.fail(player, "no_space");
            }
            if (((Boolean)Config.CONDUCTOR_WHISTLE_REQUIRES_OWNING.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != player) {
                stackTag.method_10551("SelectedPos");
                stackTag.method_10551("SelectedDirection");
                stack.method_7980(stackTag);
                return ConductorWhistleItem.fail(player, "not_owner");
            }
            if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule()).method_7960()) {
                for (class_2487 passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                    class_2499 schedulesList;
                    if (passengerTag.method_10545("PlayerPassenger") || !passengerTag.method_10545("id") || !CREntities.CONDUCTOR.getId().equals((Object)new class_2960(passengerTag.method_10558("id"))) || !passengerTag.method_25928("UUID") || !passengerTag.method_25926("UUID").equals(conductorId)) continue;
                    if (!passengerTag.method_10545("heldSchedules")) {
                        schedulesList = new class_2499();
                        passengerTag.method_10566("heldSchedules", (class_2520)schedulesList);
                    } else {
                        schedulesList = passengerTag.method_10554("heldSchedules", 10);
                    }
                    schedulesList.add((Object)scheduleStack.method_7953(new class_2487()));
                    scheduleStack.method_7939(0);
                    break;
                }
                if (!scheduleStack.method_7960()) {
                    conductorCarriage.forEachPresentEntity(cce -> {
                        if (!scheduleStack.method_7960()) {
                            for (class_1297 passenger : cce.method_5685()) {
                                if (!(passenger instanceof ConductorEntity)) continue;
                                ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                if (!passenger.method_5667().equals(conductorId)) continue;
                                conductorEntity.addSchedule(scheduleStack);
                                scheduleStack.method_7939(0);
                                break;
                            }
                        }
                    });
                }
                if (!scheduleStack.method_7960() && !player.method_7270(scheduleStack)) {
                    player.method_7328(scheduleStack, false);
                }
            }
            class_2338 placePos = pos.method_10093(successDirection);
            String stationName = SPECIAL_MARKER + placePos.method_23854();
            class_2680 placeState = CRBlocks.CONDUCTOR_WHISTLE_FLAG.getDefaultState();
            level.method_8652(placePos, placeState, 11);
            class_2487 teTag = new class_2487();
            teTag.method_10582("Name", stationName);
            teTag.method_10567("SelectedColor", stackTag.method_10571("SelectedColor"));
            teTag.method_10556("TargetDirection", stackTag.method_10577("SelectedDirection"));
            class_2338 selectedPos = class_2512.method_10691((class_2487)stackTag.method_10562("SelectedPos"));
            teTag.method_10566("TargetTrack", (class_2520)class_2512.method_10692((class_2338)selectedPos.method_10059((class_2382)placePos)));
            stackTag.method_10566("BlockEntityTag", (class_2520)teTag);
            stack.method_7980(stackTag);
            this.method_7710(placePos, level, player, stack, placeState);
            stackTag.method_10551("SelectedPos");
            stackTag.method_10551("SelectedDirection");
            stackTag.method_10551("BlockEntityTag");
            stack.method_7980(stackTag);
            player.method_7353((class_2561)Components.translatable((String)"railways.whistle.success"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 1.0f);
            Schedule schedule = new Schedule();
            ScheduleEntry entry = new ScheduleEntry();
            DestinationInstruction instruction = new DestinationInstruction();
            ScheduledDelay condition = new ScheduledDelay();
            condition.getData().method_10569("Value", 0);
            instruction.getData().method_10582("Text", stationName);
            entry.instruction = instruction;
            if (entry.conditions.size() == 0) {
                entry.conditions.add(new ArrayList());
            }
            ((List)entry.conditions.get(0)).add(condition);
            schedule.entries.add(entry);
            schedule.cyclic = false;
            train.runtime.setSchedule(schedule, true);
            ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }
}

