/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.vent;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.vent.fabric.VentBlockImpl;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VentBlock
extends CopycatBlock
implements IWrenchable {
    public static final class_2746 CONDUCTOR_VISIBLE = class_2746.method_11825((String)"conductor_visible");
    public static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final class_265 OUTLINE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected VentBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)CONDUCTOR_VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{CONDUCTOR_VISIBLE}));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static VentBlock create(class_4970.class_2251 properties) {
        return VentBlockImpl.create(properties);
    }

    @Nullable
    public class_2680 getConnectiveMaterial(class_1920 reader, class_2680 otherState, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        return VentBlock.getMaterial((class_1922)reader, (class_2338)toPos);
    }

    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        return true;
    }

    public boolean isUnblockableConnectivitySide(class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        return true;
    }

    protected Optional<class_2338> getTeleportTarget(class_1937 level, class_2338 start, class_2350 prevDirection) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        class_2338.class_2339 end = start.method_25503();
        int panic = (Integer)Config.MAX_CONDUCTOR_VENT_LENGTH.get();
        block0: while (true) {
            if (panic-- < 0) {
                return Optional.empty();
            }
            end.method_10098(prevDirection);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.method_8320((class_2338)end).method_26204() == this) {
                visited.add(end.method_10062());
                continue;
            }
            end.method_10098(prevDirection.method_10153());
            for (class_2350 direction : class_2350.values()) {
                if (direction == prevDirection || direction == prevDirection.method_10153()) continue;
                end.method_10098(direction);
                if (visited.contains(end)) {
                    return Optional.empty();
                }
                if (level.method_8320((class_2338)end).method_26204() == this) {
                    visited.add(end.method_10062());
                    prevDirection = direction;
                    continue block0;
                }
                end.method_10098(direction.method_10153());
            }
            break;
        }
        end.method_10098(prevDirection);
        if (level.method_8320((class_2338)end).method_26215()) {
            return Optional.of(end.method_10062());
        }
        end.method_10098(prevDirection.method_10153());
        for (class_2350 direction : class_2350.values()) {
            if (direction == prevDirection || direction == prevDirection.method_10153()) continue;
            end.method_10098(direction);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.method_8320((class_2338)end).method_26215()) {
                return Optional.of(end.method_10062());
            }
            end.method_10098(direction.method_10153());
        }
        return Optional.empty();
    }

    protected boolean teleportConductorInternal(class_1937 level, class_2338 start, ConductorEntity conductor, @Nullable class_2350 prevDirection) {
        Optional<class_2338> target;
        if (prevDirection == null) {
            class_2338 normal = conductor.method_24515().method_10059((class_2382)start);
            prevDirection = class_2350.method_35832((class_2338)normal);
            prevDirection = prevDirection == null ? class_2350.field_11043 : prevDirection.method_10153();
        }
        if ((target = this.getTeleportTarget(level, start, prevDirection)).isPresent()) {
            class_2338 end = target.get();
            if (!level.method_8320(end.method_10084()).method_26215()) {
                end = end.method_10074();
            }
            conductor.teleportToForce((double)end.method_10263() + 0.5, (double)end.method_10264() + 0.0, (double)end.method_10260() + 0.5);
            return true;
        }
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (level instanceof class_3218) {
                class_2350 direction;
                Optional<class_2338> target;
                class_3218 serverLevel = (class_3218)level;
                if (ConductorEntity.isPlayerDisguised(player) && (target = this.getTeleportTarget(level, pos, direction = hit.method_17780().method_10153())).isPresent()) {
                    class_2338 end = target.get();
                    if (!level.method_8320(end.method_10084()).method_26215()) {
                        end = end.method_10074();
                    }
                    serverPlayer.method_14251(serverLevel, (double)end.method_10263() + 0.5, (double)end.method_10264() + 0.0, (double)end.method_10260() + 0.5, serverPlayer.method_36454(), serverPlayer.method_36455());
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        super.method_9548(state, level, pos, entity);
        this.teleportConductor(level, pos, entity, null);
    }

    public void teleportConductor(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity, @Nullable class_2350 direction) {
        ConductorEntity conductor;
        if (level.field_9236) {
            return;
        }
        if (entity instanceof ConductorEntity && (conductor = (ConductorEntity)entity).isPossessed()) {
            if (direction != null || conductor.ventCooldown <= 0) {
                this.teleportConductorInternal(level, pos, conductor, direction);
            }
            conductor.ventCooldown = 20;
        }
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_3727 ec;
        if (context instanceof class_3727 && (ec = (class_3727)context).method_32480() instanceof ConductorEntity) {
            return COLLISION_SHAPE;
        }
        return OUTLINE_SHAPE;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return OUTLINE_SHAPE;
    }

    public boolean supportsExternalFaceHiding(class_2680 state) {
        throw new AssertionError();
    }

    public boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        throw new AssertionError();
    }
}

