/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.tracks.SoftIngredient;
import com.railwayteam.railways.compat.tracks.TrackCompatUtils;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.util.TextUtils;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class GenericTrackCompat {
    public final String modid;
    protected final Map<String, TrackMaterial> MATERIALS = new HashMap<String, TrackMaterial>();
    protected final Map<String, NonNullSupplier<? extends TrackBlock>> BLOCKS = new HashMap<String, NonNullSupplier<? extends TrackBlock>>();

    public GenericTrackCompat(String modid) {
        this.modid = modid;
    }

    public static boolean isDataGen() {
        return Utils.isEnvVarTrue("DATAGEN");
    }

    protected static boolean registerTracksAnywayGlobal() {
        return (Boolean)Config.REGISTER_MISSING_TRACKS.get();
    }

    protected boolean registerTracksAnyway() {
        return GenericTrackCompat.registerTracksAnywayGlobal();
    }

    protected final boolean shouldRegisterMissing() {
        return GenericTrackCompat.isDataGen() || this.registerTracksAnyway();
    }

    public void register(String ... names) {
        for (String name : names) {
            Optional baseBlock = class_2378.field_11146.method_17966(this.getSlabLocation(name));
            if (baseBlock.isEmpty()) {
                if (!this.shouldRegisterMissing()) continue;
                if (GenericTrackCompat.isDataGen() || Utils.isDevEnv()) {
                    Railways.LOGGER.error("Failed to locate base block at " + this.getSlabLocation(name) + " for " + this.asResource(name));
                }
            }
            TrackMaterial material = TrackCompatUtils.buildCompatModels(TrackMaterialFactory.make((class_2960)this.asResource(name)).lang(this.langName(name)).block(() -> this.BLOCKS.get(name)).particle(this.asResource("block/track/" + name + "/standard_track_crossing_" + name)).sleeper(baseBlock.map(xva$0 -> class_1856.method_8091((class_1935[])new class_1935[]{xva$0})).orElseGet(() -> SoftIngredient.of(this.getSlabLocation(name)))));
            this.MATERIALS.put(name, material);
            BlockEntry<TrackBlock> block = TrackCompatUtils.makeTrack(material);
            this.BLOCKS.put(name, (NonNullSupplier<? extends TrackBlock>)block);
            CRItems.ITEM_INCOMPLETE_TRACK.put(material, (ItemEntry<SequencedAssemblyItem>)Railways.registrate().item("track_incomplete_" + this.modid + "_" + material.resourceName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new class_2960[]{this.asResource("item/track_incomplete/track_incomplete_" + material.resourceName())})).lang("Incomplete " + material.langName + " Track").register());
        }
    }

    protected String langName(String name) {
        return TextUtils.titleCaseConversion(name.replace('_', ' '));
    }

    protected class_2960 asResource(String path) {
        return new class_2960(this.modid, path);
    }

    protected class_2960 getSlabLocation(String name) {
        return this.asResource(name + "_slab");
    }
}

