/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixerapi;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.railwayteam.railways.Config;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.datafixerapi.DataFixesInternalsImpl;
import com.railwayteam.railways.base.datafixerapi.NoOpDataFixesInternals;
import java.util.function.BiFunction;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public abstract class DataFixesInternals {
    public static final BiFunction<Integer, Schema, Schema> BASE_SCHEMA = (version, parent) -> {
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)"version must be 0");
        Preconditions.checkArgument((parent == null ? 1 : 0) != 0, (Object)"parent must be null");
        return DataFixesInternals.get().createBaseSchema();
    };
    private static DataFixesInternals instance;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getModDataVersion(@NotNull class_2487 compound) {
        return compound.method_10550("Railways_DataVersion");
    }

    @NotNull
    public static DataFixesInternals get() {
        if (instance == null) {
            Schema latestVanillaSchema;
            try {
                latestVanillaSchema = class_3551.method_15450().getSchema(DataFixUtils.makeKey((int)class_155.method_16673().method_37912().method_38494()));
            }
            catch (Exception e) {
                latestVanillaSchema = null;
            }
            if (latestVanillaSchema == null) {
                Railways.LOGGER.warn("[Railways DFU] Failed to initialize! Either someone stopped DFU from initializing,");
                Railways.LOGGER.warn("[Railways DFU]  or this Minecraft build is hosed.");
                Railways.LOGGER.warn("[Railways DFU] Using no-op implementation.");
                instance = new NoOpDataFixesInternals();
            } else {
                instance = (Boolean)Config.DISABLE_DATAFIXER.get() != false ? new NoOpDataFixesInternals() : new DataFixesInternalsImpl(latestVanillaSchema);
            }
        }
        return instance;
    }

    public abstract void registerFixer(@Range(from=0L, to=0x7FFFFFFFL) int var1, @NotNull DataFixer var2);

    @Nullable
    public abstract DataFixerEntry getFixerEntry();

    @Contract(value="-> new", pure=true)
    @NotNull
    public abstract Schema createBaseSchema();

    @NotNull
    public abstract class_2487 updateWithAllFixers(@NotNull class_4284 var1, @NotNull class_2487 var2);

    @NotNull
    public abstract class_2487 addModDataVersions(@NotNull class_2487 var1);

    public record DataFixerEntry(DataFixer dataFixer, int currentVersion) {
    }
}

