/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.journeymap.RailwayMapPlugin;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.fabric.RailwaysClientImpl;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRCommandsClient;
import com.railwayteam.railways.registry.CRDevCaps;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRPonderIndex;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2172;
import net.minecraft.class_5601;
import net.minecraft.class_5607;

public class RailwaysClient {
    public static void init() {
        RailwaysClient.registerModelLayer(ConductorEntityModel.LAYER_LOCATION, ConductorEntityModel::createBodyLayer);
        RailwaysClient.registerModelLayer(ConductorCapModel.LAYER_LOCATION, ConductorCapModel::createBodyLayer);
        RailwaysClient.registerBuiltinPack("legacy_semaphore", "Steam 'n Rails Legacy Semaphores");
        RailwaysClient.registerBuiltinPack("green_signals", "Steam 'n Rails Green Signals");
        RailwaysClient.registerClientCommands(CRCommandsClient::register);
        CRPackets.PACKETS.registerS2CListener();
        CRPonderIndex.register();
        CRBlockPartials.init();
        CustomTrackOverlayRendering.register(CREdgePointTypes.COUPLER, CRBlockPartials.COUPLER_BOTH);
        CustomTrackOverlayRendering.register(CREdgePointTypes.SWITCH, CRBlockPartials.SWITCH_RIGHT_TURN);
        Mods.JOURNEYMAP.executeIfInstalled(() -> RailwayMapPlugin::load);
        CRDevCaps.register();
        CRBogeyStyles.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerClientCommands(Consumer<CommandDispatcher<class_2172>> consumer) {
        RailwaysClientImpl.registerClientCommands(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayer(class_5601 layer, Supplier<class_5607> definition) {
        void var1_1;
        RailwaysClientImpl.registerModelLayer(layer, (Supplier<class_5607>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBuiltinPack(String id, String name) {
        void var1_1;
        RailwaysClientImpl.registerBuiltinPack(id, (String)var1_1);
    }
}

