/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Config;
import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.base.data.lang.CRLangPartials;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysStandardRecipeGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.fabric.RailwaysImpl;
import com.railwayteam.railways.registry.CRCommands;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.LangPartial;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Railways {
    public static final String MODID = "railways";
    public static final Logger LOGGER = LogManager.getLogger((String)"railways");
    public static final String VERSION = Railways.findVersion();
    public static final int DATA_FIXER_VERSION = 1;
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"railways").creativeModeTab(() -> CRItems.mainCreativeTab, "Create Steam 'n Rails");
    @ApiStatus.Internal
    public static boolean trackEdgeTemporarilyFlipped;
    @ApiStatus.Internal
    public static boolean trackEdgeCarriageTravelling;
    @ApiStatus.Internal
    public static boolean temporarilySkipSwitches;

    public static void init() {
        Railways.registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        Railways.registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        Path configDir = Utils.configDir();
        Config.loadConfig(Config.CLIENT_CONFIG, configDir.resolve("railways-client.toml"));
        Config.loadConfig(Config.SERVER_CONFIG, configDir.resolve("railways-common.toml"));
        ModSetup.register();
        Railways.finalizeRegistrate();
        Railways.registerCommands(CRCommands::register);
        CRPackets.PACKETS.registerC2SListener();
        if (Utils.isDevEnv() && !Mods.BYG.isLoaded && !Mods.SODIUM.isLoaded) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    public static class_2960 asResource(String name) {
        return new class_2960(MODID, name);
    }

    public static void gatherData(class_2403 gen) {
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, CRTagGen::generateBlockTags);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CRTagGen::generateItemTags);
        gen.method_10314((class_2405)RailwaysSequencedAssemblyRecipeGen.create(gen));
        gen.method_10314((class_2405)RailwaysStandardRecipeGen.create(gen));
        PonderLocalization.provideRegistrateLang((AbstractRegistrate)REGISTRATE);
        gen.method_10314((class_2405)new LangMerger(gen, MODID, "Steam 'n Rails", (LangPartial[])CRLangPartials.values()));
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String findVersion() {
        return RailwaysImpl.findVersion();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        RailwaysImpl.finalizeRegistrate();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerCommands(BiConsumer<CommandDispatcher<class_2168>, Boolean> consumer) {
        RailwaysImpl.registerCommands(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerConfig(ModConfig.Type type, ForgeConfigSpec spec) {
        void var1_1;
        RailwaysImpl.registerConfig(type, (ForgeConfigSpec)var1_1);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((class_1792)item))));
        trackEdgeTemporarilyFlipped = false;
        trackEdgeCarriageTravelling = false;
        temporarilySkipSwitches = false;
    }
}

