/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonArray;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.StringBuilderAppendable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2479;
import net.minecraft.class_2483;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class ListJS
extends ArrayList<Object>
implements StringBuilderAppendable,
ChangeListener<Object>,
Copyable,
JsonSerializable,
NBTSerializable {
    public ChangeListener<ListJS> changeListener;

    @Nullable
    public static ListJS of(@Nullable Object o) {
        Object o1 = UtilsJS.wrap(o, JSObjectType.LIST);
        return o1 instanceof ListJS ? (ListJS)o1 : null;
    }

    public static ListJS orSelf(@Nullable Object o) {
        ListJS l = ListJS.of(o);
        if (l != null) {
            return l;
        }
        ListJS list = new ListJS(1);
        if (o != null) {
            list.add(o);
        }
        return list;
    }

    public static ListJS ofArray(Object array) {
        if (array instanceof Object[]) {
            ListJS list = new ListJS();
            Collections.addAll(list, (Object[])array);
            return list;
        }
        if (array instanceof int[]) {
            return ListJS.of((int[])array);
        }
        if (array instanceof byte[]) {
            return ListJS.of((byte[])array);
        }
        if (array instanceof short[]) {
            return ListJS.of((short[])array);
        }
        if (array instanceof long[]) {
            return ListJS.of((long[])array);
        }
        if (array instanceof float[]) {
            return ListJS.of((float[])array);
        }
        if (array instanceof double[]) {
            return ListJS.of((double[])array);
        }
        if (array instanceof char[]) {
            return ListJS.of((char[])array);
        }
        return new ListJS(0);
    }

    public static ListJS of(byte[] array) {
        ListJS list = new ListJS(array.length);
        for (byte v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(short[] array) {
        ListJS list = new ListJS(array.length);
        for (short v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(int[] array) {
        ListJS list = new ListJS(array.length);
        for (int v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(long[] array) {
        ListJS list = new ListJS(array.length);
        for (long v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(float[] array) {
        ListJS list = new ListJS(array.length);
        for (float v : array) {
            list.add(Float.valueOf(v));
        }
        return list;
    }

    public static ListJS of(double[] array) {
        ListJS list = new ListJS(array.length);
        for (double v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(char[] array) {
        ListJS list = new ListJS(array.length);
        for (char v : array) {
            list.add(Character.valueOf(v));
        }
        return list;
    }

    @Nullable
    public static JsonArray json(@Nullable Object array) {
        if (array instanceof JsonArray) {
            JsonArray arr = (JsonArray)array;
            return arr;
        }
        if (array instanceof CharSequence) {
            try {
                return (JsonArray)JsonIO.GSON.fromJson(array.toString(), JsonArray.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        ListJS l = ListJS.of(array);
        return l == null ? null : l.toJson();
    }

    @Deprecated
    @Nullable
    public static class_2483<?> nbt(@Nullable Object list) {
        return NBTUtils.toTagCollection((Object)list);
    }

    public ListJS() {
        this(0);
    }

    public ListJS(int s) {
        super(s);
    }

    public int getLength() {
        return this.size();
    }

    public ListJS push(Object ... o) {
        if (o.length == 0) {
            return this;
        }
        if (o.length == 1) {
            this.add(o[0]);
            return this;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(Arrays.asList(o));
        this.onChanged(null);
        return this;
    }

    @Nullable
    public Object pop() {
        if (!this.isEmpty()) {
            return this.remove(this.size() - 1);
        }
        return null;
    }

    @Nullable
    public Object shift() {
        if (!this.isEmpty()) {
            return this.remove(0);
        }
        return null;
    }

    public ListJS unshift(Object ... o) {
        if (o.length == 0) {
            return this;
        }
        if (o.length == 1) {
            this.add(0, o[0]);
            return this;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(0, Arrays.asList(o));
        this.onChanged(null);
        return this;
    }

    public ListJS reverse() {
        Collections.reverse(this);
        this.onChanged(null);
        return this;
    }

    public ListJS filter(Predicate<Object> predicate) {
        ListJS list = new ListJS();
        for (Object o : this) {
            if (!predicate.test(o)) continue;
            list.add(o);
        }
        return list;
    }

    public ListJS map(Function<Object, Object> transformer) {
        ListJS list = new ListJS();
        for (Object o : this) {
            list.add(transformer.apply(o));
        }
        return list;
    }

    public ListJS splice(int pos, int deleteCount, Object ... items) {
        int i;
        for (i = 0; i < deleteCount; ++i) {
            this.remove(pos);
        }
        if (items.length == 0) {
            return this;
        }
        if (items.length == 1) {
            this.add(pos, items[0]);
            return this;
        }
        for (i = 0; i < items.length; ++i) {
            items[i] = UtilsJS.wrap(items[i], JSObjectType.ANY);
            this.setChangeListener(items[i]);
        }
        super.addAll(pos, Arrays.asList(items));
        this.onChanged(null);
        return this;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        this.appendString(builder);
        return builder.toString();
    }

    public void appendString(StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append("[]");
            return;
        }
        builder.append('[');
        for (int i = 0; i < this.size(); ++i) {
            Object o;
            if (i > 0) {
                builder.append(',');
            }
            if ((o = this.get(i)) instanceof StringBuilderAppendable) {
                StringBuilderAppendable appendable = (StringBuilderAppendable)o;
                appendable.appendString(builder);
                continue;
            }
            builder.append(o);
        }
        builder.append(']');
    }

    public ListJS copy() {
        ListJS list = new ListJS(this.size());
        for (Object object : this) {
            list.add(UtilsJS.copy(object));
        }
        return list;
    }

    protected boolean setChangeListener(@Nullable Object v) {
        if (v instanceof MapJS) {
            MapJS map = (MapJS)v;
            map.changeListener = this::onChanged;
        } else if (v instanceof ListJS) {
            ListJS list = (ListJS)v;
            list.changeListener = this::onChanged;
        }
        return true;
    }

    public void onChanged(@Nullable Object o) {
        if (this.changeListener != null) {
            this.changeListener.onChanged((Object)this);
        }
    }

    @Override
    public boolean add(Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (this.setChangeListener(v)) {
            return super.add(v);
        }
        return false;
    }

    @Override
    public void add(int index, Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (this.setChangeListener(v)) {
            super.add(index, v);
        }
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object[] o = c.toArray();
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(Arrays.asList(o));
        this.onChanged(null);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object[] o = c.toArray();
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(index, Arrays.asList(o));
        this.onChanged(null);
        return true;
    }

    @Override
    public Object remove(int index) {
        Object o = super.remove(index);
        this.onChanged(null);
        return o;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            this.onChanged(null);
        }
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        this.onChanged(null);
    }

    public JsonArray toJson() {
        JsonArray json = new JsonArray();
        for (Object o : this) {
            json.add(JsonIO.of(o));
        }
        return json;
    }

    public class_2483<?> toNBT() {
        Object[] array;
        if (this.isEmpty()) {
            return new class_2499();
        }
        class_2520[] values = new class_2520[this.size()];
        int s = 0;
        byte commmonId = -1;
        for (Object o : this) {
            values[s] = NBTUtils.toTag(o);
            if (values[s] == null) continue;
            if (commmonId == -1) {
                commmonId = values[s].method_10711();
            } else if (commmonId != values[s].method_10711()) {
                commmonId = 0;
            }
            ++s;
        }
        if (commmonId == 3) {
            array = new int[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((class_2514)values[i]).method_10701();
            }
            return new class_2495(array);
        }
        if (commmonId == 1) {
            array = new byte[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((class_2514)values[i]).method_10698();
            }
            return new class_2479((byte[])array);
        }
        if (commmonId == 4) {
            array = new long[s];
            for (int i = 0; i < s; ++i) {
                array[i] = (int)((class_2514)values[i]).method_10699();
            }
            return new class_2501((long[])array);
        }
        if (commmonId == 0 || commmonId == -1) {
            return new class_2499();
        }
        class_2499 nbt = new class_2499();
        for (class_2520 nbt1 : values) {
            if (nbt1 == null) {
                return nbt;
            }
            nbt.add((Object)nbt1);
        }
        return nbt;
    }
}

