/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryEventJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.DataPackEventJS;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.server.KubeJSServerResourcePack;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5350;
import net.minecraft.class_6860;
import net.minecraft.class_6861;

public class ServerScriptManager {
    public static ServerScriptManager instance;
    public final ScriptManager scriptManager = new ScriptManager(ScriptType.SERVER, KubeJSPaths.SERVER_SCRIPTS, "/data/kubejs/example_server_script.js");

    public ServerScriptManager() {
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    public void updateResources(class_5350 serverResources) {
        KubeJSReloadListener.resources = serverResources;
        KubeJSReloadListener.recipeContext = RecipePlatformHelper.get().createRecipeContext(serverResources);
    }

    public void reloadScriptManager(class_3300 resourceManager) {
        this.scriptManager.unload();
        this.scriptManager.loadFromDirectory();
        HashMap<String, List> packs = new HashMap<String, List>();
        for (class_2960 class_29602 : resourceManager.method_14488("kubejs", s -> s.endsWith(".js"))) {
            packs.computeIfAbsent(class_29602.method_12836(), s -> new ArrayList()).add(class_29602);
        }
        for (Map.Entry entry : packs.entrySet()) {
            ScriptPack pack = new ScriptPack(this.scriptManager, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (class_2960 id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.method_12832().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource.FromResource scriptSource = info -> resourceManager.method_14486(info.id);
                Throwable error = fileInfo.preload(scriptSource);
                if (fileInfo.isIgnored()) continue;
                if (error == null) {
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.scriptManager.packs.put(pack.info.namespace, pack);
        }
        this.scriptManager.load();
    }

    public class_6861 wrapResourceManager(class_6860 original) {
        List list;
        VirtualKubeJSDataPack virtualDataPackLow = new VirtualKubeJSDataPack(false);
        VirtualKubeJSDataPack virtualDataPackHigh = new VirtualKubeJSDataPack(true);
        if (original instanceof class_6861) {
            class_6861 mp = (class_6861)original;
            list = mp.field_36390;
        } else {
            list = original.method_29213().toList();
        }
        LinkedList list2 = new LinkedList(list);
        list2.addFirst(virtualDataPackLow);
        list2.addLast(new KubeJSServerResourcePack());
        list2.addLast(virtualDataPackHigh);
        class_6861 wrappedResourceManager = new class_6861(class_3264.field_14190, list2);
        this.reloadScriptManager((class_3300)wrappedResourceManager);
        ConsoleJS.SERVER.setLineNumber(true);
        new DataPackEventJS(virtualDataPackLow, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.last");
        new DataPackEventJS(virtualDataPackLow, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.low_priority");
        new DataPackEventJS(virtualDataPackHigh, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.first");
        new DataPackEventJS(virtualDataPackHigh, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.high_priority");
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Scripts loaded");
        HashMap<class_2960, RecipeTypeJS> typeMap = new HashMap<class_2960, RecipeTypeJS>();
        RegisterRecipeHandlersEvent modEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(modEvent));
        new RecipeTypeRegistryEventJS(typeMap).post(ScriptType.SERVER, "recipes.type_registry");
        if (Platform.isForge()) {
            RecipeEventJS.customIngredientMap = new HashMap<UUID, IngredientWithCustomPredicateJS>();
        }
        RecipeEventJS.modifyResultCallbackMap = new HashMap<UUID, ModifyRecipeResultCallback>();
        CustomIngredientAction.MAP.clear();
        RecipeEventJS.instance = new RecipeEventJS(typeMap);
        return wrappedResourceManager;
    }
}

