/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ShapedKubeJSRecipe
extends class_1869 {
    private final boolean mirror;
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;

    public ShapedKubeJSRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 result, boolean mirror, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult) {
        super(id, group, width, height, ingredients, result);
        this.mirror = mirror;
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
    }

    public class_1865<?> method_8119() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    public boolean method_17728(class_1715 craftingContainer, class_1937 level) {
        for (int i = 0; i <= craftingContainer.method_17398() - this.field_9055; ++i) {
            for (int j = 0; j <= craftingContainer.method_17397() - this.field_9054; ++j) {
                if (this.mirror && this.method_8161(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.method_8161(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public class_1799 method_17727(class_1715 container) {
        if (this.modifyResult != null) {
            return this.modifyResult.modify(new ModifyRecipeCraftingGrid(container), ItemStackJS.of(this.method_8110().method_7972())).getItemStack();
        }
        return this.method_8110().method_7972();
    }

    public class_2371<class_1799> getRemainingItems(class_1715 container) {
        class_2371 list = class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapedKubeJSRecipe> {
        private static final class_1865<class_1869> SHAPED = (class_1865)UtilsJS.cast(KubeJSRegistries.recipeSerializers().get(new class_2960("crafting_shaped")));

        public ShapedKubeJSRecipe fromJson(class_2960 id, JsonObject json) {
            class_1869 shapedRecipe = (class_1869)SHAPED.method_8121(id, json);
            boolean mirror = class_3518.method_15258((JsonObject)json, (String)"mirror", (boolean)true);
            boolean shrink = class_3518.method_15258((JsonObject)json, (String)"shrink", (boolean)true);
            Map key = class_1869.method_8157((JsonObject)class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] pattern = class_1869.method_8145((JsonArray)class_3518.method_15261((JsonObject)json, (String)"pattern"));
            if (shrink) {
                pattern = class_1869.method_8146((String[])pattern);
            }
            int w = pattern[0].length();
            int h = pattern.length;
            class_2371 ingredients = class_1869.method_8148((String[])pattern, (Map)key, (int)w, (int)h);
            List<IngredientAction> ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            ModifyRecipeResultCallback modifyResult = null;
            if (json.has("kubejs_modify_result")) {
                modifyResult = RecipeEventJS.modifyResultCallbackMap.get(UUIDTypeAdapter.fromString((String)json.get("kubejs_modify_result").getAsString()));
            }
            return new ShapedKubeJSRecipe(id, shapedRecipe.method_8112(), w, h, (class_2371<class_1856>)ingredients, shapedRecipe.method_8110(), mirror, ingredientActions, modifyResult);
        }

        public ShapedKubeJSRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_1869 shapedRecipe = (class_1869)SHAPED.method_8122(id, buf);
            boolean mirror = buf.readBoolean();
            List<IngredientAction> ingredientActions = IngredientAction.readList(buf);
            String group = shapedRecipe.method_8112();
            int width = shapedRecipe.method_8150();
            int height = shapedRecipe.method_8158();
            class_2371 ingredients = shapedRecipe.method_8117();
            class_1799 result = shapedRecipe.method_8110();
            return new ShapedKubeJSRecipe(id, group, width, height, (class_2371<class_1856>)ingredients, result, mirror, ingredientActions, null);
        }

        public void toNetwork(class_2540 buf, ShapedKubeJSRecipe r) {
            SHAPED.method_8124(buf, (class_1860)r);
            buf.writeBoolean(r.mirror);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

