/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.recipe.CustomRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.MissingRecipeFunctionException;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeFunction;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RecipeEventJS
extends EventJS {
    public static final String FORGE_CONDITIONAL = "forge:conditional";
    private static final Pattern SKIP_ERROR = Pattern.compile("at dev.latvian.mods.kubejs.recipe.RecipeEventJS.post");
    public static Map<UUID, IngredientWithCustomPredicateJS> customIngredientMap = null;
    public static Map<UUID, ModifyRecipeResultCallback> modifyResultCallbackMap = null;
    public static RecipeEventJS instance;
    private final List<class_1860<?>> fallbackedRecipes = new ArrayList();
    private final List<RecipeJS> originalRecipes = new ArrayList<RecipeJS>();
    final List<RecipeJS> addedRecipes;
    private final Set<RecipeJS> removedRecipes;
    private final Set<RecipeJS> modifiedRecipes;
    private final Map<String, Object> recipeFunctions;
    private AtomicInteger modifiedRecipesCount;
    public final RecipeFunction shaped;
    public final RecipeFunction shapeless;
    public final RecipeFunction smelting;
    public final RecipeFunction blasting;
    public final RecipeFunction smoking;
    public final RecipeFunction campfireCooking;
    public final RecipeFunction stonecutting;
    public final RecipeFunction smithing;

    public RecipeEventJS(Map<class_2960, RecipeTypeJS> t) {
        ConsoleJS.SERVER.info("Scanning recipes...");
        this.addedRecipes = new ArrayList<RecipeJS>();
        this.removedRecipes = new HashSet<RecipeJS>();
        this.modifiedRecipes = new HashSet<RecipeJS>();
        this.recipeFunctions = new HashMap<String, Object>();
        HashMap<String, Map> serializers = new HashMap<String, Map>();
        for (Map.Entry entry : KubeJSRegistries.recipeSerializers().entrySet()) {
            serializers.computeIfAbsent(((class_5321)entry.getKey()).method_29177().method_12836(), n -> new HashMap()).put(((class_5321)entry.getKey()).method_29177().method_12832(), (class_1865)entry.getValue());
        }
        for (Map.Entry entry : serializers.entrySet()) {
            HashMap<String, RecipeFunction> funcs = new HashMap<String, RecipeFunction>();
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                class_2960 location;
                RecipeTypeJS typeJS = t.get(location = new class_2960((String)entry.getKey(), (String)entry1.getKey()));
                RecipeFunction func = new RecipeFunction(this, location, typeJS != null ? typeJS : new CustomRecipeTypeJS((class_1865)entry1.getValue()));
                funcs.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry1.getKey()), func);
                funcs.put((String)entry1.getKey(), func);
                this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey() + "_" + (String)entry1.getKey()), func);
                this.recipeFunctions.put((String)entry.getKey() + "_" + (String)entry1.getKey(), func);
            }
            this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey()), funcs);
            this.recipeFunctions.put((String)entry.getKey(), funcs);
        }
        SpecialRecipeSerializerManager.INSTANCE.reset();
        SpecialRecipeSerializerManager.INSTANCE.post(ScriptType.SERVER, "recipes.serializer.special.flag");
        this.shaped = this.getRecipeFunction(CommonProperties.get().serverOnly ? "minecraft:crafting_shaped" : "kubejs:shaped");
        this.shapeless = this.getRecipeFunction(CommonProperties.get().serverOnly ? "minecraft:crafting_shapeless" : "kubejs:shapeless");
        this.smelting = this.getRecipeFunction("minecraft:smelting");
        this.blasting = this.getRecipeFunction("minecraft:blasting");
        this.smoking = this.getRecipeFunction("minecraft:smoking");
        this.campfireCooking = this.getRecipeFunction("minecraft:campfire_cooking");
        this.stonecutting = this.getRecipeFunction("minecraft:stonecutting");
        this.smithing = this.getRecipeFunction("minecraft:smithing");
    }

    @HideFromJS
    public void post(class_1863 recipeManager, Map<class_2960, JsonObject> jsonMap) {
        RecipeJS.itemErrors = false;
        TagIngredientJS.context = KubeJSReloadListener.resources.field_25338.method_40096().stream().filter(result -> result.comp_328() == class_2378.field_25108).findFirst().map(result -> TagIngredientJS.Context.usingResult((class_3505.class_6863<class_1792>)((class_3505.class_6863)UtilsJS.cast(result)))).orElseGet(() -> {
            ConsoleJS.SERVER.warn("Failed to load item tags during recipe event! Using replaceInput etc. will not work!");
            return TagIngredientJS.Context.EMPTY;
        });
        ConsoleJS.SERVER.setLineNumber(true);
        Stopwatch timer = Stopwatch.createStarted();
        JsonObject allRecipeMap = new JsonObject();
        for (Map.Entry<class_2960, JsonObject> entry : jsonMap.entrySet()) {
            class_2960 recipeId = entry.getKey();
            if (Platform.isForge() && recipeId.method_12832().startsWith("_")) continue;
            String recipeIdAndType = recipeId + "[unknown:type]";
            try {
                JsonArray array;
                JsonObject json = entry.getValue();
                String type = class_3518.method_15265((JsonObject)json, (String)"type");
                recipeIdAndType = recipeId + "[" + type + "]";
                if (!RecipePlatformHelper.get().processConditions(recipeManager, json, "conditions")) {
                    if (!ServerSettings.instance.logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                if (type.equals(FORGE_CONDITIONAL)) {
                    JsonArray items = class_3518.method_15261((JsonObject)json, (String)"recipes");
                    boolean skip = true;
                    for (int idx = 0; idx < items.size(); ++idx) {
                        JsonElement e = items.get(idx);
                        if (!e.isJsonObject()) {
                            throw new RecipeExceptionJS("Invalid recipes entry at index " + idx + " Must be JsonObject");
                        }
                        JsonObject o = e.getAsJsonObject();
                        if (!RecipePlatformHelper.get().processConditions(recipeManager, o, "conditions")) continue;
                        json = o.get("recipe").getAsJsonObject();
                        type = class_3518.method_15265((JsonObject)json, (String)"type");
                        recipeIdAndType = recipeId + "[" + type + "]";
                        skip = false;
                        break;
                    }
                    if (skip) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                        continue;
                    }
                }
                RecipeFunction function = this.getRecipeFunction(type);
                if (function.type == null) {
                    throw new MissingRecipeFunctionException("Unknown recipe type!").fallback();
                }
                RecipeJS recipe2 = function.type.factory.get();
                recipe2.id = recipeId;
                recipe2.type = function.type;
                recipe2.json = json;
                recipe2.originalRecipe = RecipePlatformHelper.get().fromJson(recipe2);
                if (recipe2.originalRecipe == null) {
                    if (!ServerSettings.instance.logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                recipe2.deserializeJson();
                this.originalRecipes.add(recipe2);
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    if (SpecialRecipeSerializerManager.INSTANCE.isSpecial(recipe2.originalRecipe)) {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": <dynamic>");
                    } else {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": " + recipe2.getFromToString());
                    }
                }
                if (ServerSettings.dataExport == null) continue;
                JsonObject exp = new JsonObject();
                exp.add("recipe", (JsonElement)json);
                if (!recipe2.inputItems.isEmpty()) {
                    array = new JsonArray();
                    for (IngredientJS in : recipe2.inputItems) {
                        array.add(in.toJson());
                    }
                    exp.add("inputs", (JsonElement)array);
                }
                if (!recipe2.outputItems.isEmpty()) {
                    array = new JsonArray();
                    for (ItemStackJS out : recipe2.outputItems) {
                        array.add(out.toResultJson());
                    }
                    exp.add("outputs", (JsonElement)array);
                }
                allRecipeMap.add(recipe2.getId(), (JsonElement)exp);
            }
            catch (Throwable ex) {
                block31: {
                    block30: {
                        if (!(ex instanceof RecipeExceptionJS)) break block30;
                        RecipeExceptionJS rex = (RecipeExceptionJS)ex;
                        if (!rex.fallback) break block31;
                    }
                    if (ServerSettings.instance.logErroringRecipes) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'! Falling back to vanilla", ex, SKIP_ERROR);
                    }
                    try {
                        this.fallbackedRecipes.add(Objects.requireNonNull(class_1863.method_17720((class_2960)recipeId, (JsonObject)entry.getValue())));
                    }
                    catch (JsonParseException | IllegalArgumentException | NullPointerException ex2) {
                        if (!ServerSettings.instance.logErroringRecipes) continue;
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType, ex2, SKIP_ERROR);
                    }
                    catch (Exception ex3) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType + ":");
                        ConsoleJS.SERVER.printStackTrace(ex3, SKIP_ERROR);
                    }
                    continue;
                }
                if (!ServerSettings.instance.logErroringRecipes) continue;
                ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'", ex, SKIP_ERROR);
            }
        }
        MutableInt removed = new MutableInt(0);
        MutableInt added = new MutableInt(0);
        MutableInt failed = new MutableInt(0);
        MutableInt fallbacked = new MutableInt(0);
        this.modifiedRecipesCount = new AtomicInteger(0);
        ConsoleJS.SERVER.info("Found " + this.originalRecipes.size() + " recipes and " + this.fallbackedRecipes.size() + " failed recipes in " + timer.stop());
        timer.reset().start();
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, "recipes");
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Posted recipe events in " + timer.stop());
        HashMap recipesByName = new HashMap();
        timer.reset().start();
        this.originalRecipes.stream().filter(recipe -> {
            if (this.removedRecipes.contains(recipe)) {
                removed.increment();
                return false;
            }
            return true;
        }).map(recipe -> {
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error parsing recipe " + recipe + ": " + recipe.json, ex);
                failed.increment();
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).forEach(recipe -> {
            class_2960 id = recipe.method_8114();
            class_2960 ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.method_8119());
            class_1860 oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                class_2960 oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.method_8119());
                if (ServerSettings.instance.logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.method_8114() + "[" + oldSer + " => " + ser + "] during phase PARSE!");
                }
            }
        });
        this.fallbackedRecipes.stream().filter(Objects::nonNull).forEach(recipe -> {
            class_2960 id = recipe.method_8114();
            class_2960 ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.method_8119());
            class_1860 oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                class_2960 oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.method_8119());
                if (ServerSettings.instance.logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.method_8114() + "[" + oldSer + " => " + ser + "] during phase FALLBACK!");
                }
            }
        });
        ConsoleJS.SERVER.info("Modified & removed recipes in " + timer.stop());
        timer.reset().start();
        this.addedRecipes.stream().map(recipe -> {
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error creating recipe " + recipe + ": " + recipe.json, ex, SKIP_ERROR);
                failed.increment();
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).forEach(recipe -> {
            added.increment();
            class_2960 id = recipe.method_8114();
            class_2960 ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.method_8119());
            class_1860 oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                class_2960 oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.method_8119());
                if (ServerSettings.instance.logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.method_8114() + "[" + oldSer + " => " + ser + "] during phase ADD!");
                }
                removed.increment();
            }
        });
        if (ServerSettings.dataExport != null) {
            for (RecipeJS r : this.removedRecipes) {
                JsonElement jsonElement = allRecipeMap.get(r.getId());
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject json = (JsonObject)jsonElement;
                json.addProperty("removed", Boolean.valueOf(true));
            }
            ServerSettings.dataExport.add("recipes", (JsonElement)allRecipeMap);
        }
        ConsoleJS.SERVER.info("Added recipes in " + timer.stop());
        HashMap newRecipeMap = (HashMap)class_156.method_654(new HashMap(), map -> recipesByName.forEach((id, recipe) -> {
            class_3956 type = recipe.method_17716();
            Map recipes = map.computeIfAbsent(type, t -> new HashMap());
            recipes.put(id, recipe);
        }));
        RecipePlatformHelper.get().pingNewRecipes(newRecipeMap);
        recipeManager.field_36308 = recipesByName;
        recipeManager.field_9023 = newRecipeMap;
        ConsoleJS.SERVER.info("Added " + added.getValue() + " recipes, removed " + removed.getValue() + " recipes, modified " + this.modifiedRecipesCount.get() + " recipes, with " + failed.getValue() + " failed recipes and " + fallbacked.getValue() + " fall-backed recipes");
        RecipeJS.itemErrors = false;
        if (CommonProperties.get().debugInfo) {
            ConsoleJS.SERVER.info("======== Debug output of all added recipes ========");
            for (RecipeJS r : this.addedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
            ConsoleJS.SERVER.info("======== Debug output of all modified recipes ========");
            for (RecipeJS r : this.modifiedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json + " FROM " + r.originalJson);
            }
            ConsoleJS.SERVER.info("======== Debug output of all removed recipes ========");
            for (RecipeJS r : this.removedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
        }
    }

    public Map<String, Object> getRecipes() {
        return this.recipeFunctions;
    }

    public RecipeJS addRecipe(RecipeJS r, RecipeTypeJS type, ListJS args1) {
        this.addedRecipes.add(r);
        if (ServerSettings.instance.logAddedRecipes) {
            ConsoleJS.SERVER.info("+ " + r.getType() + ": " + r.getFromToString());
        } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.debug("+ " + r.getType() + ": " + r.getFromToString());
        }
        return r;
    }

    public RecipeFilter customFilter(RecipeFilter filter) {
        return filter;
    }

    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.originalRecipes.stream().filter(filter).forEach(consumer);
        }
    }

    public void forEachRecipeAsync(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.parallelStream().forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.originalRecipes.parallelStream().filter(filter).forEach(consumer);
        }
    }

    public int countRecipes(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return this.originalRecipes.size();
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return (int)this.originalRecipes.stream().filter(filter).count();
        }
        return 0;
    }

    public boolean containsRecipe(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return true;
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return this.originalRecipes.parallelStream().anyMatch(filter);
        }
        return false;
    }

    public int remove(RecipeFilter filter) {
        MutableInt count = new MutableInt();
        this.forEachRecipe(filter, r -> {
            if (this.removedRecipes.add((RecipeJS)r)) {
                if (ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("- " + r + ": " + r.getFromToString());
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("- " + r + ": " + r.getFromToString());
                }
                count.increment();
            }
        });
        return count.getValue();
    }

    public int replaceInput(RecipeFilter filter, IngredientJS ingredient, IngredientJS with, boolean exact) {
        AtomicInteger count = new AtomicInteger();
        String is = ingredient.toString();
        String ws = with.toString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceInput(ingredient, with, exact)) {
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": IN " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": IN " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceInput(RecipeFilter filter, IngredientJS ingredient, IngredientJS with) {
        return this.replaceInput(filter, ingredient, with, false);
    }

    public int replaceInput(IngredientJS ingredient, IngredientJS with) {
        return this.replaceInput(RecipeFilter.ALWAYS_TRUE, ingredient, with);
    }

    public int replaceOutput(RecipeFilter filter, IngredientJS ingredient, ItemStackJS with, boolean exact) {
        AtomicInteger count = new AtomicInteger();
        String is = ingredient.toString();
        String ws = with.toString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceOutput(ingredient, with, exact)) {
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": OUT " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": OUT " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceOutput(RecipeFilter filter, IngredientJS ingredient, ItemStackJS with) {
        return this.replaceOutput(filter, ingredient, with, false);
    }

    public int replaceOutput(IngredientJS ingredient, ItemStackJS with) {
        return this.replaceOutput(RecipeFilter.ALWAYS_TRUE, ingredient, with);
    }

    public RecipeFunction getRecipeFunction(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("Recipe type is null!");
        }
        String namespace = UtilsJS.getNamespace(id);
        String path = UtilsJS.getPath(id);
        Object func0 = this.recipeFunctions.get(namespace);
        if (func0 instanceof RecipeFunction) {
            RecipeFunction fn = (RecipeFunction)func0;
            return fn;
        }
        if (!(func0 instanceof Map)) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        RecipeFunction func = (RecipeFunction)((Map)func0).get(path);
        if (func == null) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        return func;
    }

    public RecipeJS custom(Object o) {
        MapJS json = Objects.requireNonNull(MapJS.of(o));
        return this.getRecipeFunction(json.getOrDefault("type", "").toString()).createRecipe(new Object[]{json});
    }

    public void printTypes() {
        ConsoleJS.SERVER.info("== All recipe types [used] ==");
        HashSet list = new HashSet();
        this.originalRecipes.forEach(r -> list.add(r.type.toString()));
        list.stream().sorted().forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printAllTypes() {
        ConsoleJS.SERVER.info("== All recipe types [available] ==");
        List<String> list = KubeJSRegistries.recipeSerializers().entrySet().stream().map(e -> ((class_5321)e.getKey()).method_29177().toString()).sorted().toList();
        list.forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ConsoleJS.SERVER.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            RecipeJS r = (RecipeJS)list.get(i);
            ConsoleJS.SERVER.info("- " + r.getOrCreateId() + ":\n" + JsonIO.toPrettyString((JsonElement)r.json));
        }
    }

    public void setItemErrors(boolean b) {
        RecipeJS.itemErrors = b;
    }

    public void stage(RecipeFilter filter, String stage) {
        this.forEachRecipe(filter, r -> r.stage(stage));
    }
}

