/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.player.ChestEventJS;
import dev.latvian.mods.kubejs.player.InventoryEventJS;
import dev.latvian.mods.kubejs.player.InventoryListener;
import dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS;
import dev.latvian.mods.kubejs.player.PlayerChatEventJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.SimplePlayerEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.stages.Stages;
import net.minecraft.class_124;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1723;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_5513;
import org.jetbrains.annotations.NotNull;

public class KubeJSPlayerEventHandler {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(KubeJSPlayerEventHandler::loggedIn);
        PlayerEvent.PLAYER_QUIT.register(KubeJSPlayerEventHandler::loggedOut);
        PlayerEvent.PLAYER_RESPAWN.register(KubeJSPlayerEventHandler::respawn);
        PlayerEvent.PLAYER_CLONE.register(KubeJSPlayerEventHandler::cloned);
        TickEvent.PLAYER_POST.register(KubeJSPlayerEventHandler::tick);
        ChatEvent.SERVER.register(KubeJSPlayerEventHandler::chat);
        PlayerEvent.PLAYER_ADVANCEMENT.register(KubeJSPlayerEventHandler::advancement);
        PlayerEvent.OPEN_MENU.register(KubeJSPlayerEventHandler::inventoryOpened);
        PlayerEvent.CLOSE_MENU.register(KubeJSPlayerEventHandler::inventoryClosed);
    }

    public static void loggedIn(class_3222 player) {
        if (ServerJS.instance != null) {
            ServerPlayerDataJS p = new ServerPlayerDataJS(ServerJS.instance, player.method_5667(), player.method_7334().getName(), KubeJS.nextClientHasClientMod);
            KubeJS.nextClientHasClientMod = false;
            p.getServer().playerMap.put(p.getId(), p);
            AttachDataEvent.forPlayer(p).invoke();
            new SimplePlayerEventJS((class_1657)player).post("player.logged_in");
            player.field_7498.method_7596((class_1712)new InventoryListener(player));
        }
        if (!ScriptType.SERVER.errors.isEmpty() && !CommonProperties.get().hideServerScriptErrors) {
            player.method_7353((class_2561)new class_2585("KubeJS errors found [" + ScriptType.SERVER.errors.size() + "]! Run ").method_10852((class_2561)new class_2585("'/kubejs errors'").click(new class_2558(class_2558.class_2559.field_11750, "/kubejs errors")).hover((class_2561)new class_2585("Click to run"))).method_10852((class_2561)new class_2585(" for more info")).method_27692(class_124.field_1079), false);
        }
        Stages.get((class_1657)player).sync();
    }

    private static void respawn(class_3222 player, boolean b) {
        Stages.get((class_1657)player).sync();
    }

    public static void loggedOut(class_3222 player) {
        if (ServerJS.instance == null || !ServerJS.instance.playerMap.containsKey(player.method_5667())) {
            return;
        }
        new SimplePlayerEventJS((class_1657)player).post("player.logged_out");
        ServerJS.instance.playerMap.remove(player.method_5667());
    }

    public static void cloned(class_3222 oldPlayer, class_3222 newPlayer, boolean wonGame) {
        newPlayer.getPersistentDataKJS().method_10543(oldPlayer.getPersistentDataKJS());
        newPlayer.field_7498.method_7596((class_1712)new InventoryListener(newPlayer));
    }

    public static void tick(class_1657 player) {
        if (ServerJS.instance != null && player instanceof class_3222) {
            new SimplePlayerEventJS(player).post("player.tick");
        }
    }

    @NotNull
    public static EventResult chat(class_3222 player, class_5513.class_5837 message, ChatEvent.ChatComponent component) {
        PlayerChatEventJS event = new PlayerChatEventJS(player, message.method_33801(), component.getRaw());
        component.setRaw(event.component);
        if (event.post("player.chat")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static void advancement(class_3222 player, class_161 advancement) {
        new PlayerAdvancementEventJS(player, advancement).post("player.advancement");
    }

    public static void inventoryOpened(class_1657 player, class_1703 menu) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!(menu instanceof class_1723)) {
                menu.method_7596((class_1712)new InventoryListener(serverPlayer));
            }
        }
        new InventoryEventJS(player, menu).post("player.inventory.opened");
        if (menu instanceof class_1707) {
            new ChestEventJS(player, menu).post("player.chest.opened");
        }
    }

    public static void inventoryClosed(class_1657 player, class_1703 menu) {
        new InventoryEventJS(player, menu).post("player.inventory.closed");
        if (menu instanceof class_1707) {
            new ChestEventJS(player, menu).post("player.chest.closed");
        }
    }
}

