/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.util.MessageSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class EntityArrayList
extends ArrayList<EntityJS>
implements MessageSender {
    private final LevelJS level;

    public EntityArrayList(LevelJS l, int size) {
        super(size);
        this.level = l;
    }

    public EntityArrayList(LevelJS l, Iterable<? extends class_1297> entities) {
        int n;
        if (entities instanceof Collection) {
            Collection c = (Collection)entities;
            n = c.size();
        } else {
            n = 10;
        }
        this(l, n);
        for (class_1297 class_12972 : entities) {
            this.add(this.level.getEntity(class_12972));
        }
    }

    public LevelJS getLevel() {
        return this.level;
    }

    @Override
    public class_2561 getName() {
        return new class_2585("EntityList");
    }

    @Override
    public class_2561 getDisplayName() {
        return new class_2585(this.toString()).lightPurple();
    }

    @Override
    public void tell(class_2561 message) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.method_9203(message, class_156.field_25140);
        }
    }

    @Override
    public void setStatusMessage(class_2561 message) {
        for (EntityJS entity : this) {
            class_1297 class_12972 = entity.minecraftEntity;
            if (!(class_12972 instanceof class_3222)) continue;
            class_3222 player = (class_3222)class_12972;
            player.method_7353(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommand(command));
        }
        return m;
    }

    @Override
    public int runCommandSilent(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommandSilent(command));
        }
        return m;
    }

    public void kill() {
        for (EntityJS entity : this) {
            entity.kill();
        }
    }

    public void playSound(class_3414 id, float volume, float pitch) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.field_6002.method_8465(null, entity.getX(), entity.getY(), entity.getZ(), id, entity.minecraftEntity.method_5634(), volume, pitch);
        }
    }

    public void playSound(class_3414 id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public EntityArrayList filter(Predicate<EntityJS> filter) {
        if (this.isEmpty()) {
            return this;
        }
        EntityArrayList list = new EntityArrayList(this.level, this.size());
        for (EntityJS entity : this) {
            if (!filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public void sendData(String channel, @Nullable class_2487 data) {
        for (EntityJS entity : this) {
            if (!(entity instanceof PlayerJS)) continue;
            PlayerJS playerJS = (PlayerJS)entity;
            playerJS.sendData(channel, data);
        }
    }

    @Override
    public EntityJS getFirst() {
        return (EntityJS)this.get(0);
    }
}

