/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3505;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class TagIngredientJS
implements IngredientJS {
    public static Context context = Context.EMPTY;
    private final class_6862<class_1792> tag;
    private ContextualResult cachedResult;

    public static TagIngredientJS createTag(String tag) {
        return new TagIngredientJS(tag).validateTag();
    }

    public static void resetContext() {
        context = Context.EMPTY;
    }

    private TagIngredientJS(String t) {
        this.tag = Tags.item(UtilsJS.getMCID(t));
    }

    public class_2960 getTag() {
        return this.tag.comp_327();
    }

    public Collection<class_6880<class_1792>> getHolders() {
        if (this.cachedResult == null || this.cachedResult.context != context) {
            this.cachedResult = new ContextualResult(context, Sets.newLinkedHashSet(context.getTag(this.tag)));
        }
        return this.cachedResult.holders();
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.testVanilla(stack.getItemStack());
    }

    @Override
    public boolean testVanilla(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return context.areTagsBound() ? stack.method_31573(this.tag) : this.getHolders().contains(stack.method_7909().method_40131());
    }

    @Override
    public boolean testVanillaItem(class_1792 item) {
        if (item == class_1802.field_8162) {
            return false;
        }
        class_6880.class_6883 holder = item.method_40131();
        return context.areTagsBound() ? holder.method_40220(this.tag) : this.getHolders().contains(holder);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return (Set)class_156.method_654(new LinkedHashSet(), set -> {
            for (class_6880<class_1792> holder : this.getHolders()) {
                set.add(new ItemStackJS(new class_1799(holder)));
            }
        });
    }

    @Override
    public Set<class_1792> getVanillaItems() {
        return (Set)class_156.method_654(new LinkedHashSet(), set -> {
            for (class_6880<class_1792> holder : this.getHolders()) {
                set.add((class_1792)holder.comp_349());
            }
        });
    }

    @Override
    public ItemStackJS getFirst() {
        Iterator<class_6880<class_1792>> iterator = this.getHolders().iterator();
        if (iterator.hasNext()) {
            class_6880<class_1792> holder = iterator.next();
            return new ItemStackJS(new class_1799(holder));
        }
        return ItemStackJS.EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHolders().iterator().hasNext();
    }

    public String toString() {
        return "'#%s'".formatted(this.getTag());
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.getTag().toString());
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS) {
            TagIngredientJS tagIngredient = (TagIngredientJS)ingredient;
            if (this.tag.equals(tagIngredient.tag)) {
                return true;
            }
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }

    private TagIngredientJS validateTag() {
        if (RecipeJS.itemErrors && context.isEmpty(this.tag)) {
            throw new RecipeExceptionJS("Tag %s doesn't contain any items!".formatted(this)).error();
        }
        return this;
    }

    @Override
    public class_1856 createVanillaIngredient() {
        return class_1856.method_8106(this.tag);
    }

    public static interface Context {
        public static final Context EMPTY = new Context(){

            @Override
            public boolean isEmpty(class_6862<class_1792> tag) {
                return true;
            }

            @Override
            public boolean areTagsBound() {
                return false;
            }

            @Override
            public Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> tag) {
                KubeJS.LOGGER.warn("Tried to get tag {} from an empty tag context!", (Object)tag.comp_327());
                return List.of();
            }
        };
        public static final Context REGISTRY = new Context(){

            @Override
            public boolean isEmpty(class_6862<class_1792> tag) {
                return class_2378.field_11142.method_40266(tag).isEmpty();
            }

            @Override
            public boolean areTagsBound() {
                return true;
            }

            @Override
            public Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> tag) {
                return class_2378.field_11142.method_40286(tag);
            }
        };

        public boolean isEmpty(class_6862<class_1792> var1);

        public boolean areTagsBound();

        public Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> var1);

        public static Context usingResult(final class_3505.class_6863<class_1792> manager) {
            return new Context(){

                @Override
                public boolean isEmpty(class_6862<class_1792> tag) {
                    return Iterables.isEmpty(this.getTag(tag));
                }

                @Override
                public boolean areTagsBound() {
                    return false;
                }

                @Override
                public Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> tag) {
                    return manager.comp_329().getOrDefault(tag.comp_327(), class_3494.method_40088()).method_15138();
                }
            };
        }
    }

    public record ContextualResult(Context context, Collection<class_6880<class_1792>> holders) {
    }
}

