/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.core.ItemKJS;
import dev.latvian.mods.kubejs.core.ModifiableItemKJS;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.MutableToolTier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_4174;
import net.minecraft.class_5134;

public class ItemModificationProperties {
    private static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public final ItemKJS item;

    public ItemModificationProperties(ItemKJS i) {
        this.item = i;
    }

    public void setMaxStackSize(int i) {
        this.item.setMaxStackSizeKJS(i);
    }

    public void setMaxDamage(int i) {
        this.item.setMaxDamageKJS(i);
    }

    public void setBurnTime(int i) {
        this.item.setBurnTimeKJS(i);
    }

    public void setCraftingRemainder(class_1792 i) {
        this.item.setCraftingRemainderKJS(i);
    }

    public void setFireResistant(boolean b) {
        this.item.setFireResistantKJS(b);
    }

    public void setRarity(class_1814 r) {
        this.item.setRarityKJS(r);
    }

    public void setDigSpeed(float speed) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof class_1766)) {
            throw new IllegalArgumentException("Item is not a digger item (axe, shovel, etc.)!");
        }
        class_1766 diggerItem = (class_1766)itemKJS;
        diggerItem.field_7940 = speed;
    }

    public float getDigSpeed() {
        ItemKJS itemKJS = this.item;
        if (itemKJS instanceof class_1766) {
            class_1766 diggerItem = (class_1766)itemKJS;
            return diggerItem.field_7940;
        }
        throw new IllegalArgumentException("Item is not a digger item (axe, shovel, etc.)!");
    }

    public void setTier(Consumer<MutableToolTier> c) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof class_1831)) {
            throw new IllegalArgumentException("Item is not a tool/tiered item!");
        }
        class_1831 tiered = (class_1831)itemKJS;
        tiered.field_8921 = (class_1832)class_156.method_654((Object)new MutableToolTier(tiered.field_8921), c);
    }

    public void setFoodProperties(Consumer<FoodBuilder> consumer) {
        class_1792 originalItem = (class_1792)this.item;
        class_4174 fp = originalItem.method_19264();
        FoodBuilder builder = fp == null ? new FoodBuilder() : new FoodBuilder(fp);
        consumer.accept(builder);
        this.item.setFoodPropertiesKJS(builder.build());
    }

    public void setAttackDamage(double attackDamage) {
        if (this.item instanceof class_1738) {
            throw new UnsupportedOperationException("Modifying attack damage of unsupported item: " + this.item);
        }
        this.removeAttribute(class_5134.field_23721, BASE_ATTACK_DAMAGE_UUID);
        this.addAttribute(class_5134.field_23721, BASE_ATTACK_DAMAGE_UUID, "Tool modifier", attackDamage, class_1322.class_1323.field_6328);
    }

    public void setAttackSpeed(double attackSpeed) {
        if (this.item instanceof class_1738) {
            throw new UnsupportedOperationException("Modifying attack speed of unsupported item: " + this.item);
        }
        this.removeAttribute(class_5134.field_23723, BASE_ATTACK_SPEED_UUID);
        this.addAttribute(class_5134.field_23723, BASE_ATTACK_SPEED_UUID, "Tool modifier", attackSpeed, class_1322.class_1323.field_6328);
    }

    public void setArmorProtection(double armorProtection) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof class_1738)) {
            throw new UnsupportedOperationException("Modifying armor value of unsupported item: " + this.item.toString());
        }
        class_1738 armor = (class_1738)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.method_7685().method_5927()];
        this.removeAttribute(class_5134.field_23724, uuid);
        this.addAttribute(class_5134.field_23724, uuid, "Armor modifier", armorProtection, class_1322.class_1323.field_6328);
    }

    public void setArmorToughness(double armorToughness) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof class_1738)) {
            throw new UnsupportedOperationException("Modifying protection of unsupported item: " + this.item.toString());
        }
        class_1738 armor = (class_1738)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.method_7685().method_5927()];
        this.removeAttribute(class_5134.field_23725, uuid);
        this.addAttribute(class_5134.field_23725, uuid, "Armor modifier", armorToughness, class_1322.class_1323.field_6328);
    }

    public void setArmorKnockbackResistance(double knockbackResistance) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof class_1738)) {
            throw new UnsupportedOperationException("Modifying protection of unsupported item: " + this.item.toString());
        }
        class_1738 armor = (class_1738)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.method_7685().method_5927()];
        this.removeAttribute(class_5134.field_23718, uuid);
        this.addAttribute(class_5134.field_23718, uuid, "Armor modifier", knockbackResistance, class_1322.class_1323.field_6328);
    }

    public void addAttribute(class_1320 attribute, UUID uuid, String name, double d, class_1322.class_1323 operation) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Adding attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItemKJS = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<class_1320, class_1322> attributes = modifiableItemKJS.getMutableAttributeMap();
        attributes.put((Object)attribute, (Object)new class_1322(uuid, name, d, operation));
    }

    public void removeAttribute(class_1320 attribute, UUID uuid) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Removing attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItem = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<class_1320, class_1322> attributes = modifiableItem.getMutableAttributeMap();
        Collection modifiers = attributes.get((Object)attribute);
        Optional<class_1322> value = modifiers.stream().filter(modifier -> uuid.equals(modifier.method_6189())).findFirst();
        value.ifPresent(modifier -> attributes.remove((Object)attribute, modifier));
    }

    public List<class_1322> getAttributes(class_1320 attribute) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Getting attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItem = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<class_1320, class_1322> attributes = modifiableItem.getAttributeMapKJS();
        return ImmutableList.copyOf((Collection)attributes.get((Object)attribute));
    }
}

