/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public abstract class ItemBuilder
extends BuilderBase<class_1792> {
    public static final Map<String, class_1832> TOOL_TIERS = new HashMap<String, class_1832>();
    public static final Map<String, class_1741> ARMOR_TIERS = new HashMap<String, class_1741>();
    public transient int maxStackSize = 64;
    public transient int maxDamage = 0;
    public transient int burnTime = 0;
    public transient String containerItem = "minecraft:air";
    public transient Function<ItemStackJS, Collection<ItemStackJS>> subtypes = null;
    public transient class_1814 rarity = class_1814.field_8906;
    public transient boolean fireResistant;
    public transient boolean glow = false;
    public final transient List<class_2561> tooltip = new ArrayList<class_2561>();
    @Nullable
    public transient class_1761 group = KubeJS.tab;
    @Nullable
    public transient ItemColorJS colorCallback;
    public transient FoodBuilder foodBuilder = null;
    public transient Function<ItemStackJS, Color> barColor;
    public transient ToIntFunction<ItemStackJS> barWidth;
    public transient NameCallback nameGetter;
    public transient Multimap<class_2960, class_1322> attributes;
    public transient class_1839 anim = null;
    public transient ToIntFunction<ItemStackJS> useDuration = null;
    public transient UseCallback use = null;
    public transient FinishUsingCallback finishUsing = null;
    public transient ReleaseUsingCallback releaseUsing = null;
    public String texture;
    public String parentModel = "";
    public JsonObject textureJson = new JsonObject();
    public JsonObject modelJson = null;

    public static class_1741 toArmorMaterial(Object o) {
        if (o instanceof class_1741) {
            class_1741 armorMaterial = (class_1741)o;
            return armorMaterial;
        }
        String asString = String.valueOf(o);
        class_1741 armorMaterial = ARMOR_TIERS.get(asString);
        if (armorMaterial != null) {
            return armorMaterial;
        }
        String withKube = KubeJS.appendModId(asString);
        return ARMOR_TIERS.getOrDefault(withKube, (class_1741)class_1740.field_7892);
    }

    public static class_1832 toToolTier(Object o) {
        if (o instanceof class_1832) {
            class_1832 tier = (class_1832)o;
            return tier;
        }
        String asString = String.valueOf(o);
        class_1832 toolTier = TOOL_TIERS.get(asString);
        if (toolTier != null) {
            return toolTier;
        }
        String withKube = KubeJS.appendModId(asString);
        return TOOL_TIERS.getOrDefault(withKube, (class_1832)class_1834.field_8923);
    }

    public ItemBuilder(class_2960 i) {
        super(i);
        this.attributes = ArrayListMultimap.create();
    }

    @Override
    public final RegistryObjectBuilderTypes<class_1792> getRegistryType() {
        return RegistryObjectBuilderTypes.ITEM;
    }

    @Override
    public class_1792 transformObject(class_1792 obj) {
        obj.setItemBuilderKJS(this);
        return obj;
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.modelJson != null) {
            generator.json(AssetJsonGenerator.asItemModelLocation(this.id), (JsonElement)this.modelJson);
            return;
        }
        generator.itemModel(this.id, m -> {
            if (!this.parentModel.isEmpty()) {
                m.parent(this.parentModel);
            } else {
                m.parent("minecraft:item/generated");
            }
            if (this.textureJson.size() == 0) {
                this.texture(this.newID("item/", "").toString());
            }
            m.textures(this.textureJson);
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegistry(Supplier<class_310> minecraft) {
        if (this.colorCallback != null) {
            ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> this.colorCallback.getColor(ItemStackJS.of(stack), tintIndex).getArgbJS(), (Supplier[])new Supplier[]{this});
        }
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder burnTime(int v) {
        this.burnTime = v;
        return this;
    }

    public ItemBuilder containerItem(String id) {
        this.containerItem = id;
        return this;
    }

    public ItemBuilder subtypes(Function<ItemStackJS, Collection<ItemStackJS>> fn) {
        this.subtypes = fn;
        return this;
    }

    public ItemBuilder rarity(class_1814 v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder fireResistant(boolean isFireResistant) {
        this.fireResistant = isFireResistant;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(class_2561 text) {
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder group(@Nullable String g) {
        if (g == null) {
            this.group = null;
            return this;
        }
        for (class_1761 ig : class_1761.field_7921) {
            if (!ig.method_7751().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, Color c) {
        ItemColorJS itemColorJS = this.colorCallback;
        if (!(itemColorJS instanceof IndexedItemColor)) {
            if (this.colorCallback != null) {
                ConsoleJS.STARTUP.warnf("Overwriting existing dynamic item color for {} with an indexed color", this.id);
            }
            this.color((ItemColorJS)class_156.method_654((Object)new IndexedItemColor(), col -> col.add(index, c)));
        } else {
            IndexedItemColor indexed = (IndexedItemColor)itemColorJS;
            indexed.add(index, c);
        }
        return this;
    }

    public ItemBuilder color(ItemColorJS callback) {
        this.colorCallback = callback;
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.textureJson.addProperty("layer0", tex);
        return this;
    }

    public ItemBuilder texture(String key, String tex) {
        this.textureJson.addProperty(key, tex);
        return this;
    }

    public ItemBuilder textureJson(JsonObject json) {
        this.textureJson = json;
        return this;
    }

    public ItemBuilder modelJson(JsonObject json) {
        this.modelJson = json;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder barColor(Function<ItemStackJS, Color> barColor) {
        this.barColor = barColor;
        return this;
    }

    public ItemBuilder barWidth(ToIntFunction<ItemStackJS> barWidth) {
        this.barWidth = barWidth;
        return this;
    }

    public ItemBuilder name(NameCallback name) {
        this.nameGetter = name;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public class_1792.class_1793 createItemProperties() {
        class_1792 item;
        class_1792.class_1793 properties = new class_1792.class_1793();
        if (this.group != null) {
            properties.method_7892(this.group);
        }
        if (this.maxDamage > 0) {
            properties.method_7895(this.maxDamage);
        } else {
            properties.method_7889(this.maxStackSize);
        }
        properties.method_7894(this.rarity);
        if (this.fireResistant) {
            properties.method_24359();
        }
        if ((item = (class_1792)KubeJSRegistries.items().get(new class_2960(this.containerItem))) != class_1802.field_8162) {
            properties.method_7896(item);
        }
        if (this.foodBuilder != null) {
            properties.method_19265(this.foodBuilder.build());
        }
        return properties;
    }

    public ItemBuilder modifyAttribute(class_2960 attribute, String identifier, double d, class_1322.class_1323 operation) {
        this.attributes.put((Object)attribute, (Object)new class_1322(new UUID(identifier.hashCode(), identifier.hashCode()), identifier, d, operation));
        return this;
    }

    public ItemBuilder useAnimation(class_1839 animation) {
        this.anim = animation;
        return this;
    }

    public ItemBuilder useDuration(ToIntFunction<ItemStackJS> useDuration) {
        this.useDuration = useDuration;
        return this;
    }

    public ItemBuilder use(UseCallback use) {
        this.use = use;
        return this;
    }

    public ItemBuilder finishUsing(FinishUsingCallback finishUsing) {
        this.finishUsing = finishUsing;
        return this;
    }

    public ItemBuilder releaseUsing(ReleaseUsingCallback releaseUsing) {
        this.releaseUsing = releaseUsing;
        return this;
    }

    static {
        for (class_1834 class_18342 : class_1834.values()) {
            TOOL_TIERS.put(class_18342.toString().toLowerCase(), (class_1832)class_18342);
        }
        for (class_1834 class_18343 : class_1740.values()) {
            ARMOR_TIERS.put(class_18343.toString().toLowerCase(), (class_1741)class_18343);
        }
    }

    @FunctionalInterface
    public static interface UseCallback {
        public boolean use(LevelJS var1, PlayerJS<?> var2, class_1268 var3);
    }

    @FunctionalInterface
    public static interface FinishUsingCallback {
        public ItemStackJS finishUsingItem(ItemStackJS var1, LevelJS var2, LivingEntityJS var3);
    }

    @FunctionalInterface
    public static interface ReleaseUsingCallback {
        public void releaseUsing(ItemStackJS var1, LevelJS var2, LivingEntityJS var3, int var4);
    }

    @FunctionalInterface
    public static interface ItemColorJS {
        public Color getColor(ItemStackJS var1, int var2);
    }

    public static class IndexedItemColor
    implements ItemColorJS {
        Int2IntOpenHashMap colors = new Int2IntOpenHashMap();

        public IndexedItemColor() {
            this.colors.defaultReturnValue(-1);
        }

        @Override
        public Color getColor(@NotNull ItemStackJS stack, int tintIndex) {
            return ColorWrapper.of((Object)this.colors.get(tintIndex));
        }

        public void add(int tintIndex, Color color) {
            this.colors.put(tintIndex, color.getRgbJS());
        }
    }

    @FunctionalInterface
    public static interface NameCallback {
        public class_2561 apply(ItemStackJS var1);
    }
}

