/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.core.AsKJS;
import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.MessageSender;
import dev.latvian.mods.kubejs.util.WrappedJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3143;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class EntityJS
implements MessageSender,
WrappedJS {
    private static Map<String, class_1282> damageSourceMap;
    public transient class_1297 minecraftEntity;

    public EntityJS(class_1297 e) {
        this.minecraftEntity = e;
    }

    public class_1297 getMinecraftEntity() {
        return this.minecraftEntity;
    }

    public final LevelJS getLevel() {
        return this.minecraftEntity.field_6002.asKJS();
    }

    @Nullable
    public ServerJS getServer() {
        return this.getLevel().getServer();
    }

    public UUID getId() {
        return this.minecraftEntity.method_5667();
    }

    public String getType() {
        return Registries.getId((Object)this.minecraftEntity.method_5864(), (class_5321)class_2378.field_25107).toString();
    }

    @Override
    public class_2561 getName() {
        return this.minecraftEntity.method_5477();
    }

    public GameProfile getProfile() {
        return new GameProfile(this.getId(), this.minecraftEntity.method_5653());
    }

    @Override
    public class_2561 getDisplayName() {
        return this.minecraftEntity.method_5476();
    }

    @Override
    public void tell(class_2561 message) {
        this.minecraftEntity.method_9203(message, class_156.field_25140);
    }

    public String toString() {
        return this.minecraftEntity.method_5477().getString() + "-" + this.getId();
    }

    @Nullable
    public PlayerJS<?> getPlayer() {
        return this.isPlayer() ? (PlayerJS)this : null;
    }

    @Nullable
    public ItemStackJS getItem() {
        return null;
    }

    public boolean isFrame() {
        return false;
    }

    public Set<String> getTags() {
        return this.minecraftEntity.method_5752();
    }

    public boolean isAlive() {
        return this.minecraftEntity.method_5805();
    }

    public boolean isLiving() {
        return false;
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isCrouching() {
        return this.minecraftEntity.method_18276();
    }

    public boolean isSprinting() {
        return this.minecraftEntity.method_5624();
    }

    public boolean isSwimming() {
        return this.minecraftEntity.method_5681();
    }

    public boolean isGlowing() {
        return this.minecraftEntity.method_5851();
    }

    public void setGlowing(boolean glowing) {
        this.minecraftEntity.method_5834(glowing);
    }

    public boolean isInvisible() {
        return this.minecraftEntity.method_5767();
    }

    public void setInvisible(boolean invisible) {
        this.minecraftEntity.method_5648(invisible);
    }

    public boolean isInvulnerable() {
        return this.minecraftEntity.method_5655();
    }

    public void setInvulnerable(boolean invulnerable) {
        this.minecraftEntity.method_5684(invulnerable);
    }

    public boolean isBoss() {
        return !this.minecraftEntity.method_5822();
    }

    public boolean isMonster() {
        return !this.minecraftEntity.method_5864().method_5891().method_6136();
    }

    public boolean isAnimal() {
        return this.minecraftEntity.method_5864().method_5891().method_6135();
    }

    public boolean isAmbientCreature() {
        return this.minecraftEntity.method_5864().method_5891() == class_1311.field_6303;
    }

    public boolean isWaterCreature() {
        return this.minecraftEntity.method_5864().method_5891() == class_1311.field_6300;
    }

    public boolean isPeacefulCreature() {
        return this.minecraftEntity.method_5864().method_5891().method_6136();
    }

    public boolean isOnGround() {
        return this.minecraftEntity.method_24828();
    }

    public float getFallDistance() {
        return this.minecraftEntity.field_6017;
    }

    public void setFallDistance(float fallDistance) {
        this.minecraftEntity.field_6017 = fallDistance;
    }

    public float getStepHeight() {
        return this.minecraftEntity.field_6013;
    }

    public void setStepHeight(float stepHeight) {
        this.minecraftEntity.field_6013 = stepHeight;
    }

    public boolean getNoClip() {
        return this.minecraftEntity.field_5960;
    }

    public void setNoClip(boolean noClip) {
        this.minecraftEntity.field_5960 = noClip;
    }

    public boolean isSilent() {
        return this.minecraftEntity.method_5701();
    }

    public void setSilent(boolean isSilent) {
        this.minecraftEntity.method_5803(isSilent);
    }

    public boolean getNoGravity() {
        return this.minecraftEntity.method_5740();
    }

    public void setNoGravity(boolean noGravity) {
        this.minecraftEntity.method_5875(noGravity);
    }

    public double getX() {
        return this.minecraftEntity.method_23317();
    }

    public void setX(double x) {
        this.minecraftEntity.method_5814(x, this.getY(), this.getZ());
    }

    public double getY() {
        return this.minecraftEntity.method_23318();
    }

    public void setY(double y) {
        this.minecraftEntity.method_5814(this.getX(), y, this.getZ());
    }

    public double getZ() {
        return this.minecraftEntity.method_23321();
    }

    public void setZ(double z) {
        this.minecraftEntity.method_5814(this.getX(), this.getY(), z);
    }

    public float getYaw() {
        return this.minecraftEntity.method_36454();
    }

    public void setYaw(float yaw) {
        this.minecraftEntity.method_36456(yaw);
    }

    public float getPitch() {
        return this.minecraftEntity.method_36455();
    }

    public void setPitch(float pitch) {
        this.minecraftEntity.method_36457(pitch);
    }

    public double getMotionX() {
        return this.minecraftEntity.method_18798().field_1352;
    }

    public void setMotionX(double x) {
        class_243 m = this.minecraftEntity.method_18798();
        this.minecraftEntity.method_18800(x, m.field_1351, m.field_1350);
    }

    public double getMotionY() {
        return this.minecraftEntity.method_18798().field_1351;
    }

    public void setMotionY(double y) {
        class_243 m = this.minecraftEntity.method_18798();
        this.minecraftEntity.method_18800(m.field_1352, y, m.field_1350);
    }

    public double getMotionZ() {
        return this.minecraftEntity.method_18798().field_1350;
    }

    public void setMotionZ(double z) {
        class_243 m = this.minecraftEntity.method_18798();
        this.minecraftEntity.method_18800(m.field_1352, m.field_1351, z);
    }

    public void setMotion(double x, double y, double z) {
        this.minecraftEntity.method_18800(x, y, z);
    }

    public int getTicksExisted() {
        return this.minecraftEntity.field_6012;
    }

    public void setPosition(BlockContainerJS block) {
        this.teleportTo(block.getDimension(), block.getX(), block.getY(), block.getZ(), this.getYaw(), this.getPitch());
    }

    public void setPosition(double x, double y, double z) {
        this.setPositionAndRotation(x, y, z, this.getYaw(), this.getPitch());
    }

    public void setRotation(float yaw, float pitch) {
        this.setPositionAndRotation(this.getX(), this.getY(), this.getZ(), yaw, pitch);
    }

    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        this.minecraftEntity.method_5808(x, y, z, yaw, pitch);
    }

    public void teleportTo(class_2960 dimension, double x, double y, double z, float yaw, float pitch) {
        ServerLevelJS level = this.getServer().getLevel(dimension);
        if (level == null) {
            throw new IllegalArgumentException("Invalid dimension!");
        }
        if (!class_1937.method_25953((class_2338)new class_2338(x, y, z))) {
            throw new IllegalArgumentException("Invalid coordinates!");
        }
        if (Float.isNaN(yaw) || Float.isNaN(pitch)) {
            throw new IllegalArgumentException("Invalid rotation!");
        }
        try {
            LevelJS previousLevel = this.getLevel();
            class_3143.method_13766((class_2168)this.minecraftEntity.method_5671(), (class_1297)this.minecraftEntity, (class_3218)level.getMinecraftLevel(), (double)x, (double)y, (double)z, Set.of(), (float)yaw, (float)pitch, null);
            if (previousLevel != level) {
                this.minecraftEntity = level.getMinecraftLevel().method_14190(this.getId());
            }
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e.getRawMessage().getString());
        }
    }

    public void addMotion(double x, double y, double z) {
        this.minecraftEntity.method_18799(this.minecraftEntity.method_18798().method_1031(x, y, z));
    }

    @Override
    public int runCommand(String command) {
        LevelJS levelJS = this.getLevel();
        if (levelJS instanceof ServerLevelJS) {
            ServerLevelJS level = (ServerLevelJS)levelJS;
            return level.getServer().getMinecraftServer().method_3734().method_9249(this.minecraftEntity.method_5671(), command);
        }
        return 0;
    }

    @Override
    public int runCommandSilent(String command) {
        LevelJS levelJS = this.getLevel();
        if (levelJS instanceof ServerLevelJS) {
            ServerLevelJS level = (ServerLevelJS)levelJS;
            return level.getServer().getMinecraftServer().method_3734().method_9249(this.minecraftEntity.method_5671().method_9217(), command);
        }
        return 0;
    }

    public void kill() {
        this.minecraftEntity.method_5768();
    }

    public void remove() {
        this.minecraftEntity.method_5650(class_1297.class_5529.field_26999);
    }

    public boolean startRiding(EntityJS e, boolean force) {
        return this.minecraftEntity.method_5873(e.minecraftEntity, force);
    }

    public void removePassengers() {
        this.minecraftEntity.method_5772();
    }

    public void dismountRidingEntity() {
        this.minecraftEntity.method_5848();
    }

    public EntityArrayList getPassengers() {
        return new EntityArrayList(this.getLevel(), this.minecraftEntity.method_5685());
    }

    public boolean isPassenger(EntityJS e) {
        return this.minecraftEntity.method_5626(e.minecraftEntity);
    }

    public EntityArrayList getRecursivePassengers() {
        return new EntityArrayList(this.getLevel(), this.minecraftEntity.method_5736());
    }

    @Nullable
    public EntityJS getRidingEntity() {
        return (EntityJS)AsKJS.wrapSafe(this.minecraftEntity.method_5854());
    }

    public String getTeamId() {
        class_270 team = this.minecraftEntity.method_5781();
        return team == null ? "" : team.method_1197();
    }

    public boolean isOnSameTeam(EntityJS e) {
        return this.minecraftEntity.method_5722(e.minecraftEntity);
    }

    public boolean isOnScoreboardTeam(String teamID) {
        class_268 team = this.minecraftEntity.method_5770().method_8428().method_1153(teamID);
        return team != null && this.minecraftEntity.method_5645((class_270)team);
    }

    public void setCustomName(class_2561 name) {
        this.minecraftEntity.method_5665(name);
    }

    public class_2561 getCustomName() {
        return this.minecraftEntity.method_5797();
    }

    public boolean getHasCustomName() {
        return this.minecraftEntity.method_16914();
    }

    public void setCustomNameAlwaysVisible(boolean b) {
        this.minecraftEntity.method_5880(b);
    }

    public boolean getCustomNameAlwaysVisible() {
        return this.minecraftEntity.method_5807();
    }

    public class_2350 getHorizontalFacing() {
        return this.minecraftEntity.method_5735();
    }

    public class_2350 getFacing() {
        if (this.getPitch() > 45.0f) {
            return class_2350.field_11033;
        }
        if (this.getPitch() < -45.0f) {
            return class_2350.field_11036;
        }
        return this.getHorizontalFacing();
    }

    public float getEyeHeight() {
        return this.minecraftEntity.method_5751();
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.minecraftEntity.field_6002, this.minecraftEntity.method_24515());
    }

    public void setOnFire(int seconds) {
        this.minecraftEntity.method_5639(seconds);
    }

    public void extinguish() {
        this.minecraftEntity.method_5646();
    }

    public class_2487 getFullNBT() {
        class_2487 nbt = new class_2487();
        this.minecraftEntity.method_5647(nbt);
        return nbt;
    }

    public void setFullNBT(@Nullable class_2487 nbt) {
        if (nbt != null) {
            this.minecraftEntity.method_5651(nbt);
        }
    }

    public EntityJS mergeFullNBT(@Nullable class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return this;
        }
        class_2487 nbt = this.getFullNBT();
        for (String k : tag.method_10541()) {
            class_2520 t = tag.method_10580(k);
            if (t == null || t == class_2491.field_21033) {
                nbt.method_10551(k);
                continue;
            }
            nbt.method_10566(k, tag.method_10580(k));
        }
        this.setFullNBT(nbt);
        return this;
    }

    @Deprecated
    public class_2487 getNbt() {
        return this.getPersistentData();
    }

    public class_2487 getPersistentData() {
        return this.minecraftEntity.getPersistentDataKJS();
    }

    public void playSound(class_3414 id, float volume, float pitch) {
        this.minecraftEntity.field_6002.method_8465(null, this.getX(), this.getY(), this.getZ(), id, this.minecraftEntity.method_5634(), volume, pitch);
    }

    public void playSound(class_3414 id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public void spawn() {
        this.getLevel().minecraftLevel.method_8649(this.minecraftEntity);
    }

    public void attack(String source, float hp) {
        if (damageSourceMap == null) {
            damageSourceMap = new HashMap<String, class_1282>();
            try {
                for (Field field : class_1282.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != class_1282.class) continue;
                    class_1282 s = (class_1282)field.get(null);
                    damageSourceMap.put(s.method_5525(), s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class_1282 s = damageSourceMap.getOrDefault(source, class_1282.field_5869);
        this.minecraftEntity.method_5643(s, hp);
    }

    public void attack(float hp) {
        this.minecraftEntity.method_5643(class_1282.field_5869, hp);
    }

    public RayTraceResultJS rayTrace(double distance) {
        double xRot = this.minecraftEntity.method_36455();
        double yRot = this.minecraftEntity.method_36454();
        class_243 fromPos = this.minecraftEntity.method_5836(1.0f);
        double x0 = Math.sin(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double z0 = Math.cos(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double y0 = -Math.cos(-xRot * (Math.PI / 180));
        double y = Math.sin(-xRot * (Math.PI / 180));
        double x = x0 * y0;
        double z = z0 * y0;
        class_243 toPos = fromPos.method_1031(x * distance, y * distance, z * distance);
        class_3965 hitResult = this.minecraftEntity.field_6002.method_17742(new class_3959(fromPos, toPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, this.minecraftEntity));
        return new RayTraceResultJS(this, (class_239)hitResult, distance);
    }

    public boolean isInWater() {
        return this.minecraftEntity.method_5799();
    }

    public boolean isUnderWater() {
        return this.minecraftEntity.method_5869();
    }

    public double getDistanceSq(double x, double y, double z) {
        return this.minecraftEntity.method_5649(x, y, z);
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt(this.getDistanceSq(x, y, z));
    }

    public double getDistanceSq(class_2338 pos) {
        return this.getDistanceSq((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public double getDistance(class_2338 pos) {
        return Math.sqrt(this.getDistanceSq(pos));
    }
}

