/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.core.MinecraftServerKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.stages.Stages;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3097;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_5219;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;

public class KubeJSCommands {
    public static final DynamicCommandExceptionType NO_REGISTRY = new DynamicCommandExceptionType(id -> new class_2585("No builtin or static registry found for " + id));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kubejs").then(class_2170.method_9247((String)"custom_command").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.customCommand((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"hand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5808)))).then(class_2170.method_9247((String)"offhand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5810)))).then(class_2170.method_9247((String)"inventory").executes(context -> KubeJSCommands.inventory(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"errors").executes(context -> KubeJSCommands.errors((class_2168)context.getSource())))).then(class_2170.method_9247((String)"warnings").executes(context -> KubeJSCommands.warnings((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"startup_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadStartup((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadServer((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.export((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export_virtual_data").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.exportVirtualData((class_2168)context.getSource())))).then(class_2170.method_9247((String)"list_tag").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"registry", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(((class_2168)ctx.getSource()).method_30497().method_40311().map(entry -> entry.comp_350().method_29177().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.listTagsFor((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")))).then(class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(KubeJSCommands.allTags((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")).map(class_6862::comp_327).map(class_2960::toString), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.tagObjects((class_2168)ctx.getSource(), class_6862.method_40092(KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry"), (class_2960)class_2232.method_9443((CommandContext)ctx, (String)"tag")))))))).then(class_2170.method_9247((String)"dump_registry").then(class_2170.method_9244((String)"registry", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(((class_2168)ctx.getSource()).method_30497().method_40311().map(entry -> entry.comp_350().method_29177().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.dumpRegistry((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")))))).then(class_2170.method_9247((String)"wiki").executes(context -> KubeJSCommands.wiki((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stages").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.clearStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.listStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))))).then(class_2170.method_9247((String)"painter").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"object", (ArgumentType)class_2179.method_9284()).executes(context -> KubeJSCommands.painter((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), class_2179.method_9285((CommandContext)context, (String)"object")))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"kjs_hand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5808)));
    }

    private static <T> class_5321<class_2378<T>> registry(CommandContext<class_2168> ctx, String arg) {
        return class_5321.method_29180((class_2960)class_2232.method_9443(ctx, (String)arg));
    }

    private static <T> Stream<class_6862<T>> allTags(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        return ((class_2378)source.method_30497().method_33310(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.method_29177()))).method_40273();
    }

    private static class_2561 copy(String s, class_124 col, String info) {
        class_2585 component = new class_2585("- ");
        component.method_10862(component.method_10866().method_27703(class_5251.method_27718((class_124)class_124.field_1080)));
        component.method_10862(component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, s)));
        component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(info + " (Click to copy)"))));
        component.method_10852((class_2561)new class_2585(s).method_27692(col));
        return component;
    }

    private static int customCommand(class_2168 source, String id) {
        new CustomCommandEventJS((class_1937)source.method_9225(), source.method_9228(), new class_2338(source.method_9222()), id).post(ScriptType.SERVER, "server.custom_command", id);
        return 1;
    }

    private static int hand(class_3222 player, class_1268 hand) {
        player.method_9203((class_2561)new class_2585("Item in hand:"), class_156.field_25140);
        ItemStackJS stack = ItemStackJS.of(player.method_5998(hand));
        player.method_9203(KubeJSCommands.copy(stack.toString(), class_124.field_1060, "Item ID"), class_156.field_25140);
        ArrayList<class_2960> tags = new ArrayList<class_2960>(stack.getTags());
        tags.sort(null);
        for (class_2960 id : tags) {
            player.method_9203(KubeJSCommands.copy("'#" + id + "'", class_124.field_1054, "Item Tag [" + TagIngredientJS.createTag(id.toString()).getStacks().size() + " items]"), class_156.field_25140);
        }
        player.method_9203(KubeJSCommands.copy("'@" + stack.getMod() + "'", class_124.field_1075, "Mod [" + new ModIngredientJS(stack.getMod()).getStacks().size() + " items]"), class_156.field_25140);
        if (stack.getItem().method_7859() != null) {
            player.method_9203(KubeJSCommands.copy("'%" + stack.getItemGroup() + "'", class_124.field_1076, "Item Group [" + new GroupIngredientJS(stack.getItem().method_7859()).getStacks().size() + " items]"), class_156.field_25140);
        }
        return 1;
    }

    private static int inventory(class_3222 player) {
        return KubeJSCommands.dump((List<class_1799>)player.method_31548().field_7547, player, "Inventory");
    }

    private static int hotbar(class_3222 player) {
        return KubeJSCommands.dump(player.method_31548().field_7547.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<class_1799> stacks, class_3222 player, String name) {
        ArrayList<ItemStackJS> stackList = new ArrayList<ItemStackJS>(stacks.size());
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            stackList.add(ItemStackJS.of(stack));
        }
        String dump = ((Object)stackList).toString();
        player.method_9203(KubeJSCommands.copy(dump, class_124.field_1068, name + " Item List"), class_156.field_25140);
        return 1;
    }

    private static int errors(class_2168 source) {
        if (ScriptType.SERVER.errors.isEmpty()) {
            source.method_9226((class_2561)new class_2585("No errors found!").method_27692(class_124.field_1060), false);
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.method_9226((class_2561)new class_2585(ScriptType.SERVER.warnings.size() + " warnings found. Run /kubejs warnings to see them").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
            }
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.errors.size(); ++i) {
            source.method_9226((class_2561)new class_2585("[" + (i + 1) + "] " + ScriptType.SERVER.errors.get(i)).method_27692(class_124.field_1061), false);
        }
        source.method_9226((class_2561)new class_2585("More info in ").method_10852((class_2561)new class_2585("'logs/kubejs/server.txt'").click(new class_2558(class_2558.class_2559.field_11746, ScriptType.SERVER.getLogFile().toString())).hover((class_2561)new class_2585("Click to open"))).method_27692(class_124.field_1079), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.method_9226((class_2561)new class_2585(ScriptType.SERVER.warnings.size() + " warnings found. Run ").method_10852((class_2561)new class_2585("'/kubejs warnings'").click(new class_2558(class_2558.class_2559.field_11750, "/kubejs warnings")).hover((class_2561)new class_2585("Click to run"))).method_27693(" to see them").method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
        }
        return 1;
    }

    private static int warnings(class_2168 source) {
        if (ScriptType.SERVER.warnings.isEmpty()) {
            source.method_9226((class_2561)new class_2585("No warnings found!").method_27692(class_124.field_1060), false);
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.warnings.size(); ++i) {
            source.method_9226((class_2561)new class_2585("[" + (i + 1) + "] " + ScriptType.SERVER.warnings.get(i)).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))), false);
        }
        return 1;
    }

    private static int reloadStartup(class_2168 source) {
        KubeJS.startupScriptManager.unload();
        KubeJS.startupScriptManager.loadFromDirectory();
        KubeJS.startupScriptManager.load();
        source.method_9226((class_2561)new class_2585("Done!"), false);
        return 1;
    }

    private static int reloadServer(class_2168 source) {
        ServerScriptManager.instance.reloadScriptManager((class_3300)((MinecraftServerKJS)source.method_9211()).getReloadableResourcesKJS().comp_352());
        source.method_9226((class_2561)new class_2585("Done! To reload recipes, tags, loot tables and other datapack things, run ").method_10852((class_2561)new class_2585("'/reload'").click(new class_2558(class_2558.class_2559.field_11750, "/reload")).hover((class_2561)new class_2585("Click to run"))), false);
        return 1;
    }

    private static int reloadClient(class_2168 source) {
        KubeJS.PROXY.reloadClientInternal();
        source.method_9226((class_2561)new class_2585("Done! To reload textures, models and other assets, press F3 + T"), false);
        return 1;
    }

    private static int reloadTextures(class_2168 source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(class_2168 source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(class_2168 source) {
        if (ServerSettings.dataExport != null) {
            return 0;
        }
        ServerSettings.source = source;
        ServerSettings.dataExport = new JsonObject();
        source.method_9226((class_2561)new class_2585("Reloading server and exporting data..."), false);
        MinecraftServer minecraftServer = source.method_9211();
        class_3283 packRepository = minecraftServer.method_3836();
        class_5219 worldData = minecraftServer.method_27728();
        Collection collection = packRepository.method_29210();
        packRepository.method_14445();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.method_29589().method_29550();
        for (String string : packRepository.method_29206()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        class_3097.method_29480((Collection)collection2, (class_2168)source);
        return 1;
    }

    private static int exportVirtualData(class_2168 source) {
        return source.method_9211().method_34864().method_29213().filter(pack -> pack instanceof VirtualKubeJSDataPack).map(pack -> (VirtualKubeJSDataPack)((Object)pack)).mapToInt(pack -> {
            Path path = KubeJSPaths.EXPORTED.resolve(pack.method_14409() + ".zip");
            try {
                Files.deleteIfExists(path);
                try (FileSystem fs = FileSystems.newFileSystem(path, Map.of("create", true));){
                    pack.export(fs);
                }
                source.method_9226((class_2561)new class_2585("Successfully exported %s to %s".formatted(pack, path)).method_27692(class_124.field_1060), false);
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                source.method_9213((class_2561)new class_2585("Failed to export %s!".formatted(pack)).method_27694(style -> style.method_10977(class_124.field_1061).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(e.getMessage())))));
                return 0;
            }
        }).sum();
    }

    private static int outputRecipes(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static int inputRecipes(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static int checkRecipeConflicts(class_3222 player) {
        player.method_9203((class_2561)new class_2585("WIP!"), class_156.field_25140);
        return 1;
    }

    private static <T> int listTagsFor(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        Stream<class_6862<class_6862>> tags = KubeJSCommands.allTags(source, registry);
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("List of all Tags for " + registry.method_29177() + ":"), false);
        source.method_9226(class_2585.field_24366, false);
        long size = tags.map(class_6862::comp_327).map(tag -> new class_2585("- %s".formatted(tag)).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/kubejs list_tag %s %s".formatted(registry.method_29177(), tag))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("[Show all entries for %s]".formatted(tag)))))).mapToLong(msg -> {
            source.method_9226((class_2561)msg, false);
            return 1L;
        }).sum();
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("Total: %d tags".formatted(size)), false);
        source.method_9226((class_2561)new class_2585("(Click on any of the above tags to list their contents!)"), false);
        source.method_9226(class_2585.field_24366, false);
        return 1;
    }

    private static <T> int tagObjects(class_2168 source, class_6862<T> key) throws CommandSyntaxException {
        class_2378 registry = (class_2378)source.method_30497().method_33310(key.comp_326()).orElseThrow(() -> NO_REGISTRY.create((Object)key.comp_326().method_29177()));
        Optional tag = registry.method_40266(key);
        if (tag.isEmpty()) {
            source.method_9213((class_2561)new class_2585("Tag not found or empty!"));
            return 0;
        }
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("Contents of #" + key.comp_327() + " [" + key.comp_326().method_29177() + "]:"), false);
        source.method_9226(class_2585.field_24366, false);
        class_6885.class_6888 items = (class_6885.class_6888)tag.get();
        for (class_6880 holder : items) {
            String id = (String)holder.method_40229().map(o -> o.method_29177().toString(), o -> o + " (unknown ID)");
            source.method_9226((class_2561)new class_2585("- " + id), false);
        }
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("Total: " + items.method_40247() + " elements"), false);
        source.method_9226(class_2585.field_24366, false);
        return 1;
    }

    private static <T> int dumpRegistry(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        Stream ids = ((class_2378)source.method_30497().method_33310(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.method_29177()))).method_40270();
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("List of all entries for registry " + registry.method_29177() + ":"), false);
        source.method_9226(class_2585.field_24366, false);
        long size = ids.map(holder -> {
            class_2960 id = holder.method_40237().method_29177();
            return new class_2585("- %s".formatted(id)).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("%s [%s]".formatted(holder.comp_349(), holder.comp_349().getClass().getName())))));
        }).mapToLong(msg -> {
            source.method_9226((class_2561)msg, false);
            return 1L;
        }).sum();
        source.method_9226(class_2585.field_24366, false);
        source.method_9226((class_2561)new class_2585("Total: %d entries".formatted(size)), false);
        source.method_9226(class_2585.field_24366, false);
        return 1;
    }

    private static int wiki(class_2168 source) {
        source.method_9226((class_2561)new class_2585("Click here to open the Wiki").method_27692(class_124.field_1078).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://kubejs.com/"))), false);
        return 1;
    }

    private static int addStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).add(stage)) continue;
            source.method_9226((class_2561)new class_2585("Added '" + stage + "' stage for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int removeStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).remove(stage)) continue;
            source.method_9226((class_2561)new class_2585("Removed '" + stage + "' stage for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int clearStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            if (!Stages.get((class_1657)p).clear()) continue;
            source.method_9226((class_2561)new class_2585("Cleared stages for " + p.method_5820()), false);
        }
        return 1;
    }

    private static int listStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            source.method_9226((class_2561)new class_2585(p.method_5820() + " stages:"), false);
            Stages.get((class_1657)p).getAll().stream().sorted().forEach(s -> source.method_9226((class_2561)new class_2585("- " + s), false));
        }
        return 1;
    }

    private static int painter(class_2168 source, Collection<class_3222> players, class_2487 object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }
}

