/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import dev.latvian.mods.kubejs.client.painter.PainterObject;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.PainterObjectStorage;
import dev.latvian.mods.kubejs.client.painter.screen.MultiMaxFunc;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ScreenGroup
extends ScreenPainterObject {
    private final PainterObjectStorage storage = new PainterObjectStorage();
    private Unit scaleX = FixedNumberUnit.ONE;
    private Unit scaleY = FixedNumberUnit.ONE;
    private Unit paddingW = FixedNumberUnit.ZERO;
    private Unit paddingH = FixedNumberUnit.ZERO;

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        class_2520 c = properties.tag.method_10580("children");
        if (c instanceof class_2487) {
            class_2487 tag = (class_2487)c;
            this.storage.handle(tag);
        }
        this.paddingW = properties.getUnit("paddingW", this.paddingW);
        this.paddingH = properties.getUnit("paddingH", this.paddingH);
        if (properties.hasAny("scale")) {
            this.scaleX = this.scaleY = properties.getUnit("scale", (Unit)FixedNumberUnit.ONE);
        } else {
            this.scaleX = properties.getUnit("scaleX", this.scaleX);
            this.scaleY = properties.getUnit("scaleY", this.scaleY);
        }
    }

    @Override
    public void preDraw(ScreenPaintEventJS event) {
        this.w = FixedNumberUnit.ZERO;
        this.h = FixedNumberUnit.ZERO;
        Collection<PainterObject> objects = this.storage.getObjects();
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<Unit> wunits = new ArrayList<Unit>(objects.size());
        ArrayList<Unit> hunits = new ArrayList<Unit>(objects.size());
        for (PainterObject object : objects) {
            if (!(object instanceof ScreenPainterObject)) continue;
            ScreenPainterObject s = (ScreenPainterObject)object;
            s.preDraw(event);
            wunits.add(s.x.add(s.w));
            hunits.add(s.y.add(s.h));
        }
        this.w = new MultiMaxFunc(wunits).add(this.paddingW);
        this.h = new MultiMaxFunc(hunits).add(this.paddingH);
    }

    @Override
    public void draw(ScreenPaintEventJS event) {
        float ax = event.alignX(this.x.getFloat((UnitVariables)event), this.w.getFloat((UnitVariables)event), this.alignX);
        float ay = event.alignY(this.y.getFloat((UnitVariables)event), this.h.getFloat((UnitVariables)event), this.alignY);
        float az = this.z.getFloat((UnitVariables)event);
        event.push();
        event.translate(ax, ay, az);
        event.scale(this.scaleX.getFloat((UnitVariables)event), this.scaleY.getFloat((UnitVariables)event), 1.0f);
        for (PainterObject object : this.storage.getObjects()) {
            if (!(object instanceof ScreenPainterObject)) continue;
            ScreenPainterObject s = (ScreenPainterObject)object;
            s.draw(event);
        }
        event.pop();
    }
}

