/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.block.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.block.BlockStateModifyPlacementCallbackJS;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract class BlockBuilder
extends BuilderBase<class_2248> {
    public transient MaterialJS material;
    public transient float hardness;
    public transient float resistance;
    public transient float lightLevel;
    public transient boolean opaque;
    public transient boolean fullBlock;
    public transient boolean requiresTool;
    public transient String renderType;
    public transient Int2IntOpenHashMap color;
    public final transient JsonObject textures;
    public transient String model;
    public transient BlockItemBuilder itemBuilder;
    public transient List<class_238> customShape;
    public transient boolean noCollision;
    public transient boolean notSolid;
    public transient float slipperiness = 0.6f;
    public transient float speedFactor = 1.0f;
    public transient float jumpFactor = 1.0f;
    public Consumer<RandomTickCallbackJS> randomTickCallback;
    public Consumer<LootBuilder> lootTable;
    public JsonObject blockstateJson;
    public JsonObject modelJson;
    public transient boolean noValidSpawns;
    public transient boolean suffocating;
    public transient boolean viewBlocking;
    public transient boolean redstoneConductor;
    public transient boolean transparent;
    public transient Set<class_2769<?>> blockStateProperties;
    public transient Consumer<BlockStateModifyCallbackJS> defaultStateModification;
    public transient Consumer<BlockStateModifyPlacementCallbackJS> placementStateModification;

    public BlockBuilder(class_2960 i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("wood");
        this.hardness = 1.5f;
        this.resistance = 3.0f;
        this.lightLevel = 0.0f;
        this.opaque = true;
        this.fullBlock = false;
        this.requiresTool = false;
        this.renderType = "solid";
        this.color = new Int2IntOpenHashMap();
        this.color.defaultReturnValue(-1);
        this.textures = new JsonObject();
        this.textureAll(this.id.method_12836() + ":block/" + this.id.method_12832());
        this.model = "";
        this.itemBuilder = this.getOrCreateItemBuilder();
        this.itemBuilder.blockBuilder = this;
        this.customShape = new ArrayList<class_238>();
        this.noCollision = false;
        this.notSolid = false;
        this.randomTickCallback = null;
        this.lootTable = loot -> loot.addPool(pool -> {
            pool.survivesExplosion();
            pool.addItem(new class_1799((class_1935)this.get()));
        });
        this.blockstateJson = null;
        this.modelJson = null;
        this.noValidSpawns = false;
        this.suffocating = true;
        this.viewBlocking = true;
        this.redstoneConductor = true;
        this.transparent = false;
        this.blockStateProperties = new HashSet();
        this.defaultStateModification = null;
        this.placementStateModification = null;
    }

    @Override
    public final RegistryObjectBuilderTypes<class_2248> getRegistryType() {
        return RegistryObjectBuilderTypes.BLOCK;
    }

    @Override
    public class_2248 transformObject(class_2248 obj) {
        obj.setBlockBuilderKJS(this);
        return obj;
    }

    @Override
    public void createAdditionalObjects() {
        if (this.itemBuilder != null) {
            RegistryObjectBuilderTypes.ITEM.addBuilder(this.itemBuilder);
        }
    }

    @Override
    public BuilderBase<class_2248> displayName(String name) {
        if (this.itemBuilder != null) {
            this.itemBuilder.displayName(name);
        }
        return super.displayName(name);
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        if (this.lootTable != null) {
            LootBuilder lootBuilder = new LootBuilder(null);
            lootBuilder.type = "minecraft:block";
            this.lootTable.accept(lootBuilder);
            generator.json(this.newID("loot_tables/blocks/", ""), (JsonElement)lootBuilder.toJson());
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.blockstateJson != null) {
            generator.json(this.newID("blockstates/", ""), (JsonElement)this.blockstateJson);
        } else {
            generator.blockState(this.id, bs -> bs.variant("", (String)(this.model.isEmpty() ? this.id.method_12836() + ":block/" + this.id.method_12832() : this.model)));
        }
        if (this.modelJson != null) {
            generator.json(this.newID("models/block/", ""), (JsonElement)this.modelJson);
        } else {
            generator.blockModel(this.id, m -> {
                String particle = this.textures.get("particle").getAsString();
                if (this.areAllTexturesEqual(this.textures, particle)) {
                    m.parent("minecraft:block/cube_all");
                    m.texture("all", particle);
                } else {
                    m.parent("block/cube");
                    m.textures(this.textures);
                }
                if (!this.color.isEmpty() || !this.customShape.isEmpty()) {
                    ArrayList<class_238> boxes = new ArrayList<class_238>(this.customShape);
                    if (boxes.isEmpty()) {
                        boxes.add(new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
                    }
                    for (class_238 box : boxes) {
                        m.element(e -> {
                            e.box(box);
                            for (class_2350 direction : class_2350.values()) {
                                e.face(direction, face -> {
                                    face.tex("#" + direction.method_15434());
                                    face.cull();
                                    if (!this.color.isEmpty()) {
                                        face.tintindex(0);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        if (this.itemBuilder != null) {
            generator.itemModel(this.itemBuilder.id, m -> {
                if (!this.model.isEmpty()) {
                    m.parent(this.model);
                } else {
                    m.parent(this.newID("block/", "").toString());
                }
            });
        }
    }

    public Map<class_2960, JsonObject> generateBlockModels(BlockBuilder builder) {
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        if (builder.modelJson != null) {
            map.put(builder.newID("models/block/", ""), builder.modelJson);
        } else {
            JsonObject modelJson = new JsonObject();
            String particle = builder.textures.get("particle").getAsString();
            if (this.areAllTexturesEqual(builder.textures, particle)) {
                modelJson.addProperty("parent", "block/cube_all");
                JsonObject textures = new JsonObject();
                textures.addProperty("all", particle);
                modelJson.add("textures", (JsonElement)textures);
            } else {
                modelJson.addProperty("parent", "block/cube");
                modelJson.add("textures", (JsonElement)builder.textures);
            }
            if (!builder.color.isEmpty()) {
                JsonObject cube = new JsonObject();
                JsonArray from = new JsonArray();
                from.add((Number)0);
                from.add((Number)0);
                from.add((Number)0);
                cube.add("from", (JsonElement)from);
                JsonArray to = new JsonArray();
                to.add((Number)16);
                to.add((Number)16);
                to.add((Number)16);
                cube.add("to", (JsonElement)to);
                JsonObject faces = new JsonObject();
                for (class_2350 direction : class_2350.values()) {
                    JsonObject f = new JsonObject();
                    f.addProperty("texture", "#" + direction.method_15434());
                    f.addProperty("cullface", direction.method_15434());
                    f.addProperty("tintindex", (Number)0);
                    faces.add(direction.method_15434(), (JsonElement)f);
                }
                cube.add("faces", (JsonElement)faces);
                JsonArray elements = new JsonArray();
                elements.add((JsonElement)cube);
                modelJson.add("elements", (JsonElement)elements);
            }
            map.put(builder.newID("models/block/", ""), modelJson);
        }
        return map;
    }

    private boolean areAllTexturesEqual(JsonObject tex, String t) {
        for (class_2350 direction : class_2350.values()) {
            if (tex.get(direction.method_15434()).getAsString().equals(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegistry(Supplier<class_310> minecraft) {
        switch (this.renderType) {
            case "cutout": {
                RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)this.get()});
                break;
            }
            case "cutout_mipped": {
                RenderTypeRegistry.register((class_1921)class_1921.method_23579(), (class_2248[])new class_2248[]{(class_2248)this.get()});
                break;
            }
            case "translucent": {
                RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)this.get()});
            }
        }
        if (!this.color.isEmpty()) {
            ColorHandlerRegistry.registerBlockColors((state, level, pos, index) -> this.color.get(index), (Supplier[])new Supplier[]{this});
        }
    }

    @Override
    public void addResourcePackLocations(String path, List<class_2960> list, class_3264 packType) {
        if (this.lootTable != null && path.equals("loot_tables")) {
            list.add(new class_2960(this.id.method_12836(), "loot_tables/blocks/" + this.id.method_12832() + ".json"));
        }
    }

    public BlockBuilder material(MaterialJS m) {
        this.material = m;
        return this;
    }

    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    public BlockBuilder requiresTool(boolean f) {
        this.requiresTool = f;
        return this;
    }

    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    public BlockBuilder color(int index, Color c) {
        this.color.put(index, c.getArgbJS());
        return this;
    }

    public BlockBuilder textureAll(String tex) {
        for (class_2350 direction : class_2350.values()) {
            this.textureSide(direction, tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    public BlockBuilder textureSide(class_2350 direction, String tex) {
        return this.texture(direction.method_15434(), tex);
    }

    public BlockBuilder texture(String id, String tex) {
        this.textures.addProperty(id, tex);
        return this;
    }

    public BlockBuilder model(String m) {
        this.model = m;
        if (this.itemBuilder != null) {
            this.itemBuilder.parentModel(m);
        }
        return this;
    }

    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
            this.lootTable = null;
        } else {
            i.accept(this.getOrCreateItemBuilder());
        }
        return this;
    }

    @HideFromJS
    protected BlockItemBuilder getOrCreateItemBuilder() {
        return this.itemBuilder == null ? (this.itemBuilder = new BlockItemBuilder(this.id)) : this.itemBuilder;
    }

    public BlockBuilder noItem() {
        return this.item(null);
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1, boolean scale16) {
        if (scale16) {
            this.customShape.add(new class_238(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0));
        } else {
            this.customShape.add(new class_238(x0, y0, z0, x1, y1, z1));
        }
        return this;
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public class_265 createShape() {
        if (this.customShape.isEmpty()) {
            return class_259.method_1077();
        }
        class_265 shape = class_259.method_1078((class_238)this.customShape.get(0));
        for (int i = 1; i < this.customShape.size(); ++i) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1078((class_238)this.customShape.get(i)));
        }
        return shape;
    }

    public BlockBuilder noCollision() {
        this.noCollision = true;
        return this;
    }

    @Deprecated
    public BlockBuilder noCollission() {
        return this.noCollision();
    }

    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public BlockBuilder setWaterlogged(boolean waterlogged) {
        KubeJS.startupScriptManager.type.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        if (waterlogged) {
            this.property((class_2769<?>)class_2741.field_12508);
        }
        return this;
    }

    @Deprecated(forRemoval=true)
    public boolean getWaterlogged() {
        KubeJS.startupScriptManager.type.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        return this.canBeWaterlogged();
    }

    public BlockBuilder waterlogged() {
        return this.property((class_2769<?>)class_2741.field_12508);
    }

    public boolean canBeWaterlogged() {
        return this.blockStateProperties.contains(class_2741.field_12508);
    }

    public BlockBuilder noDrops() {
        this.lootTable = null;
        return this;
    }

    public BlockBuilder slipperiness(float f) {
        this.slipperiness = f;
        return this;
    }

    public BlockBuilder speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    public BlockBuilder jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        this.randomTickCallback = randomTickCallback;
        return this;
    }

    public BlockBuilder noValidSpawns(boolean b) {
        this.noValidSpawns = b;
        return this;
    }

    public BlockBuilder suffocating(boolean b) {
        this.suffocating = b;
        return this;
    }

    public BlockBuilder viewBlocking(boolean b) {
        this.viewBlocking = b;
        return this;
    }

    public BlockBuilder redstoneConductor(boolean b) {
        this.redstoneConductor = b;
        return this;
    }

    public BlockBuilder transparent(boolean b) {
        this.transparent = b;
        return this;
    }

    public BlockBuilder defaultCutout() {
        return this.renderType("cutout").notSolid().noValidSpawns(true).suffocating(false).viewBlocking(false).redstoneConductor(false).transparent(true);
    }

    public BlockBuilder defaultTranslucent() {
        return this.defaultCutout().renderType("translucent");
    }

    public BlockBuilder tag(class_2960 tag) {
        return this.tagBoth(tag);
    }

    public BlockBuilder tagBoth(class_2960 tag) {
        this.tagBlock(tag);
        this.tagItem(tag);
        return this;
    }

    public BlockBuilder tagBlock(class_2960 tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder tagItem(class_2960 tag) {
        this.itemBuilder.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder defaultState(Consumer<BlockStateModifyCallbackJS> callbackJS) {
        this.defaultStateModification = callbackJS;
        return this;
    }

    public BlockBuilder placementState(Consumer<BlockStateModifyPlacementCallbackJS> callbackJS) {
        this.placementStateModification = callbackJS;
        return this;
    }

    public BlockBuilder property(class_2769<?> property) {
        if (property.method_11898().size() <= 1) {
            throw new IllegalArgumentException(String.format("Block \"%s\" has an illegal Blockstate Property \"%s\" which has <= 1 possible values. (%d possible values)", this.id, property.method_11899(), property.method_11898().size()));
        }
        this.blockStateProperties.add(property);
        return this;
    }

    public class_4970.class_2251 createProperties() {
        class_4970.class_2251 properties = class_4970.class_2251.method_9637((class_3614)this.material.getMinecraftMaterial());
        properties.method_9626(this.material.getSound());
        if (this.resistance >= 0.0f) {
            properties.method_9629(this.hardness, this.resistance);
        } else {
            properties.method_9632(this.hardness);
        }
        properties.method_9631(state -> (int)(this.lightLevel * 15.0f));
        if (this.noCollision) {
            properties.method_9634();
        }
        if (this.notSolid) {
            properties.method_22488();
        }
        if (this.requiresTool) {
            properties.method_29292();
        }
        if (this.lootTable == null) {
            properties.method_16229();
        }
        properties.method_9628(this.slipperiness);
        properties.method_23351(this.speedFactor);
        properties.method_23352(this.jumpFactor);
        if (this.noValidSpawns) {
            properties.method_26235((blockState, blockGetter, blockPos, object) -> false);
        }
        if (!this.suffocating) {
            properties.method_26243((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.viewBlocking) {
            properties.method_26245((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.redstoneConductor) {
            properties.method_26236((blockState, blockGetter, blockPos) -> false);
        }
        if (this.randomTickCallback != null) {
            properties.method_9640();
        }
        return properties;
    }
}

