/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.preload;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.layout.editor.ChoosePanoramaScreen;
import de.keksuccino.fancymenu.customization.layout.editor.ChooseSlideshowScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.preload.ResourcePreLoader;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageResourcePreLoadScreen
extends CellScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String cachedSerialized;
    protected Consumer<Boolean> callback;

    public ManageResourcePreLoadScreen(@NotNull Consumer<Boolean> callback) {
        super((class_2561)Components.translatable("fancymenu.resources.pre_loading.manage", new Object[0]));
        this.cachedSerialized = FancyMenu.getOptions().preLoadResources.getValue();
        this.callback = callback;
    }

    @Override
    protected void initCells() {
        this.addSpacerCell(10);
        for (ResourceSource source : ResourcePreLoader.getRegisteredResourceSources(this.cachedSerialized)) {
            Object sourceString = source instanceof ResourcePreLoader.CubicPanoramaSource ? "[" + class_1074.method_4662((String)"fancymenu.background.panorama", (Object[])new Object[0]) + "] " + source.getSourceWithoutPrefix() : (source instanceof ResourcePreLoader.SlideshowSource ? "[" + class_1074.method_4662((String)"fancymenu.background.slideshow", (Object[])new Object[0]) + "] " + source.getSourceWithoutPrefix() : ResourceSourceType.getWithoutSourcePrefix(source.getSerializationSource()));
            this.addLabelCell((class_2561)Components.literal((String)sourceString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))).putMemoryValue("source", source.getSerializationSource()).setSelectable(true);
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.resources.pre_loading.manage.add", new Object[0]), extendedButton -> {
            ResourceChooserScreen<Resource, FileType<Resource>> s = ResourceChooserScreen.generic(FileTypeGroup.allSupported(), null, source -> {
                if (source != null) {
                    this.cachedSerialized = ResourcePreLoader.addResourceSource(ResourcePreLoader.buildSourceFromString(source), this.cachedSerialized, false);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507(s);
        });
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.resources.pre_loading.manage.add.panorama", new Object[0]), extendedButton -> {
            ChoosePanoramaScreen s = new ChoosePanoramaScreen(null, panoramaName -> {
                if (panoramaName != null) {
                    this.cachedSerialized = ResourcePreLoader.addResourceSource(ResourcePreLoader.buildSourceFromString("[cubic_panorama]" + panoramaName), this.cachedSerialized, false);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.resources.pre_loading.manage.add.slideshow", new Object[0]), extendedButton -> {
            ChooseSlideshowScreen s = new ChooseSlideshowScreen(null, slideshowName -> {
                if (slideshowName != null) {
                    this.cachedSerialized = ResourcePreLoader.addResourceSource(ResourcePreLoader.buildSourceFromString("[slideshow]" + slideshowName), this.cachedSerialized, false);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.resources.pre_loading.manage.remove", new Object[0]), extendedButton -> {
            String source = this.getSelectedSource();
            if (source != null) {
                ConfirmationScreen s = ConfirmationScreen.warning(aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        this.cachedSerialized = ResourcePreLoader.removeResourceSource(ResourcePreLoader.buildSourceFromString(source), this.cachedSerialized, false);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedLines("fancymenu.resources.pre_loading.manage.remove.confirm", new String[0]));
                class_310.method_1551().method_1507((class_437)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedSource() != null);
    }

    @Nullable
    protected String getSelectedSource() {
        CellScreen.RenderCell cell = this.getSelectedCell();
        if (cell != null) {
            return cell.getMemoryValue("source");
        }
        return null;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(false);
    }

    @Override
    protected void onDone() {
        FancyMenu.getOptions().preLoadResources.setValue(this.cachedSerialized);
        this.callback.accept(true);
    }
}

