/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends class_339
implements UniqueWidget,
NavigatableWidget {
    @Nullable
    protected String widgetIdentifier;
    @NotNull
    protected TextAlignment alignment = TextAlignment.LEFT;
    @NotNull
    protected DrawableColor baseColor = DrawableColor.WHITE;
    protected boolean shadow = true;
    @NotNull
    protected class_327 font;

    @NotNull
    public static TextWidget empty(int x, int y, int width) {
        return new TextWidget(x, y, width, 9, class_310.method_1551().field_1772, (class_2561)Components.empty());
    }

    @NotNull
    public static TextWidget of(@NotNull class_2561 text, int x, int y, int width) {
        return new TextWidget(x, y, width, 9, class_310.method_1551().field_1772, text);
    }

    @NotNull
    public static TextWidget of(@NotNull String text, int x, int y, int width) {
        return TextWidget.of((class_2561)Components.literal(text), x, y, width);
    }

    public TextWidget(int x, int y, int width, int height, @NotNull class_327 font, @NotNull class_2561 text) {
        super(x, y, width, height, text);
        this.font = font;
    }

    public int getX() {
        return this.field_22760;
    }

    public void setX(int x) {
        this.field_22760 = x;
    }

    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        this.field_22761 = y;
    }

    public int method_25368() {
        return this.field_22758;
    }

    public void method_25358(int width) {
        this.field_22758 = width;
    }

    public int method_25364() {
        return this.field_22759;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public void method_25359(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
        int textWidth = this.getTextWidth();
        int textX = this.field_22760;
        int textY = this.field_22761;
        if (this.alignment == TextAlignment.CENTER) {
            textX = this.field_22760 + this.method_25368() / 2 - textWidth / 2;
        }
        if (this.alignment == TextAlignment.RIGHT) {
            textX = this.field_22760 + this.method_25368() - textWidth;
        }
        RenderingUtils.resetShaderColor(GuiGraphics.currentGraphics());
        if (this.shadow) {
            this.font.method_30881(pose, this.method_25369(), (float)textX, (float)textY, this.baseColor.getColorInt());
        } else {
            this.font.method_30883(pose, this.method_25369(), (float)textX, (float)textY, this.baseColor.getColorInt());
        }
        RenderingUtils.resetShaderColor(GuiGraphics.currentGraphics());
    }

    public int getTextWidth() {
        return this.font.method_30880(this.method_25369().method_30937());
    }

    @NotNull
    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    public TextWidget setTextAlignment(@NotNull TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        return this.baseColor;
    }

    public TextWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColor = baseColor;
        return this;
    }

    public boolean isShadowEnabled() {
        return this.shadow;
    }

    public TextWidget setShadowEnabled(boolean enabled) {
        this.shadow = enabled;
        return this;
    }

    @NotNull
    public class_327 getFont() {
        return this.font;
    }

    public TextWidget setFont(@NotNull class_327 font) {
        this.font = font;
        return this;
    }

    public TextWidget centerWidget(@NotNull class_437 parent) {
        this.field_22760 = parent.field_22789 / 2 - this.method_25368() / 2;
        return this;
    }

    @Override
    public TextWidget setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.widgetIdentifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.widgetIdentifier;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("TextWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("TextWidgets are not navigatable!");
    }

    public void method_25354(@NotNull class_1144 $$0) {
    }

    public static enum TextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

