/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class BrandingRenderer {
    private final class_327 font;
    private float opacity = 1.0f;
    private final int screenHeight;
    private final List<class_2561> lines;

    public BrandingRenderer(int screenHeight) {
        this.font = class_310.method_1551().field_1772;
        this.screenHeight = screenHeight;
        this.lines = Services.COMPAT.getTitleScreenBrandingLines();
        this.lines.removeIf(component -> component.getString().isBlank());
    }

    public BrandingRenderer setOpacity(float opacity) {
        this.opacity = opacity;
        return this;
    }

    public int getDefaultPositionX() {
        return 2;
    }

    public int getDefaultPositionY() {
        int totalHeight = this.getTotalHeight();
        int i = this.screenHeight - 2 - totalHeight;
        return ++i;
    }

    public int getTotalWidth() {
        int width = 0;
        for (class_2561 line : this.lines) {
            int lineWidth = this.font.method_27525((class_5348)line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public int getTotalHeight() {
        Objects.requireNonNull(this.font);
        int totalHeight = (9 + 1) * this.lines.size();
        if (totalHeight > 0) {
            --totalHeight;
        }
        return totalHeight;
    }

    public void render(@NotNull GuiGraphics graphics) {
        this.render(graphics, this.getDefaultPositionX(), this.getDefaultPositionY());
    }

    public void render(@NotNull GuiGraphics graphics, int x, int y) {
        RenderSystem.enableBlend();
        if (this.lines.isEmpty()) {
            return;
        }
        int currentY = y;
        for (class_2561 line : this.lines) {
            graphics.drawString(this.font, line, x, currentY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            Objects.requireNonNull(this.font);
            currentY += 9 + 1;
        }
    }
}

