/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.resource;

import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.file.FileFilter;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroups;
import de.keksuccino.fancymenu.util.file.type.types.AudioFileType;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.file.type.types.VideoFileType;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.ChooseFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.texture.SimpleTexture;
import de.keksuccino.fancymenu.util.resource.resources.video.IVideo;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceChooserScreen<R extends Resource, F extends FileType<R>>
extends CellScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final SimpleTexture WARNING_TEXTURE = SimpleTexture.location(new class_2960("fancymenu", "textures/warning_framed_24x24.png"));
    @Nullable
    protected FileTypeGroup<F> allowedFileTypes;
    @Nullable
    protected FileFilter fileFilter;
    @NotNull
    protected Consumer<String> resourceSourceCallback;
    @Nullable
    protected String resourceSource;
    @NotNull
    protected ResourceSourceType resourceSourceType = ResourceSourceType.LOCATION;
    protected boolean allowLocation = true;
    protected boolean allowLocal = true;
    protected boolean allowWeb = true;
    protected CycleButton<ResourceSourceType> resourceSourceTypeCycleButton;
    protected ExtendedEditBox editBox;
    protected boolean showWarningLegacyLocal = false;
    protected boolean showWarningNoExtension = false;
    protected boolean warningHovered = false;

    @NotNull
    public static ResourceChooserScreen<Resource, FileType<Resource>> generic(@Nullable FileTypeGroup<FileType<Resource>> fileTypes, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<Resource, FileType<Resource>>((class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose.generic", new Object[0]), fileTypes, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<Resource, FileType<Resource>> generic(@NotNull class_2561 title, @Nullable FileTypeGroup<FileType<Resource>> fileTypes, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<Resource, FileType<Resource>>(title, fileTypes, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<ITexture, ImageFileType> image(@NotNull class_2561 title, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<ITexture, ImageFileType>(title, FileTypeGroups.IMAGE_TYPES, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<ITexture, ImageFileType> image(@Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return ResourceChooserScreen.image((class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose.image", new Object[0]), fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IAudio, AudioFileType> audio(@NotNull class_2561 title, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<IAudio, AudioFileType>(title, FileTypeGroups.AUDIO_TYPES, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IAudio, AudioFileType> audio(@Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return ResourceChooserScreen.audio((class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose.audio", new Object[0]), fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IVideo, VideoFileType> video(@NotNull class_2561 title, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<IVideo, VideoFileType>(title, FileTypeGroups.VIDEO_TYPES, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IVideo, VideoFileType> video(@Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return ResourceChooserScreen.video((class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose.video", new Object[0]), fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IText, TextFileType> text(@NotNull class_2561 title, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return new ResourceChooserScreen<IText, TextFileType>(title, FileTypeGroups.TEXT_TYPES, fileFilter, resourceSourceCallback);
    }

    @NotNull
    public static ResourceChooserScreen<IText, TextFileType> text(@Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        return ResourceChooserScreen.text((class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose.text", new Object[0]), fileFilter, resourceSourceCallback);
    }

    public ResourceChooserScreen(@NotNull class_2561 title, @Nullable FileTypeGroup<F> allowedFileTypes, @Nullable FileFilter fileFilter, @NotNull Consumer<String> resourceSourceCallback) {
        super(title);
        this.allowedFileTypes = allowedFileTypes;
        this.fileFilter = fileFilter;
        this.resourceSourceCallback = resourceSourceCallback;
    }

    @Override
    protected void initCells() {
        boolean isLegacyLocal;
        LocalizedGenericValueCycle sourceTypeCycle = ResourceSourceType.LOCATION.cycle();
        if (!this.allowLocation) {
            sourceTypeCycle.removeValue(ResourceSourceType.LOCATION);
        }
        if (!this.allowLocal) {
            sourceTypeCycle.removeValue(ResourceSourceType.LOCAL);
        }
        if (!this.allowWeb) {
            sourceTypeCycle.removeValue(ResourceSourceType.WEB);
        }
        if (sourceTypeCycle.getValues().isEmpty()) {
            throw new IllegalStateException("There needs to be at least one allowed source type!");
        }
        if (!sourceTypeCycle.getValues().contains(this.resourceSourceType)) {
            this.resourceSource = null;
            this.resourceSourceType = (ResourceSourceType)sourceTypeCycle.getValues().get(0);
        }
        boolean isLocal = this.resourceSourceType == ResourceSourceType.LOCAL;
        boolean bl = isLegacyLocal = isLocal && this.resourceSource != null && !this.resourceSource.trim().isEmpty() && !this.resourceSource.startsWith("config/fancymenu/assets/") && !this.resourceSource.startsWith("/config/fancymenu/assets/");
        if (isLocal && this.resourceSource == null) {
            this.resourceSource = "/config/fancymenu/assets/";
        }
        if (isLocal && !this.resourceSource.startsWith("/") && this.resourceSource.startsWith("config/fancymenu/assets/")) {
            this.resourceSource = "/" + this.resourceSource;
        }
        this.addStartEndSpacerCell();
        this.resourceSourceTypeCycleButton = new CycleButton<ResourceSourceType>(0, 0, 20, 20, sourceTypeCycle, (value, button) -> {
            this.resourceSource = null;
            this.resourceSourceType = value;
            this.rebuild();
        });
        this.resourceSourceTypeCycleButton.setTooltipSupplier(consumes -> {
            if (this.resourceSourceType == ResourceSourceType.LOCATION) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.source_type.location.desc", new String[0]));
            }
            if (this.resourceSourceType == ResourceSourceType.LOCAL) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.source_type.local.desc", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.source_type.web.desc", new String[0]));
        });
        this.resourceSourceTypeCycleButton.setSelectedValue(this.resourceSourceType);
        this.addWidgetCell((class_339)this.resourceSourceTypeCycleButton, true);
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)Components.translatable("fancymenu.resources.chooser_screen.source", new Object[0]));
        CellScreen.TextInputCell sourceInputCell = this.addTextInputCell(null, !isLegacyLocal, !isLegacyLocal);
        this.editBox = sourceInputCell.editBox;
        if (isLocal && !isLegacyLocal) {
            this.editBox.setInputPrefix("/config/fancymenu/assets/");
        }
        this.editBox.method_1852(this.resourceSource != null ? this.resourceSource : "");
        this.editBox.method_1875(0);
        this.editBox.setDisplayPosition(0);
        this.editBox.method_1884(0);
        this.editBox.applyInputPrefixSuffixCharacterRenderFormatter();
        this.editBox.method_1888(!isLegacyLocal);
        this.editBox.setDeleteAllAllowed(false);
        this.editBox.method_1863(s -> {
            this.resourceSource = s;
        });
        sourceInputCell.setEditorCallback((s, textInputCell) -> {
            if (isLocal && !isLegacyLocal && !((String)s).startsWith("/config/fancymenu/assets/")) {
                s = "/config/fancymenu/assets/" + (String)s;
            }
            this.resourceSource = s;
        });
        sourceInputCell.setEditorPresetTextSupplier(consumes -> consumes.editBox.getValueWithoutPrefixSuffix());
        if (isLocal) {
            this.addWidgetCell((class_339)new ExtendedButton(0, 0, 20, 20, (class_2561)Components.translatable("fancymenu.resources.chooser_screen.choose_local", new Object[0]), var1 -> {
                File startDir = LayoutHandler.ASSETS_DIR;
                String path = this.resourceSource;
                if (path != null && (startDir = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path)).getParentFile()) == null) {
                    startDir = LayoutHandler.ASSETS_DIR;
                }
                ChooseFileScreen fileChooser = new ChooseFileScreen(LayoutHandler.ASSETS_DIR, startDir, call -> {
                    if (call != null) {
                        Object s = GameDirectoryUtils.getPathWithoutGameDirectory(call.getAbsolutePath());
                        if (!((String)s).startsWith("/")) {
                            s = "/" + (String)s;
                        }
                        s = ResourceSourceType.LOCAL.getSourcePrefix() + (String)s;
                        this.setSource((String)s, false);
                    }
                    this.rebuild();
                    class_310.method_1551().method_1507((class_437)this);
                });
                fileChooser.setVisibleDirectoryLevelsAboveRoot(2);
                fileChooser.setFileTypes(this.allowedFileTypes);
                fileChooser.setFileFilter(this.fileFilter);
                class_310.method_1551().method_1507((class_437)fileChooser);
            }), true);
        }
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)Components.translatable("fancymenu.resources.chooser_screen.allowed_file_types", new Object[0]));
        class_5250 typesComponent = Components.translatable("fancymenu.file_browser.file_type.types.all", new Object[0]).method_27693(" (*)");
        if (this.allowedFileTypes != null) {
            Object types = "";
            for (FileType type : this.allowedFileTypes.getFileTypes()) {
                for (String s2 : type.getExtensions()) {
                    if (!((String)types).isEmpty()) {
                        types = (String)types + ";";
                    }
                    types = (String)types + "*." + s2.toUpperCase();
                }
            }
            class_2561 fileTypeDisplayName = this.allowedFileTypes.getDisplayName();
            if (fileTypeDisplayName == null) {
                fileTypeDisplayName = Components.empty();
            }
            typesComponent = Components.empty().method_10852(fileTypeDisplayName).method_10852((class_2561)Components.literal(" (")).method_10852((class_2561)Components.literal((String)types)).method_10852((class_2561)Components.literal(")"));
        }
        this.addLabelCell((class_2561)typesComponent.method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
        this.addCellGroupEndSpacerCell();
        this.addStartEndSpacerCell();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateLegacyLocalWarning();
        this.updateNoExtensionWarning();
        super.render(graphics, mouseX, mouseY, partial);
        this.renderWarning(graphics, mouseX, mouseY, partial);
        this.updateInputFieldTooltips();
    }

    protected void updateInputFieldTooltips() {
        if (!this.showWarningNoExtension && this.resourceSourceType == ResourceSourceType.LOCATION && this.editBox != null && (((IMixinAbstractWidget)((Object)this.editBox)).getIsHoveredFancyMenu() || this.warningHovered)) {
            TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.source_type.location.desc.input", new String[0])).setDefaultStyle(), () -> true, false, true);
        }
        if (this.showWarningLegacyLocal && this.editBox != null && (((IMixinAbstractWidget)((Object)this.editBox)).getIsHoveredFancyMenu() || this.warningHovered)) {
            TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.chooser_screen.legacy_local.warning", new String[0])).setDefaultStyle().setTextBaseColor(UIBase.getUIColorTheme().warning_text_color), () -> true, false, true);
        }
        if (!this.showWarningLegacyLocal && this.showWarningNoExtension && this.editBox != null && (((IMixinAbstractWidget)((Object)this.editBox)).getIsHoveredFancyMenu() || this.warningHovered)) {
            TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.chooser_screen.no_extension.warning", new String[0])).setDefaultStyle().setTextBaseColor(UIBase.getUIColorTheme().warning_text_color), () -> true, false, true);
        }
    }

    protected void renderWarning(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        class_2960 loc;
        if ((this.showWarningLegacyLocal || this.showWarningNoExtension) && this.editBox != null && (loc = WARNING_TEXTURE.getResourceLocation()) != null) {
            int h = this.editBox.method_25364() - 4;
            int w = WARNING_TEXTURE.getAspectRatio().getAspectRatioWidth(h);
            int x = this.editBox.field_22760 - w - 2;
            int y = this.editBox.field_22761 + 2;
            this.warningHovered = UIBase.isXYInArea(mouseX, mouseY, x, y, w, h);
            RenderingUtils.setShaderColor(graphics, UIBase.getUIColorTheme().warning_text_color, 1.0f);
            graphics.blit(loc, x, y, 0.0f, 0.0f, w, h, w, h);
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void updateLegacyLocalWarning() {
        this.showWarningLegacyLocal = this.resourceSourceType == ResourceSourceType.LOCAL && this.resourceSource != null && !this.resourceSource.trim().isEmpty() && !this.resourceSource.startsWith("config/fancymenu/assets/") && !this.resourceSource.startsWith("/config/fancymenu/assets/");
    }

    protected void updateNoExtensionWarning() {
        boolean emptyAssetDir;
        boolean bl = emptyAssetDir = this.resourceSourceType == ResourceSourceType.LOCAL && this.resourceSource != null && this.resourceSource.equals("/config/fancymenu/assets/");
        if (!emptyAssetDir && this.resourceSource != null && !this.resourceSource.replace(" ", "").isEmpty()) {
            boolean extensionFound = false;
            if (this.allowedFileTypes != null) {
                for (FileType fileType : this.allowedFileTypes.getFileTypes()) {
                    for (String extension : fileType.getExtensions()) {
                        if (!this.resourceSource.toLowerCase().endsWith("." + extension)) continue;
                        extensionFound = true;
                        break;
                    }
                    if (!extensionFound) continue;
                    break;
                }
            } else {
                extensionFound = true;
            }
            if (!extensionFound) {
                this.showWarningNoExtension = true;
                return;
            }
        }
        this.showWarningNoExtension = false;
    }

    public ResourceChooserScreen<R, F> setSource(@Nullable String resourceSource, boolean updateScreen) {
        if (resourceSource == null) {
            this.resourceSource = null;
            this.resourceSourceType = ResourceSourceType.LOCATION;
        } else {
            resourceSource = resourceSource.trim();
            this.resourceSourceType = ResourceSourceType.getSourceTypeOf(PlaceholderParser.replacePlaceholders(resourceSource, false));
            this.resourceSource = ResourceSourceType.getWithoutSourcePrefix(resourceSource);
        }
        if (updateScreen) {
            this.rebuild();
        }
        return this;
    }

    public ResourceChooserScreen<R, F> setAllowedFileTypes(@Nullable FileTypeGroup<F> allowedFileTypes) {
        this.allowedFileTypes = allowedFileTypes;
        this.rebuild();
        return this;
    }

    public ResourceChooserScreen<R, F> setFileFilter(@Nullable FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.rebuild();
        return this;
    }

    public ResourceChooserScreen<R, F> setResourceSourceCallback(@NotNull Consumer<String> resourceSourceCallback) {
        this.resourceSourceCallback = Objects.requireNonNull(resourceSourceCallback);
        return this;
    }

    public boolean isLocationSourceAllowed() {
        return this.allowLocation;
    }

    public ResourceChooserScreen<R, F> setLocationSourceAllowed(boolean allowLocation) {
        this.allowLocation = allowLocation;
        this.rebuild();
        return this;
    }

    public boolean isLocalSourceAllowed() {
        return this.allowLocal;
    }

    public ResourceChooserScreen<R, F> setLocalSourceAllowed(boolean allowLocal) {
        this.allowLocal = allowLocal;
        this.rebuild();
        return this;
    }

    public boolean isWebSourceAllowed() {
        return this.allowWeb;
    }

    public ResourceChooserScreen<R, F> setWebSourceAllowed(boolean allowWeb) {
        this.allowWeb = allowWeb;
        this.rebuild();
        return this;
    }

    @Override
    public boolean allowDone() {
        if (this.resourceSource == null || this.resourceSource.replace(" ", "").isEmpty()) {
            return false;
        }
        return this.resourceSourceType != ResourceSourceType.LOCAL || !this.resourceSource.equals("/config/fancymenu/assets/");
    }

    @Override
    protected void onCancel() {
        this.resourceSourceCallback.accept(null);
    }

    @Override
    protected void onDone() {
        if (this.resourceSource == null) {
            this.resourceSourceCallback.accept(null);
        } else {
            this.resourceSourceCallback.accept(this.resourceSourceType.getSourcePrefix() + this.resourceSource);
        }
    }
}

