/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui;

import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.rendering.ui.FocuslessContainerEventHandler;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public abstract class UIComponent
extends UIBase
implements FocuslessContainerEventHandler,
Renderable,
class_6379 {
    public float posZ = 0.0f;
    protected boolean hovered = false;
    protected boolean visible = true;
    protected class_310 mc = class_310.method_1551();
    protected boolean dragging = false;
    protected final List<class_364> children = new ArrayList<class_364>();

    public abstract void renderComponent(@NotNull GuiGraphics var1, double var2, double var4, float var6);

    @Override
    public void render(@NotNull GuiGraphics graphics, int ignoredMouseX, int ignoredMouseY, float partial) {
        if (!this.isVisible()) {
            return;
        }
        this.hovered = this.isMouseOver();
        graphics.pose().method_22903();
        graphics.pose().method_22905(this.getFixedComponentScale(), this.getFixedComponentScale(), this.getFixedComponentScale());
        graphics.pose().method_22904((double)this.getTranslatedX(), (double)this.getTranslatedY(), (double)this.posZ);
        this.renderComponent(graphics, this.getRealMouseX(), this.getRealMouseY(), partial);
        graphics.pose().method_22909();
    }

    protected float getRealX() {
        return 0.0f;
    }

    protected float getRealY() {
        return 0.0f;
    }

    public abstract float getTranslatedX();

    public abstract float getTranslatedY();

    public abstract float getWidth();

    public abstract float getHeight();

    public double getRealMouseX() {
        return (this.mc.field_1729.method_1603() - (double)(this.getTranslatedX() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getRealMouseY() {
        return (this.mc.field_1729.method_1604() - (double)(this.getTranslatedY() * this.getComponentScale())) / (double)this.getComponentScale();
    }

    public double getTranslatedMouseX() {
        return this.mc.field_1729.method_1603() / (double)this.getComponentScale();
    }

    public double getTranslatedMouseY() {
        return this.mc.field_1729.method_1604() / (double)this.getComponentScale();
    }

    protected float getScreenWidth() {
        return (float)this.mc.method_22683().method_4489() / this.getComponentScale();
    }

    protected float getScreenHeight() {
        return (float)this.mc.method_22683().method_4506() / this.getComponentScale();
    }

    protected boolean isComponentAreaHovered(float x, float y, float width, float height, boolean isRealPosition) {
        double mX = this.getRealMouseX();
        double mY = this.getRealMouseY();
        if (!isRealPosition) {
            x -= this.getTranslatedX();
            y -= this.getTranslatedY();
        }
        return UIComponent.isXYInArea(mX, mY, x, y, width + 1.0f, height + 1.0f);
    }

    public float getComponentScale() {
        return UIComponent.getUIScale();
    }

    public float getFixedComponentScale() {
        return UIComponent.calculateFixedScale(this.getComponentScale());
    }

    protected void enableComponentScissor(GuiGraphics graphics, int x, int y, int width, int height, boolean isRealPosition) {
        if (isRealPosition) {
            x = (int)((float)x + this.getTranslatedX());
            y = (int)((float)y + this.getTranslatedY());
        }
        int scissorX = (int)((float)x * this.getFixedComponentScale());
        int scissorY = (int)((float)y * this.getFixedComponentScale());
        int scissorWidth = (int)((float)width * this.getFixedComponentScale());
        int scissorHeight = (int)((float)height * this.getFixedComponentScale());
        graphics.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
    }

    protected void disableComponentScissor(GuiGraphics graphics) {
        graphics.disableScissor();
    }

    public boolean isHovered() {
        if (!this.isVisible()) {
            return false;
        }
        return this.hovered;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @NotNull
    public List<class_364> method_25396() {
        return this.children;
    }

    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25402(realMouseX, realMouseY, button)) continue;
            this.method_25395(child);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean method_25402(double ignoredMouseX, double ignoredMouseY, int button) {
        return this.mouseClickedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), button);
    }

    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        this.method_25398(false);
        for (class_364 child : this.method_25396()) {
            if (!child.method_25406(realMouseX, realMouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean method_25406(double ignoredMouseX, double ignoredMouseY, int button) {
        return this.mouseReleasedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), button);
    }

    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (this.method_25397() && button == 0) {
            for (class_364 child : this.method_25396()) {
                if (!child.method_25403(this.getRealMouseX(), this.getRealMouseY(), button, d1, d2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean method_25403(double ignoredMouseX, double ignoredMouseY, int button, double d1, double d2) {
        return this.mouseDraggedComponent(this.getTranslatedMouseX(), this.getTranslatedMouseY(), button, d1, d2);
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDelta) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25401(realMouseX, realMouseY, scrollDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean method_25401(double ignoredMouseX, double ignoredMouseY, double scrollDelta) {
        return this.mouseScrolledComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), scrollDelta);
    }

    protected void mouseMovedComponent(double realMouseX, double realMouseY) {
    }

    @Deprecated
    public void method_16014(double ignoredMouseX, double ignoredMouseY) {
        this.mouseMovedComponent(this.getRealMouseX(), this.getRealMouseY());
    }

    public boolean isMouseOver() {
        if (!this.isVisible()) {
            return false;
        }
        return this.isComponentAreaHovered(this.getTranslatedX(), this.getTranslatedY(), this.getWidth(), this.getHeight(), false);
    }

    @Deprecated
    public boolean method_25405(double ignoredMouseX, double ignoredMouseY) {
        return this.isMouseOver();
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }
}

