/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownTextLine;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownTextFragment
implements Renderable,
class_364 {
    protected static final int BULLET_LIST_SPACE_AFTER_INDENT = 5;
    public final MarkdownRenderer parent;
    public MarkdownTextLine parentLine;
    public String text;
    public float x;
    public float y;
    public float unscaledTextWidth;
    public float unscaledTextHeight;
    public boolean startOfRenderLine = false;
    public boolean naturalLineBreakAfter;
    public boolean autoLineBreakAfter;
    public boolean endOfWord;
    public ResourceSupplier<ITexture> imageSupplier = null;
    public boolean separationLine;
    public DrawableColor textColor = null;
    public boolean bold;
    public boolean italic;
    public boolean strikethrough;
    public boolean bulletListItemStart = false;
    public int bulletListLevel = 0;
    @NotNull
    public MarkdownRenderer.MarkdownLineAlignment alignment = MarkdownRenderer.MarkdownLineAlignment.LEFT;
    public Hyperlink hyperlink = null;
    @NotNull
    public HeadlineType headlineType = HeadlineType.NONE;
    public QuoteContext quoteContext = null;
    public CodeBlockContext codeBlockContext = null;
    public boolean plainText = false;
    public class_2960 font = null;
    public boolean hovered = false;

    public MarkdownTextFragment(@NotNull MarkdownRenderer parent, @NotNull String text) {
        this.parent = parent;
        this.text = text;
        Objects.requireNonNull(this.parent.font);
        this.unscaledTextHeight = 9.0f;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.hovered = this.method_25405(mouseX, mouseY);
        if (this.hyperlink != null && this.hovered) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_POINTING_HAND);
        }
        if (this.imageSupplier != null) {
            this.imageSupplier.forRenderable((iTexture, location) -> {
                RenderSystem.enableBlend();
                graphics.setColor(1.0f, 1.0f, 1.0f, this.parent.textOpacity);
                RenderingUtils.blitF(graphics, location, this.x, this.y, 0.0f, 0.0f, this.getRenderWidth(), this.getRenderHeight(), this.getRenderWidth(), this.getRenderHeight());
                RenderingUtils.resetShaderColor(graphics);
            });
        } else if (this.separationLine) {
            RenderSystem.enableBlend();
            RenderingUtils.fillF(graphics, this.parent.x + this.parent.border, this.y, this.parent.x + this.parent.getRealWidth() - this.parent.border, this.y + this.getRenderHeight(), this.parent.separationLineColor.getColorIntWithAlpha(this.parent.textOpacity));
            RenderingUtils.resetShaderColor(graphics);
        } else {
            this.renderCodeBlock(graphics);
            RenderSystem.enableBlend();
            graphics.pose().method_22903();
            graphics.pose().method_22905(this.getScale(), this.getScale(), this.getScale());
            graphics.drawString(this.parent.font, this.buildRenderComponent(false), (int)this.getTextRenderX(), (int)this.getTextRenderY(), this.parent.textBaseColor.getColorIntWithAlpha(this.parent.textOpacity), this.parent.textShadow && this.codeBlockContext == null);
            graphics.pose().method_22909();
            RenderingUtils.resetShaderColor(graphics);
            this.renderQuoteLine(graphics);
            this.renderBulletListDot(graphics);
            this.renderHeadlineUnderline(graphics);
        }
    }

    protected void renderCodeBlock(GuiGraphics graphics) {
        if (this.codeBlockContext != null && this.parentLine != null) {
            MarkdownTextFragment start = this.codeBlockContext.getBlockStart();
            MarkdownTextFragment end = this.codeBlockContext.getBlockEnd();
            if (this.codeBlockContext.singleLine) {
                MarkdownTextLine.SingleLineCodeBlockPart part = this.parentLine.singleLineCodeBlockStartEndPairs.get(this.codeBlockContext);
                if (part == null) {
                    return;
                }
                start = part.start;
                end = part.end;
            }
            if (start != this) {
                return;
            }
            if (end == null) {
                return;
            }
            if (this.codeBlockContext.singleLine) {
                float xEnd = end.x + end.getRenderWidth();
                if (end.text.endsWith(" ")) {
                    xEnd -= (float)this.parent.font.method_1727(" ") * this.getScale();
                }
                this.renderCodeBlockBackground(graphics, this.x, this.y - 2.0f, xEnd, this.y + this.getTextRenderHeight(), this.parent.codeBlockSingleLineColor.getColorIntWithAlpha(this.parent.textOpacity));
            } else {
                this.renderCodeBlockBackground(graphics, this.parent.x + this.parent.border, this.y, this.parent.x + this.parent.getRealWidth() - this.parent.border - 1.0f, end.y + end.getRenderHeight() - 1.0f, this.parent.codeBlockMultiLineColor.getColorIntWithAlpha(this.parent.textOpacity));
            }
        }
    }

    protected void renderCodeBlockBackground(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderSystem.enableBlend();
        RenderingUtils.fillF(graphics, minX + 1.0f, minY, maxX - 1.0f, minY + 1.0f, color);
        RenderingUtils.fillF(graphics, minX, minY + 1.0f, maxX, maxY - 1.0f, color);
        RenderingUtils.fillF(graphics, minX + 1.0f, maxY - 1.0f, maxX - 1.0f, maxY, color);
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderHeadlineUnderline(GuiGraphics graphics) {
        if (this.startOfRenderLine && (this.headlineType == HeadlineType.BIGGER || this.headlineType == HeadlineType.BIGGEST)) {
            RenderSystem.enableBlend();
            float scale = this.parent.parentRenderScale != null ? this.parent.parentRenderScale.floatValue() : (float)class_310.method_1551().method_22683().method_4495();
            float lineThickness = scale > 1.0f ? 0.5f : 1.0f;
            float lineY = this.y + this.getTextRenderHeight() + 1.0f;
            RenderingUtils.fillF(graphics, this.parent.x + this.parent.border, lineY, this.parent.x + this.parent.getRealWidth() - this.parent.border - 1.0f, lineY + lineThickness, this.parent.headlineUnderlineColor.getColorIntWithAlpha(this.parent.textOpacity));
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderQuoteLine(GuiGraphics graphics) {
        if (this.quoteContext != null && this.quoteContext.getQuoteEnd() != null && this.quoteContext.getQuoteEnd() == this) {
            float yStart = Objects.requireNonNull(this.quoteContext.getQuoteStart()).y - 2.0f;
            float yEnd = this.y + this.getRenderHeight() + 1.0f;
            RenderSystem.enableBlend();
            if (this.alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT) {
                RenderingUtils.fillF(graphics, this.parent.x, yStart, this.parent.x + 2.0f, yEnd, this.parent.quoteColor.getColorIntWithAlpha(this.parent.textOpacity));
            } else if (this.alignment == MarkdownRenderer.MarkdownLineAlignment.RIGHT) {
                RenderingUtils.fillF(graphics, this.parent.x + this.parent.getRealWidth() - this.parent.border - 2.0f, yStart, this.parent.x + this.parent.getRealWidth() - this.parent.border - 1.0f, yEnd, this.parent.quoteColor.getColorIntWithAlpha(this.parent.textOpacity));
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderBulletListDot(GuiGraphics graphics) {
        if (this.bulletListLevel > 0 && this.bulletListItemStart) {
            RenderSystem.enableBlend();
            float scale = this.getScale();
            float bulletSize = 3.0f * scale;
            float bulletX = this.x - 5.0f * scale + this.parent.bulletListIndent * (float)this.bulletListLevel * scale;
            float f = this.getTextY();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            float textBaselineY = f + 9.0f * scale * 0.5f - bulletSize * 0.5f;
            RenderingUtils.fillF(graphics, bulletX, textBaselineY, bulletX + bulletSize, textBaselineY + bulletSize, this.parent.bulletListDotColor.getColorIntWithAlpha(this.parent.textOpacity));
        }
    }

    @NotNull
    protected class_2561 buildRenderComponent(boolean forWidthCalculation) {
        class_2583 style = class_2583.field_24360;
        if (this.font != null) {
            style = style.method_27704(this.font);
        }
        if (this.italic) {
            style = style.method_10978(Boolean.valueOf(true));
        }
        if (this.bold) {
            style = style.method_10982(Boolean.valueOf(true));
        }
        if (this.strikethrough && !forWidthCalculation) {
            style = style.method_36140(Boolean.valueOf(true));
        }
        if (this.quoteContext != null) {
            style = style.method_36139(this.parent.quoteColor.getColorInt());
            if (this.parent.quoteItalic) {
                style = style.method_10978(Boolean.valueOf(true));
            }
        }
        if (this.textColor != null) {
            style = style.method_36139(this.textColor.getColorInt());
        }
        if (this.hyperlink != null) {
            style = style.method_36139(this.parent.hyperlinkColor.getColorInt());
            if (this.hyperlink.isHovered()) {
                style = style.method_30938(Boolean.valueOf(true));
            }
        }
        boolean addSpaceComponentAtEnd = false;
        String t = this.text;
        if (this.hyperlink != null && (this.naturalLineBreakAfter || this.autoLineBreakAfter) && t.endsWith(" ")) {
            t = t.substring(0, t.length() - 1);
        } else if (this.hyperlink != null && ListUtils.getLast(this.hyperlink.hyperlinkFragments) == this && t.endsWith(" ")) {
            t = t.substring(0, t.length() - 1);
            addSpaceComponentAtEnd = true;
        }
        if (this.codeBlockContext != null) {
            style = class_2583.field_24360;
        }
        if (this.plainText) {
            style = class_2583.field_24360;
        }
        if (this.parent.textCase == MarkdownRenderer.TextCase.ALL_UPPER) {
            t = t.toUpperCase();
        }
        if (this.parent.textCase == MarkdownRenderer.TextCase.ALL_LOWER) {
            t = t.toLowerCase();
        }
        class_5250 comp = Components.literal(t).method_10862(style);
        if (addSpaceComponentAtEnd) {
            comp.method_10852((class_2561)Components.literal(" ").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(false))));
        }
        return comp;
    }

    protected void updateWidth() {
        this.unscaledTextWidth = this.parent.font.method_27525((class_5348)this.buildRenderComponent(true));
    }

    public float getTextRenderX() {
        float baseX = this.x / this.getScale();
        if (this.quoteContext != null && this.startOfRenderLine && this.alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT) {
            baseX += this.parent.quoteIndent;
        }
        if (this.bulletListLevel > 0 && this.startOfRenderLine) {
            float bulletIndent = this.parent.bulletListIndent * (float)this.bulletListLevel + 5.0f;
            baseX += bulletIndent;
        }
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && this.startOfRenderLine) {
            baseX += 10.0f;
        }
        if (this.codeBlockContext != null && this.codeBlockContext.singleLine && this.codeBlockContext.getBlockStart() == this) {
            baseX += 1.0f;
        }
        return (int)baseX;
    }

    public float getTextRenderY() {
        float f = this.y / this.getScale();
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && this.codeBlockContext.getBlockStart() != null && this.codeBlockContext.getBlockStart().y == this.y) {
            f += 10.0f;
        }
        if (this.bulletListLevel > 0 && this.parentLine != null && this.parentLine.bulletListItemStartLine) {
            f += this.parent.bulletListSpacing;
        }
        return (int)f;
    }

    public float getRenderWidth() {
        if (this.imageSupplier != null) {
            ITexture t = this.imageSupplier.get();
            if (t == null) {
                return 10.0f;
            }
            if ((float)t.getWidth() <= this.parent.getRealWidth() - this.parent.border - this.parent.border) {
                return t.getWidth();
            }
            return this.parent.getRealWidth() - this.parent.border - this.parent.border;
        }
        float f = this.getTextRenderWidth();
        if (this.quoteContext != null && this.startOfRenderLine && this.alignment == MarkdownRenderer.MarkdownLineAlignment.LEFT) {
            f += this.parent.quoteIndent * this.getScale();
        }
        if (this.quoteContext != null && (this.naturalLineBreakAfter || this.autoLineBreakAfter) && this.alignment == MarkdownRenderer.MarkdownLineAlignment.RIGHT) {
            f += this.parent.quoteIndent;
        }
        if (this.bulletListLevel > 0 && this.startOfRenderLine) {
            float bulletSpace = this.parent.bulletListIndent * (float)this.bulletListLevel * this.getScale() + 5.0f * this.getScale();
            f += bulletSpace;
        }
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && this.startOfRenderLine) {
            f += 10.0f;
        }
        if (this.codeBlockContext != null && this.codeBlockContext.singleLine && this.codeBlockContext.getBlockStart() == this) {
            f += 1.0f;
        }
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && (this.autoLineBreakAfter || this.naturalLineBreakAfter)) {
            f += 10.0f;
        }
        if (this.codeBlockContext != null && this.codeBlockContext.singleLine && this.codeBlockContext.getBlockEnd() == this) {
            f += 1.0f;
        }
        return f;
    }

    public float getRenderHeight() {
        if (this.imageSupplier != null) {
            ITexture t = this.imageSupplier.get();
            if (t == null) {
                return 10.0f;
            }
            return t.getAspectRatio().getAspectRatioHeight((int)this.getRenderWidth());
        }
        float f = this.getTextRenderHeight();
        if (this.headlineType == HeadlineType.BIGGER || this.headlineType == HeadlineType.BIGGEST) {
            f += 8.0f;
        }
        if (this.headlineType == HeadlineType.BIG) {
            f += 6.0f;
        }
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && this.codeBlockContext.getBlockStart() != null && this.codeBlockContext.getBlockStart().y == this.y) {
            f += 10.0f;
        }
        if (this.codeBlockContext != null && !this.codeBlockContext.singleLine && this.codeBlockContext.getBlockEnd() != null && this.codeBlockContext.getBlockEnd().y == this.y) {
            f += 10.0f;
        }
        if (this.bulletListLevel > 0 && this.bulletListItemStart) {
            f += this.parent.bulletListSpacing;
        }
        return f;
    }

    public float getTextRenderWidth() {
        return this.unscaledTextWidth * this.getScale();
    }

    public float getTextRenderHeight() {
        return this.unscaledTextHeight * this.getScale();
    }

    public float getTextX() {
        float f = this.getTextRenderX();
        f -= this.x / this.getScale();
        return f += this.x;
    }

    public float getTextY() {
        float f = this.getTextRenderY();
        f -= this.y / this.getScale();
        return f += this.y;
    }

    public float getTextWidth() {
        return this.getTextRenderWidth();
    }

    public float getTextHeight() {
        return this.getTextRenderHeight();
    }

    public float getScale() {
        float f = 1.0f;
        if (this.headlineType == HeadlineType.BIG) {
            f = 1.2f;
        }
        if (this.headlineType == HeadlineType.BIGGER) {
            f = 1.6f;
        }
        if (this.headlineType == HeadlineType.BIGGEST) {
            f = 2.0f;
        }
        return f * this.parent.textBaseScale;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.imageSupplier != null && this.imageSupplier.get() != null) {
            return RenderingUtils.isXYInArea(mouseX, mouseY, this.x, this.y, this.getRenderWidth(), this.getRenderHeight());
        }
        return RenderingUtils.isXYInArea(mouseX, mouseY, this.getTextX(), this.getTextY(), this.getTextWidth(), this.getTextHeight());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hyperlink != null && this.hovered) {
            WebUtils.openWebLink(this.hyperlink.link);
            return true;
        }
        return false;
    }

    public static class Hyperlink {
        public String link = null;
        public final List<MarkdownTextFragment> hyperlinkFragments = new ArrayList<MarkdownTextFragment>();

        public boolean isHovered() {
            for (MarkdownTextFragment f : this.hyperlinkFragments) {
                if (!f.hovered) continue;
                return true;
            }
            return false;
        }
    }

    public static enum HeadlineType {
        NONE,
        BIG,
        BIGGER,
        BIGGEST;

    }

    public static class QuoteContext {
        public final List<MarkdownTextFragment> quoteFragments = new ArrayList<MarkdownTextFragment>();

        @Nullable
        public MarkdownTextFragment getQuoteStart() {
            if (!this.quoteFragments.isEmpty()) {
                return this.quoteFragments.get(0);
            }
            return null;
        }

        @Nullable
        public MarkdownTextFragment getQuoteEnd() {
            if (!this.quoteFragments.isEmpty()) {
                return this.quoteFragments.get(this.quoteFragments.size() - 1);
            }
            return null;
        }
    }

    public static class CodeBlockContext {
        public final List<MarkdownTextFragment> codeBlockFragments = new ArrayList<MarkdownTextFragment>();
        public boolean singleLine = true;

        @Nullable
        public MarkdownTextFragment getBlockStart() {
            if (!this.codeBlockFragments.isEmpty()) {
                return this.codeBlockFragments.get(0);
            }
            return null;
        }

        @Nullable
        public MarkdownTextFragment getBlockEnd() {
            if (!this.codeBlockFragments.isEmpty()) {
                return this.codeBlockFragments.get(this.codeBlockFragments.size() - 1);
            }
            return null;
        }
    }
}

