/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.gui;

import de.keksuccino.fancymenu.util.rendering.gui.ScreenAxis;
import de.keksuccino.fancymenu.util.rendering.gui.ScreenDirection;

public record ScreenPosition(int x, int y) {
    public static ScreenPosition of(ScreenAxis axis, int primaryPosition, int secondaryPosition) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAxis.HORIZONTAL -> new ScreenPosition(primaryPosition, secondaryPosition);
            case ScreenAxis.VERTICAL -> new ScreenPosition(secondaryPosition, primaryPosition);
        };
    }

    public ScreenPosition step(ScreenDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenDirection.DOWN -> new ScreenPosition(this.x, this.y + 1);
            case ScreenDirection.UP -> new ScreenPosition(this.x, this.y - 1);
            case ScreenDirection.LEFT -> new ScreenPosition(this.x - 1, this.y);
            case ScreenDirection.RIGHT -> new ScreenPosition(this.x + 1, this.y);
        };
    }

    public int getCoordinate(ScreenAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case ScreenAxis.HORIZONTAL -> this.x;
            case ScreenAxis.VERTICAL -> this.y;
        };
    }
}

