/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.rendering.gui.ClientTooltipPositioner;
import de.keksuccino.fancymenu.util.rendering.gui.DefaultTooltipPositioner;
import de.keksuccino.fancymenu.util.rendering.gui.Divisor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiMatrix4f;
import de.keksuccino.fancymenu.util.rendering.gui.GuiRenderTypes;
import de.keksuccino.fancymenu.util.rendering.gui.ScreenRectangle;
import de.keksuccino.fancymenu.util.rendering.gui.TooltipRenderUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

public class GuiGraphics {
    public static final class_437 DUMMY_SCREEN = ObjectUtils.build(() -> {
        class_442 s = new class_442();
        s.method_25423(class_310.method_1551(), 1000, 1000);
        return s;
    });
    public static final class_332 GUI_COMPONENT = new class_332(){

        protected void method_25292(class_4587 $$0, int $$1, int $$2, int $$3, int $$4) {
            super.method_25292($$0, $$1, $$2, $$3, $$4);
        }
    };
    public static final float MAX_GUI_Z = 10000.0f;
    public static final float MIN_GUI_Z = -10000.0f;
    private static final int EXTRA_SPACE_AFTER_FIRST_TOOLTIP_LINE = 2;
    private final class_310 minecraft;
    private final class_4587 pose;
    private final class_4597.class_4598 bufferSource;
    private final ScissorStack scissorStack = new ScissorStack();
    private boolean managed;
    protected static GuiGraphics currentGraphics = null;

    @NotNull
    public static GuiGraphics updateGraphicsAndGet(@NotNull class_4587 pose, @NotNull class_4597.class_4598 bufferSource) {
        currentGraphics = new GuiGraphics(class_310.method_1551(), pose, bufferSource);
        return currentGraphics;
    }

    public static GuiGraphics currentGraphics() {
        return currentGraphics;
    }

    private GuiGraphics(class_310 minecraft, class_4587 pose, class_4597.class_4598 bufferSource) {
        this.minecraft = minecraft;
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public GuiGraphics(class_310 minecraft, class_4597.class_4598 bufferSource) {
        this(minecraft, new class_4587(), bufferSource);
    }

    public class_4597.class_4598 getBufferSource() {
        return this.bufferSource;
    }

    public void drawManaged(Runnable runnable) {
        this.flush();
        this.managed = true;
        runnable.run();
        this.managed = false;
        this.flush();
    }

    private void flushIfUnmanaged() {
        if (!this.managed) {
            this.flush();
        }
    }

    private void flushIfManaged() {
        if (this.managed) {
            this.flush();
        }
    }

    public int guiWidth() {
        return this.minecraft.method_22683().method_4486();
    }

    public int guiHeight() {
        return this.minecraft.method_22683().method_4502();
    }

    public class_4587 pose() {
        return this.pose;
    }

    public class_4597.class_4598 bufferSource() {
        return this.bufferSource;
    }

    public void flush() {
        RenderSystem.disableDepthTest();
        this.bufferSource.method_22993();
        RenderSystem.enableDepthTest();
    }

    public void hLine(int minX, int maxX, int y, int color) {
        this.hLine(GuiRenderTypes.gui(), minX, maxX, y, color);
    }

    public void hLine(class_1921 renderType, int minX, int maxX, int y, int color) {
        if (maxX < minX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        this.fill(renderType, minX, y, maxX + 1, y + 1, color);
    }

    public void vLine(int x, int minY, int maxY, int color) {
        this.vLine(GuiRenderTypes.gui(), x, minY, maxY, color);
    }

    public void vLine(class_1921 renderType, int x, int minY, int maxY, int color) {
        if (maxY < minY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }
        this.fill(renderType, x, minY + 1, x + 1, maxY, color);
    }

    public void enableScissor(int minX, int minY, int maxX, int maxY) {
        this.applyScissor(this.scissorStack.push(new ScreenRectangle(minX, minY, maxX - minX, maxY - minY)));
    }

    public void disableScissor() {
        this.applyScissor(this.scissorStack.pop());
    }

    private void applyScissor(@Nullable ScreenRectangle rectangle) {
        this.flushIfManaged();
        if (rectangle != null) {
            class_1041 window = class_310.method_1551().method_22683();
            int i = window.method_4506();
            double d = window.method_4495();
            double e = (double)rectangle.left() * d;
            double f = (double)i - (double)rectangle.bottom() * d;
            double g = (double)rectangle.width() * d;
            double h = (double)rectangle.height() * d;
            RenderSystem.enableScissor((int)((int)e), (int)((int)f), (int)Math.max(0, (int)g), (int)Math.max(0, (int)h));
        } else {
            RenderSystem.disableScissor();
        }
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfManaged();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(GuiRenderTypes.gui(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.fill(renderType, minX, minY, maxX, maxY, 0, color);
    }

    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        int i;
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        float f = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float j = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        class_4588 vertexConsumer = this.bufferSource.getBuffer(renderType);
        vertexConsumer.method_22918(matrix4F, (float)minX, (float)minY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)minX, (float)maxY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)maxX, (float)maxY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)maxX, (float)minY, (float)z).method_22915(g, h, j, f).method_1344();
        this.flushIfUnmanaged();
    }

    public void fillGradient(int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        this.fillGradient(x1, y1, x2, y2, 0, colorFrom, colorTo);
    }

    public void fillGradient(int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        this.fillGradient(GuiRenderTypes.gui(), x1, y1, x2, y2, colorFrom, colorTo, z);
    }

    public void fillGradient(class_1921 renderType, int x1, int y1, int x2, int y2, int colorFrom, int colorTo, int z) {
        class_4588 vertexConsumer = this.bufferSource.getBuffer(renderType);
        this.fillGradient(vertexConsumer, x1, y1, x2, y2, z, colorFrom, colorTo);
        this.flushIfUnmanaged();
    }

    private void fillGradient(class_4588 consumer, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        float f = (float)class_5253.class_5254.method_27762((int)colorFrom) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)colorFrom) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)colorFrom) / 255.0f;
        float i = (float)class_5253.class_5254.method_27767((int)colorFrom) / 255.0f;
        float j = (float)class_5253.class_5254.method_27762((int)colorTo) / 255.0f;
        float k = (float)class_5253.class_5254.method_27765((int)colorTo) / 255.0f;
        float l = (float)class_5253.class_5254.method_27766((int)colorTo) / 255.0f;
        float m = (float)class_5253.class_5254.method_27767((int)colorTo) / 255.0f;
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        consumer.method_22918(matrix4F, (float)x1, (float)y1, (float)z).method_22915(g, h, i, f).method_1344();
        consumer.method_22918(matrix4F, (float)x1, (float)y2, (float)z).method_22915(k, l, m, j).method_1344();
        consumer.method_22918(matrix4F, (float)x2, (float)y2, (float)z).method_22915(k, l, m, j).method_1344();
        consumer.method_22918(matrix4F, (float)x2, (float)y1, (float)z).method_22915(g, h, i, f).method_1344();
    }

    public void drawCenteredString(class_327 font, String text, int x, int y, int color) {
        this.drawString(font, text, x - font.method_1727(text) / 2, y, color);
    }

    public void drawCenteredString(class_327 font, class_2561 text, int x, int y, int color) {
        class_5481 formattedCharSequence = text.method_30937();
        this.drawString(font, formattedCharSequence, x - font.method_30880(formattedCharSequence) / 2, y, color);
    }

    public void drawCenteredString(class_327 font, class_5481 text, int x, int y, int color) {
        this.drawString(font, text, x - font.method_30880(text) / 2, y, color);
    }

    public int drawString(class_327 font, @Nullable String text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(class_327 font, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        boolean seeThrough = false;
        int i = font.method_27522(text, (float)x, (float)y, color, dropShadow, this.pose.method_23760().method_23761(), (class_4597)this.bufferSource, seeThrough, 0, 0xF000F0, font.method_1726());
        this.flushIfUnmanaged();
        return i;
    }

    public int drawString(class_327 font, class_5481 text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(class_327 font, class_5481 text, int x, int y, int color, boolean dropShadow) {
        boolean seeThrough = false;
        int i = font.method_22942(text, (float)x, (float)y, color, dropShadow, this.pose.method_23760().method_23761(), (class_4597)this.bufferSource, seeThrough, 0, 0xF000F0);
        this.flushIfUnmanaged();
        return i;
    }

    public int drawString(class_327 font, class_2561 text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    public int drawString(class_327 font, class_2561 text, int x, int y, int color, boolean dropShadow) {
        return this.drawString(font, text.method_30937(), x, y, color, dropShadow);
    }

    public void drawWordWrap(class_327 font, class_5348 text, int x, int y, int lineWidth, int color) {
        for (class_5481 formattedCharSequence : font.method_1728(text, lineWidth)) {
            this.drawString(font, formattedCharSequence, x, y, color, false);
            y += 9;
        }
    }

    public void blit(int x, int y, int blitOffset, int width, int height, class_1058 sprite) {
        this.innerBlit(sprite.method_4598(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    public void blit(int x, int y, int blitOffset, int width, int height, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.innerBlit(sprite.method_4598(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), red, green, blue, alpha);
    }

    public void renderOutline(int x, int y, int width, int height, int color) {
        this.fill(x, y, x + width, y + 1, color);
        this.fill(x, y + height - 1, x + width, y + height, color);
        this.fill(x, y + 1, x + 1, y + height - 1, color);
        this.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, 0, (float)uOffset, vOffset, uWidth, vHeight, 256, 256);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    void blit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    void innerBlit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34542);
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(matrix4F, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_1344();
        builder.method_22918(matrix4F, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_1344();
        builder.method_22918(matrix4F, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_1344();
        builder.method_22918(matrix4F, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_1344();
        builder.method_1326();
        class_286.method_1309((class_287)builder);
    }

    void innerBlit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.enableBlend();
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        builder.method_22918(matrix4F, (float)x1, (float)y1, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(minU, minV).method_1344();
        builder.method_22918(matrix4F, (float)x1, (float)y2, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(minU, maxV).method_1344();
        builder.method_22918(matrix4F, (float)x2, (float)y2, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(maxU, maxV).method_1344();
        builder.method_22918(matrix4F, (float)x2, (float)y1, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(maxU, minV).method_1344();
        builder.method_1326();
        class_286.method_1309((class_287)builder);
        RenderSystem.disableBlend();
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, m, m, m, n, o, p, q);
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, n, m, n, o, p, q, r);
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s, int t) {
        m = Math.min(m, k / 2);
        o = Math.min(o, k / 2);
        n = Math.min(n, l / 2);
        p = Math.min(p, l / 2);
        if (k == q && l == r) {
            this.blit(resourceLocation, i, j, s, t, k, l);
        } else if (l == r) {
            this.blit(resourceLocation, i, j, s, t, m, l);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, l, s + m, t, q - o - m, r);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, l);
        } else if (k == q) {
            this.blit(resourceLocation, i, j, s, t, k, n);
            this.blitRepeating(resourceLocation, i, j + n, k, l - p - n, s, t + n, q, r - p - n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, k, p);
        } else {
            this.blit(resourceLocation, i, j, s, t, m, n);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, n, s + m, t, q - o - m, n);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, m, p);
            this.blitRepeating(resourceLocation, i + m, j + l - p, k - o - m, p, s + m, t + r - p, q - o - m, p);
            this.blit(resourceLocation, i + k - o, j + l - p, s + q - o, t + r - p, o, p);
            this.blitRepeating(resourceLocation, i, j + n, m, l - p - n, s, t + n, m, r - p - n);
            this.blitRepeating(resourceLocation, i + m, j + n, k - o - m, l - p - n, s + m, t + n, q - o - m, r - p - n);
            this.blitRepeating(resourceLocation, i + k - o, j + n, m, l - p - n, s + q - o, t + n, o, r - p - n);
        }
    }

    public void blitRepeating(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p) {
        int q = i;
        IntIterator intIterator = GuiGraphics.slices(k, o);
        while (intIterator.hasNext()) {
            int r = intIterator.nextInt();
            int s = (o - r) / 2;
            int t = j;
            IntIterator intIterator2 = GuiGraphics.slices(l, p);
            while (intIterator2.hasNext()) {
                int u = intIterator2.nextInt();
                int v = (p - u) / 2;
                this.blit(resourceLocation, q, t, m + s, n + v, r, u);
                t += u;
            }
            q += r;
        }
    }

    private static IntIterator slices(int i, int j) {
        int k = class_3532.method_38788((int)i, (int)j);
        return new Divisor(i, k);
    }

    public void renderItem(class_1799 stack, int x, int y) {
        this.renderItem((class_1309)this.minecraft.field_1724, (class_1937)this.minecraft.field_1687, stack, x, y, 0);
    }

    public void renderItem(class_1799 stack, int x, int y, int seed) {
        this.renderItem((class_1309)this.minecraft.field_1724, (class_1937)this.minecraft.field_1687, stack, x, y, seed);
    }

    public void renderItem(class_1799 stack, int x, int y, int seed, int guiOffset) {
        this.renderItem((class_1309)this.minecraft.field_1724, (class_1937)this.minecraft.field_1687, stack, x, y, seed, guiOffset);
    }

    public void renderFakeItem(class_1799 stack, int x, int y) {
        this.renderItem(null, (class_1937)this.minecraft.field_1687, stack, x, y, 0);
    }

    public void renderItem(class_1309 entity, class_1799 stack, int x, int y, int seed) {
        this.renderItem(entity, entity.field_6002, stack, x, y, seed);
    }

    private void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed) {
        this.renderItem(entity, level, stack, x, y, seed, 0);
    }

    private void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed, int guiOffset) {
        if (!stack.method_7960()) {
            class_1087 bakedModel = this.minecraft.method_1480().method_4019(stack, level, entity, seed);
            this.pose.method_22903();
            this.pose.method_22904((double)(x + 8), (double)(y + 8), (double)(150 + (bakedModel.method_4712() ? guiOffset : 0)));
            try {
                boolean bl;
                this.pose.method_34425((class_1159)new GuiMatrix4f().scaling(1.0f, -1.0f, 1.0f));
                this.pose.method_22905(16.0f, 16.0f, 16.0f);
                boolean bl2 = bl = !bakedModel.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                this.minecraft.method_1480().method_23179(stack, class_809.class_811.field_4317, false, this.pose, (class_4597)this.bufferSource(), 0xF000F0, class_4608.field_21444, bakedModel);
                this.flush();
                if (bl) {
                    class_308.method_24211();
                }
            }
            catch (Throwable var12) {
                class_128 crashReport = class_128.method_560((Throwable)var12, (String)"Rendering item");
                class_129 crashReportCategory = crashReport.method_562("Item being rendered");
                crashReportCategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashReportCategory.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
                crashReportCategory.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
                crashReportCategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashReport);
            }
            this.pose.method_22909();
        }
    }

    public void renderItemDecorations(class_327 font, class_1799 stack, int x, int y) {
        this.renderItemDecorations(font, stack, x, y, null);
    }

    public void renderItemDecorations(class_327 font, class_1799 stack, int x, int y, @Nullable String text) {
        if (!stack.method_7960()) {
            class_746 localPlayer;
            float f;
            int l;
            int k;
            this.pose.method_22903();
            if (stack.method_7947() != 1 || text != null) {
                String string = text == null ? String.valueOf(stack.method_7947()) : text;
                this.pose.method_22904(0.0, 0.0, 200.0);
                this.drawString(font, string, x + 19 - 2 - font.method_1727(string), y + 6 + 3, 0xFFFFFF, true);
            }
            if (stack.method_31578()) {
                int i = stack.method_31579();
                int j = stack.method_31580();
                k = x + 2;
                l = y + 13;
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + 13, l + 2, -16777216);
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + i, l + 1, j | 0xFF000000);
            }
            float f2 = f = (localPlayer = this.minecraft.field_1724) == null ? 0.0f : localPlayer.method_7357().method_7905(stack.method_7909(), this.minecraft.method_1488());
            if (f > 0.0f) {
                k = y + class_3532.method_15375((float)(16.0f * (1.0f - f)));
                l = k + class_3532.method_15386((float)(16.0f * f));
                this.fill(GuiRenderTypes.guiOverlay(), x, k, x + 16, l, Integer.MAX_VALUE);
            }
            this.pose.method_22909();
        }
    }

    public void renderTooltip(class_327 font, class_1799 stack, int mouseX, int mouseY) {
        this.renderTooltip(font, DUMMY_SCREEN.method_25408(stack), stack.method_32347(), mouseX, mouseY);
    }

    public void renderTooltip(class_327 font, List<class_2561> tooltipLines, Optional<class_5632> visualTooltipComponent, int mouseX, int mouseY) {
        List<class_5684> list = tooltipLines.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        visualTooltipComponent.ifPresent(tooltipComponent -> list.add(1, class_5684.method_32663((class_5632)tooltipComponent)));
        this.renderTooltipInternal(font, list, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(class_327 font, class_2561 text, int mouseX, int mouseY) {
        this.renderTooltip(font, List.of(text.method_30937()), mouseX, mouseY);
    }

    public void renderComponentTooltip(class_327 font, List<class_2561> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltip(font, Lists.transform(tooltipLines, class_2561::method_30937), mouseX, mouseY);
    }

    public void renderTooltip(class_327 font, List<? extends class_5481> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltipInternal(font, tooltipLines.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    public void renderTooltip(class_327 font, List<class_5481> tooltipLines, ClientTooltipPositioner tooltipPositioner, int mouseX, int mouseY) {
        this.renderTooltipInternal(font, tooltipLines.stream().map(class_5684::method_32662).collect(Collectors.toList()), mouseX, mouseY, tooltipPositioner);
    }

    private void renderTooltipInternal(class_327 font, List<class_5684> components, int mouseX, int mouseY, ClientTooltipPositioner tooltipPositioner) {
        if (!components.isEmpty()) {
            class_5684 clientTooltipComponent2;
            int r;
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;
            for (class_5684 clientTooltipComponent : components) {
                int k = clientTooltipComponent.method_32664(font);
                if (k > i) {
                    i = k;
                }
                j += clientTooltipComponent.method_32661();
            }
            int l = i;
            int m = j;
            Vector2ic vector2ic = tooltipPositioner.positionTooltip(this.guiWidth(), this.guiHeight(), mouseX, mouseY, l, m);
            int n = vector2ic.x();
            int o = vector2ic.y();
            this.pose.method_22903();
            int p = 400;
            this.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground(this, n, o, l, m, 400));
            this.pose.method_22904(0.0, 0.0, 400.0);
            int q = o;
            for (r = 0; r < components.size(); ++r) {
                clientTooltipComponent2 = components.get(r);
                clientTooltipComponent2.method_32665(font, n, q, this.pose.method_23760().method_23761(), this.bufferSource);
                q += clientTooltipComponent2.method_32661() + (r == 0 ? 2 : 0);
            }
            q = o;
            for (r = 0; r < components.size(); ++r) {
                clientTooltipComponent2 = components.get(r);
                clientTooltipComponent2.method_32666(font, n, q, this.pose, class_310.method_1551().method_1480(), 400);
                q += clientTooltipComponent2.method_32661() + (r == 0 ? 2 : 0);
            }
            this.pose.method_22909();
        }
    }

    public void renderComponentHoverEffect(class_327 font, @Nullable class_2583 style, int mouseX, int mouseY) {
        if (style != null && style.method_10969() != null) {
            class_2568 hoverEvent = style.method_10969();
            class_2568.class_5249 itemStackInfo = (class_2568.class_5249)hoverEvent.method_10891(class_2568.class_5247.field_24343);
            if (itemStackInfo != null) {
                this.renderTooltip(font, itemStackInfo.method_27683(), mouseX, mouseY);
            } else {
                class_2568.class_5248 entityTooltipInfo = (class_2568.class_5248)hoverEvent.method_10891(class_2568.class_5247.field_24344);
                if (entityTooltipInfo != null) {
                    if (this.minecraft.field_1690.field_1827) {
                        this.renderComponentTooltip(font, entityTooltipInfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = (class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        this.renderTooltip(font, font.method_1728((class_5348)component, Math.max(this.guiWidth() / 2, 200)), mouseX, mouseY);
                    }
                }
            }
        }
    }

    public static class ScissorStack {
        private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

        public ScreenRectangle push(ScreenRectangle scissor) {
            ScreenRectangle screenRectangle = this.stack.peekLast();
            if (screenRectangle != null) {
                ScreenRectangle screenRectangle2 = Objects.requireNonNullElse(scissor.intersection(screenRectangle), ScreenRectangle.empty());
                this.stack.addLast(screenRectangle2);
                return screenRectangle2;
            }
            this.stack.addLast(scissor);
            return scissor;
        }

        @Nullable
        public ScreenRectangle pop() {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Scissor stack underflow");
            }
            this.stack.removeLast();
            return this.stack.peekLast();
        }
    }
}

