/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.MatrixUtils;
import de.keksuccino.fancymenu.util.rendering.gui.ScreenRectangle;
import java.awt.Color;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = new class_2960("fancymenu", "textures/fully_transparent.png");

    public static void renderMissing(@NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.fill(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.fill(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.fill(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.fill(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void blitMirrored(@NotNull GuiGraphics graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, -1);
    }

    public static void blitMirrored(@NotNull GuiGraphics graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight, int colorTint) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, colorTint);
    }

    public static void blitMirroredScaled(@NotNull GuiGraphics graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int renderWidth, int renderHeight, int textureWidth, int textureHeight, int color) {
        float minU = (float)u / (float)textureWidth;
        float maxU = (float)(u + spriteWidth) / (float)textureWidth;
        float minV = (float)v / (float)textureHeight;
        float maxV = (float)(v + spriteHeight) / (float)textureHeight;
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        class_1159 matrix4f = graphics.pose().method_23760().method_23761();
        class_287 consumer = class_289.method_1348().method_1349();
        consumer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        consumer.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(maxU, minV).method_39415(color);
        consumer.method_22918(matrix4f, (float)x, (float)(y + renderHeight), 0.0f).method_22913(maxU, maxV).method_39415(color);
        consumer.method_22918(matrix4f, (float)(x + renderWidth), (float)(y + renderHeight), 0.0f).method_22913(minU, maxV).method_39415(color);
        consumer.method_22918(matrix4f, (float)(x + renderWidth), (float)y, 0.0f).method_22913(minU, minV).method_39415(color);
        class_286.method_1309((class_287)consumer);
        RenderSystem.disableBlend();
    }

    public static void blitRepeat(@NotNull GuiGraphics graphics, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        graphics.blit(location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight);
    }

    public static void blitNineSlicedTexture(GuiGraphics graphics, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        graphics.blit(texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight);
        graphics.blit(texture, x + width - borderRight, y, textureWidth - borderRight, 0.0f, borderRight, borderTop, textureWidth, textureHeight);
        graphics.blit(texture, x, y + height - borderBottom, 0.0f, textureHeight - borderBottom, borderLeft, borderBottom, textureWidth, textureHeight);
        graphics.blit(texture, x + width - borderRight, y + height - borderBottom, textureWidth - borderRight, textureHeight - borderBottom, borderRight, borderBottom, textureWidth, textureHeight);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.blit(texture, x + i, y, borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.blit(texture, x + i, y + height - borderBottom, borderLeft, textureHeight - borderBottom, pieceWidth, borderBottom, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.blit(texture, x, y + j, 0.0f, borderTop, borderLeft, pieceHeight, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.blit(texture, x + width - borderRight, y + j, textureWidth - borderRight, borderTop, borderRight, pieceHeight, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.blit(texture, x + i, y + j2, borderLeft, borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight);
            }
        }
    }

    public static float getPartialTick() {
        return class_310.method_1551().method_1493() ? ((IMixinMinecraft)class_310.method_1551()).getPausePartialTickFancyMenu() : class_310.method_1551().method_1488();
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997((double)m.method_4476(class_310.method_1551().field_1690.field_1868, class_310.method_1551().field_1690.field_1819));
    }

    public static void resetShaderColor(GuiGraphics graphics) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(graphics, color, a);
    }

    public static void setShaderColor(GuiGraphics graphics, DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        graphics.setColor(r, g, b, alpha);
    }

    public static void setShaderColor(GuiGraphics graphics, int color, float alpha) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        graphics.setColor(red, green, blue, alpha);
    }

    public static void setShaderColor(GuiGraphics graphics, int color) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        graphics.setColor(red, green, blue, alpha);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull GuiGraphics graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        class_1159 matrix4f = graphics.pose().method_23760().method_23761();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        class_287 builder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(matrix4f, minX, minY, z).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix4f, minX, maxY, z).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix4f, maxX, maxY, z).method_22915(red, green, blue, alpha).method_1344();
        builder.method_22918(matrix4f, maxX, minY, z).method_22915(red, green, blue, alpha).method_1344();
        builder.method_1326();
        class_286.method_1309((class_287)builder);
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull GuiGraphics graphics, class_2960 location, float x, float y, float f3, float f4, float width, float height, float width2, float height2, int color) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        graphics.setColor(red, green, blue, alpha);
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void blitF(@NotNull GuiGraphics graphics, class_2960 location, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(GuiGraphics $$0, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, location, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(GuiGraphics graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit(graphics, location, $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(GuiGraphics graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShader(class_757::method_34542);
        class_1159 $$10 = graphics.pose().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918($$10, $$1, $$3, $$5).method_22913($$6, $$8).method_1344();
        builder.method_22918($$10, $$1, $$4, $$5).method_22913($$6, $$9).method_1344();
        builder.method_22918($$10, $$2, $$4, $$5).method_22913($$7, $$9).method_1344();
        builder.method_22918($$10, $$2, $$3, $$5).method_22913($$7, $$8).method_1344();
        builder.method_1326();
        class_286.method_1309((class_287)builder);
    }

    public static void enableScissor(@NotNull GuiGraphics graphics, int minX, int minY, int maxX, int maxY) {
        ScreenRectangle r = new ScreenRectangle(minX, minY, maxX - minX, maxY - minY);
        r = RenderingUtils.transformAxisAligned(r, graphics.pose().method_23760().method_23761());
        graphics.enableScissor(r.left(), r.top(), r.right(), r.bottom());
    }

    public static void disableScissor(@NotNull GuiGraphics graphics) {
        graphics.disableScissor();
    }

    @NotNull
    public static ScreenRectangle transformAxisAligned(@NotNull ScreenRectangle toTransform, @NotNull class_1159 pose) {
        if (RenderingUtils.isMatrixIdentity(pose)) {
            return toTransform;
        }
        Matrix4f jomlPose = MatrixUtils.convertToJoml(pose);
        Vector3f vector3f = jomlPose.transformPosition((float)toTransform.left(), (float)toTransform.top(), 0.0f, new Vector3f());
        Vector3f vector3f2 = jomlPose.transformPosition((float)toTransform.right(), (float)toTransform.bottom(), 0.0f, new Vector3f());
        return new ScreenRectangle(class_3532.method_15375((float)vector3f.x), class_3532.method_15375((float)vector3f.y), class_3532.method_15375((float)(vector3f2.x - vector3f.x)), class_3532.method_15375((float)(vector3f2.y - vector3f.y)));
    }

    public static boolean isMatrixIdentity(class_1159 matrix) {
        return MatrixUtils.isMatrixIdentityMojang(matrix);
    }
}

