/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableColor {
    public static final DrawableColor EMPTY = DrawableColor.of(new Color(255, 255, 255));
    public static final DrawableColor WHITE = DrawableColor.of(new Color(255, 255, 255));
    public static final DrawableColor BLACK = DrawableColor.of(new Color(0, 0, 0));
    protected Color color;
    protected int colorInt;
    protected String hex;
    protected FloatColor floatColor;

    @NotNull
    public static DrawableColor of(int color) {
        DrawableColor c = new DrawableColor();
        c.color = new Color(color);
        c.colorInt = color;
        c.hex = DrawableColor.convertColorToHexString(c.color);
        if (c.hex == null) {
            c.hex = "#ffffffff";
        }
        return c;
    }

    @NotNull
    public static DrawableColor of(@NotNull Color color) {
        Objects.requireNonNull(color);
        DrawableColor c = new DrawableColor();
        c.color = color;
        c.colorInt = color.getRGB();
        c.hex = DrawableColor.convertColorToHexString(color);
        if (c.hex == null) {
            c.hex = "#ffffffff";
        }
        return c;
    }

    @NotNull
    public static DrawableColor of(@NotNull String hex) {
        Objects.requireNonNull(hex);
        hex = ((String)hex).replace(" ", "");
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        DrawableColor c = new DrawableColor();
        c.color = DrawableColor.convertHexStringToColor((String)hex);
        if (c.color == null) {
            return EMPTY;
        }
        c.colorInt = c.color.getRGB();
        c.hex = hex;
        return c;
    }

    @NotNull
    public static DrawableColor of(int r, int g, int b) {
        return DrawableColor.of(r, g, b, 255);
    }

    @NotNull
    public static DrawableColor of(int r, int g, int b, int a) {
        DrawableColor c = new DrawableColor();
        try {
            c.color = new Color(r, g, b, a);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return EMPTY;
        }
        c.colorInt = c.color.getRGB();
        c.hex = DrawableColor.convertColorToHexString(c.color);
        if (c.hex != null) {
            return c;
        }
        return EMPTY;
    }

    protected DrawableColor() {
    }

    public void setAsShaderColor(@NotNull GuiGraphics graphics, float alpha) {
        FloatColor c = this.getAsFloats();
        graphics.setColor(c.red(), c.green(), c.blue(), alpha);
    }

    public void setAsShaderColor(@NotNull GuiGraphics graphics) {
        FloatColor c = this.getAsFloats();
        graphics.setColor(c.red(), c.green(), c.blue(), c.alpha());
    }

    public void resetShaderColor(@NotNull GuiGraphics graphics) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @NotNull
    public FloatColor getAsFloats() {
        if (this.floatColor == null) {
            float[] floats = DrawableColor.argbToFloats(this.getColorInt());
            this.floatColor = new FloatColor(floats[0], floats[1], floats[2], floats[3]);
        }
        return this.floatColor;
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public int getColorInt() {
        return this.colorInt;
    }

    public int getColorIntWithAlpha(float alpha) {
        return RenderingUtils.replaceAlphaInColor(this.colorInt, alpha);
    }

    @NotNull
    public String getHex() {
        if (this.hex == null) {
            return "#ffffffff";
        }
        return this.hex;
    }

    public DrawableColor copy() {
        DrawableColor c = new DrawableColor();
        c.color = this.color;
        c.colorInt = this.colorInt;
        c.hex = this.hex;
        return c;
    }

    @Nullable
    protected static Color convertHexStringToColor(@NotNull String hex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (hex.length() == 8) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    protected static String convertColorToHexString(@NotNull Color color) {
        try {
            return String.format("#%02X%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static float[] argbToFloats(int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public record FloatColor(float red, float green, float blue, float alpha) {
    }
}

