/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.minecraftoptions;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.minecraftoptions.MinecraftOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1157;
import net.minecraft.class_1267;
import net.minecraft.class_1306;
import net.minecraft.class_1659;
import net.minecraft.class_1664;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_4060;
import net.minecraft.class_4061;
import net.minecraft.class_4063;
import net.minecraft.class_4065;
import net.minecraft.class_4066;
import net.minecraft.class_5365;
import net.minecraft.class_6597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftOptions {
    private static final TypeToken<List<String>> RESOURCE_PACK_TYPE = new TypeToken<List<String>>(){};
    private static final Gson GSON = new Gson();
    private static final Map<String, MinecraftOption> CACHED_OPTIONS = new LinkedHashMap<String, MinecraftOption>();

    @NotNull
    public static Map<String, MinecraftOption> getOptions() {
        MinecraftOptions.cacheOptions();
        return CACHED_OPTIONS;
    }

    @Nullable
    public static MinecraftOption getOption(@NotNull String name) {
        return MinecraftOptions.getOptions().get(name);
    }

    public static void save() {
        class_310.method_1551().field_1690.method_1640();
    }

    private static void cacheOptions() {
        if (CACHED_OPTIONS.isEmpty()) {
            try {
                MinecraftOption option;
                class_315 options = class_310.method_1551().field_1690;
                MinecraftOptions.cachePrimitive(Boolean.class, "autoJump", () -> options.field_1848, aBoolean -> {
                    options.field_1848 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "autoSuggestions", () -> options.field_1873, aBoolean -> {
                    options.field_1873 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "chatColors", () -> options.field_1900, aBoolean -> {
                    options.field_1900 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "chatLinks", () -> options.field_1911, aBoolean -> {
                    options.field_1911 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "chatLinksPrompt", () -> options.field_1817, aBoolean -> {
                    options.field_1817 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "enableVsync", () -> options.field_1884, aBoolean -> {
                    options.field_1884 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "entityShadows", () -> options.field_1888, aBoolean -> {
                    options.field_1888 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "forceUnicodeFont", () -> options.field_1819, aBoolean -> {
                    options.field_1819 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "discrete_mouse_scroll", () -> options.field_19244, aBoolean -> {
                    options.field_19244 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "invertYMouse", () -> options.field_1865, aBoolean -> {
                    options.field_1865 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "realmsNotifications", () -> options.field_1830, aBoolean -> {
                    options.field_1830 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "reducedDebugInfo", () -> options.field_1910, aBoolean -> {
                    options.field_1910 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "showSubtitles", () -> options.field_1818, aBoolean -> {
                    options.field_1818 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "touchscreen", () -> options.field_1854, aBoolean -> {
                    options.field_1854 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "fullscreen", () -> options.field_1857, aBoolean -> {
                    options.field_1857 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "bobView", () -> options.field_1891, aBoolean -> {
                    options.field_1891 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "toggleCrouch", () -> options.field_21332, aBoolean -> {
                    options.field_21332 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "toggleSprint", () -> options.field_21333, aBoolean -> {
                    options.field_21333 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "darkMojangStudiosBackground", () -> options.field_32156, aBoolean -> {
                    options.field_32156 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "hideLightningFlashes", () -> options.field_34786, value -> {
                    options.field_34786 = value;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "backgroundForChatOnly", () -> options.field_18725, aBoolean -> {
                    options.field_18725 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "hideServerAddress", () -> options.field_1815, aBoolean -> {
                    options.field_1815 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "advancedItemTooltips", () -> options.field_1827, aBoolean -> {
                    options.field_1827 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "pauseOnLostFocus", () -> options.field_1837, aBoolean -> {
                    options.field_1837 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "heldItemTooltips", () -> options.field_1905, aBoolean -> {
                    options.field_1905 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "useNativeTransport", () -> options.field_1876, aBoolean -> {
                    options.field_1876 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "rawMouseInput", () -> options.field_20308, aBoolean -> {
                    options.field_20308 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "skipMultiplayerWarning", () -> options.field_21840, aBoolean -> {
                    options.field_21840 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "skipRealms32bitWarning", () -> options.field_37208, aBoolean -> {
                    options.field_37208 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "hideMatchedNames", () -> options.field_26926, aBoolean -> {
                    options.field_26926 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "joinedFirstServer", () -> options.field_26844, aBoolean -> {
                    options.field_26844 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "hideBundleTutorial", () -> options.field_28777, aBoolean -> {
                    options.field_28777 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "syncChunkWrites", () -> options.field_25623, aBoolean -> {
                    options.field_25623 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "showAutosaveIndicator", () -> options.field_35426, aBoolean -> {
                    options.field_35426 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Boolean.class, "allowServerListing", () -> options.field_35637, aBoolean -> {
                    options.field_35637 = aBoolean;
                });
                MinecraftOptions.cachePrimitive(Double.class, "mouseSensitivity", () -> options.field_1843, value -> {
                    options.field_1843 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "fov", () -> options.field_1826, value -> {
                    options.field_1826 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "gamma", () -> options.field_1840, value -> {
                    options.field_1840 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatOpacity", () -> options.field_1820, value -> {
                    options.field_1820 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatLineSpacing", () -> options.field_23932, value -> {
                    options.field_23932 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "textBackgroundOpacity", () -> options.field_18726, value -> {
                    options.field_18726 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatHeightFocused", () -> options.field_1838, value -> {
                    options.field_1838 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatHeightUnfocused", () -> options.field_1825, value -> {
                    options.field_1825 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatDelay", () -> options.field_23933, value -> {
                    options.field_23933 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatScale", () -> options.field_1908, value -> {
                    options.field_1908 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "chatWidth", () -> options.field_1915, value -> {
                    options.field_1915 = value;
                });
                MinecraftOptions.cachePrimitive(Double.class, "mouseWheelSensitivity", () -> options.field_1889, value -> {
                    options.field_1889 = value;
                });
                MinecraftOptions.cachePrimitive(Float.class, "screenEffectScale", () -> Float.valueOf(options.field_26675), value -> {
                    options.field_26675 = value.floatValue();
                });
                MinecraftOptions.cachePrimitive(Float.class, "fovEffectScale", () -> Float.valueOf(options.field_26676), value -> {
                    options.field_26676 = value.floatValue();
                });
                MinecraftOptions.cachePrimitive(Float.class, "entityDistanceScaling", () -> Float.valueOf(options.field_24214), value -> {
                    options.field_24214 = value.floatValue();
                });
                MinecraftOptions.cachePrimitive(Integer.class, "renderDistance", () -> options.field_1870, value -> {
                    options.field_1870 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "simulationDistance", () -> options.field_34959, value -> {
                    options.field_34959 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "guiScale", () -> options.field_1868, value -> {
                    options.field_1868 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "maxFps", () -> options.field_1909, value -> {
                    options.field_1909 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "biomeBlendRadius", () -> options.field_1878, value -> {
                    options.field_1878 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "overrideWidth", () -> options.field_1872, value -> {
                    options.field_1872 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "overrideHeight", () -> options.field_1885, value -> {
                    options.field_1885 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "mipmapLevels", () -> options.field_1856, value -> {
                    options.field_1856 = value;
                });
                MinecraftOptions.cachePrimitive(Integer.class, "glDebugVerbosity", () -> options.field_1901, value -> {
                    options.field_1901 = value;
                });
                MinecraftOptions.cachePrimitive(String.class, "lastServer", () -> options.field_1864, value -> {
                    options.field_1864 = value;
                });
                MinecraftOptions.cachePrimitive(String.class, "lang", () -> options.field_1883, value -> {
                    options.field_1883 = value;
                });
                MinecraftOptions.cachePrimitive(String.class, "soundDevice", () -> options.field_34783, value -> {
                    options.field_34783 = value;
                });
                MinecraftOptions.cacheIntBased(class_4066.class, "particles", () -> options.field_1882, value -> {
                    options.field_1882 = value;
                }, class_4066::method_18608, class_4066::method_18609);
                MinecraftOptions.cacheIntBased(class_1267.class, "difficulty", () -> options.field_1851, value -> {
                    options.field_1851 = value;
                }, class_1267::method_5462, class_1267::method_5461);
                MinecraftOptions.cacheIntBased(class_5365.class, "graphicsMode", () -> options.field_25444, value -> {
                    options.field_25444 = value;
                }, class_5365::method_29592, class_5365::method_29591);
                MinecraftOptions.cacheIntBased(class_6597.class, "prioritizeChunkUpdates", () -> options.field_34787, value -> {
                    options.field_34787 = value;
                }, class_6597::method_38523, class_6597::method_38522);
                MinecraftOptions.cacheIntBased(class_1659.class, "chatVisibility", () -> options.field_1877, value -> {
                    options.field_1877 = value;
                }, class_1659::method_7360, class_1659::method_7362);
                MinecraftOptions.cacheIntBased(class_4061.class, "attackIndicator", () -> options.field_1895, value -> {
                    options.field_1895 = value;
                }, class_4061::method_18488, class_4061::method_18487);
                MinecraftOptions.cacheIntBased(class_4065.class, "narrator", () -> options.field_1896, value -> {
                    options.field_1896 = value;
                }, class_4065::method_18510, class_4065::method_18509);
                MinecraftOptions.cache(class_4060.class, "ao", () -> options.field_1841, value -> {
                    options.field_1841 = value;
                }, MinecraftOptions::readAmbientOcclusion, value -> Integer.toString(value.method_18483()));
                MinecraftOptions.cache(class_4063.class, "renderClouds", () -> options.field_1814, value -> {
                    options.field_1814 = value;
                }, MinecraftOptions::readCloudStatus, MinecraftOptions::writeCloudStatus);
                MinecraftOptions.cache(List.class, "resourcePacks", () -> options.field_1887, list -> {
                    options.field_1887 = list;
                }, MinecraftOptions::readPackList, arg_0 -> ((Gson)GSON).toJson(arg_0));
                MinecraftOptions.cache(List.class, "incompatibleResourcePacks", () -> options.field_1846, list -> {
                    options.field_1846 = list;
                }, MinecraftOptions::readPackList, arg_0 -> ((Gson)GSON).toJson(arg_0));
                MinecraftOptions.cache(class_1306.class, "mainHand", () -> options.field_1829, value -> {
                    options.field_1829 = value;
                }, MinecraftOptions::readMainHand, MinecraftOptions::writeMainHand);
                MinecraftOptions.cache(class_1157.class, "tutorialStep", () -> options.field_1875, value -> {
                    options.field_1875 = value;
                }, class_1157::method_4919, class_1157::method_4920);
                for (class_304 class_3042 : class_310.method_1551().field_1690.field_1839) {
                    option = MinecraftOption.of(class_3042);
                    CACHED_OPTIONS.put(option.name, option);
                }
                for (class_304 class_3043 : class_3419.values()) {
                    MinecraftOptions.cachePrimitive(Float.class, "soundCategory_" + class_3043.method_14840(), () -> MinecraftOptions.lambda$cacheOptions$151(options, (class_3419)class_3043), arg_0 -> MinecraftOptions.lambda$cacheOptions$152(options, (class_3419)class_3043, arg_0));
                }
                for (class_304 class_3044 : class_1664.values()) {
                    option = MinecraftOption.of((class_1664)class_3044);
                    CACHED_OPTIONS.put(option.name, option);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static <T> void cache(@NotNull Class<T> type, @NotNull String name, @NotNull Supplier<T> getter, @NotNull Consumer<T> setter, @NotNull Function<String, T> fromString, @NotNull Function<T, String> toString) {
        CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Object>(name, getter, setter, new MinecraftOption.OptionCodec<Object>(toString::apply, fromString::apply))));
    }

    private static <T> void cacheIntBased(@NotNull Class<T> type, @NotNull String name, @NotNull Supplier<T> getter, @NotNull Consumer<T> setter, @NotNull IntFunction<T> fromInt, @NotNull ToIntFunction<T> toInt) {
        MinecraftOptions.cache(type, name, getter, setter, s -> {
            if (MathUtils.isInteger((String)s)) {
                return fromInt.apply(Integer.parseInt(s));
            }
            return null;
        }, t -> "" + toInt.applyAsInt(t));
    }

    private static <T> void cachePrimitive(@NotNull Class<T> type, @NotNull String name, @NotNull Supplier<T> getter, @NotNull Consumer<T> setter) {
        if (type == Integer.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Integer>(name, getter, setter, MinecraftOption.OptionCodec.INTEGER_CODEC)));
        } else if (type == Long.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Long>(name, getter, setter, MinecraftOption.OptionCodec.LONG_CODEC)));
        } else if (type == Double.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Double>(name, getter, setter, MinecraftOption.OptionCodec.DOUBLE_CODEC)));
        } else if (type == Float.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Float>(name, getter, setter, MinecraftOption.OptionCodec.FLOAT_CODEC)));
        } else if (type == Boolean.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<Boolean>(name, getter, setter, MinecraftOption.OptionCodec.BOOLEAN_CODEC)));
        } else if (type == String.class) {
            CACHED_OPTIONS.put(name, MinecraftOption.of(name, new MinecraftOption.OptionInstance<String>(name, getter, setter, MinecraftOption.OptionCodec.STRING_CODEC)));
        }
    }

    private static List<String> readPackList(String serialized) {
        List packList = (List)class_3518.method_15290((Gson)GSON, (String)serialized, RESOURCE_PACK_TYPE);
        return packList != null ? packList : Lists.newArrayList();
    }

    private static class_4063 readCloudStatus(String serialized) {
        switch (serialized) {
            case "true": {
                return class_4063.field_18164;
            }
            case "fast": {
                return class_4063.field_18163;
            }
        }
        return class_4063.field_18162;
    }

    private static String writeCloudStatus(class_4063 cloudStatus) {
        switch (cloudStatus) {
            case field_18164: {
                return "true";
            }
            case field_18163: {
                return "fast";
            }
        }
        return "false";
    }

    private static class_4060 readAmbientOcclusion(String serialized) {
        if (MinecraftOptions.isTrue(serialized)) {
            return class_4060.field_18146;
        }
        return MinecraftOptions.isFalse(serialized) ? class_4060.field_18144 : class_4060.method_18484((int)Integer.parseInt(serialized));
    }

    private static class_1306 readMainHand(String serialized) {
        return "left".equals(serialized) ? class_1306.field_6182 : class_1306.field_6183;
    }

    private static String writeMainHand(class_1306 mainHand) {
        return mainHand == class_1306.field_6182 ? "left" : "right";
    }

    static boolean isTrue(String serialized) {
        return "true".equals(serialized);
    }

    static boolean isFalse(String serialized) {
        return "false".equals(serialized);
    }

    private static /* synthetic */ void lambda$cacheOptions$152(class_315 options, class_3419 source, Float aFloat) {
        options.method_1624(source, aFloat.floatValue());
    }

    private static /* synthetic */ Float lambda$cacheOptions$151(class_315 options, class_3419 source) {
        return Float.valueOf(options.method_1630(source));
    }
}

