/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.minecraftoptions;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinOptions;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.MathUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1664;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftOption {
    protected String name;
    protected OptionInstance<Object> optionInstance;
    protected class_304 keyMapping;
    protected class_1664 modelPart;

    @NotNull
    public static MinecraftOption of(@NotNull String name, @NotNull OptionInstance<?> optionInstance) {
        MinecraftOption option = new MinecraftOption();
        option.optionInstance = optionInstance;
        option.name = name;
        return option;
    }

    @NotNull
    public static MinecraftOption of(@NotNull class_304 keyMapping) {
        MinecraftOption option = new MinecraftOption();
        option.name = "key_" + keyMapping.method_1431();
        option.keyMapping = keyMapping;
        return option;
    }

    @NotNull
    public static MinecraftOption of(@NotNull class_1664 modelPart) {
        MinecraftOption option = new MinecraftOption();
        option.name = "modelPart_" + modelPart.method_7429();
        option.modelPart = modelPart;
        return option;
    }

    protected MinecraftOption() {
    }

    @Nullable
    public String get() {
        try {
            if (this.optionInstance != null) {
                return this.optionInstance.get();
            }
            if (this.keyMapping != null) {
                return this.keyMapping.method_1428();
            }
            if (this.modelPart != null) {
                return "" + ((IMixinOptions)class_310.method_1551().field_1690).getModelPartsFancyMenu().contains(this.modelPart);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void set(@NotNull String value) {
        try {
            if (this.optionInstance != null) {
                this.optionInstance.set(value);
            } else if (this.keyMapping != null) {
                this.keyMapping.method_1422(class_3675.method_15981((String)value));
            } else if (this.modelPart != null) {
                Set<class_1664> parts = ((IMixinOptions)class_310.method_1551().field_1690).getModelPartsFancyMenu();
                if (value.equalsIgnoreCase("true") && !parts.contains(this.modelPart)) {
                    parts.add(this.modelPart);
                } else if (value.equalsIgnoreCase("false")) {
                    parts.remove(this.modelPart);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        class_310.method_1551().field_1690.method_1640();
    }

    @Nullable
    public OptionInstance<Object> getOptionInstance() {
        return this.optionInstance;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public static class OptionInstance<T> {
        protected final String name;
        protected final Consumer<T> setter;
        protected final Supplier<T> getter;
        protected final OptionCodec<T> codec;

        public OptionInstance(@NotNull String name, @NotNull Supplier<T> getter, @NotNull Consumer<T> setter, @NotNull OptionCodec<T> codec) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.codec = codec;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public void set(@NotNull String value) {
            Object t = this.codec.write.get(Objects.requireNonNull(value));
            if (t != null) {
                this.setter.accept(t);
            }
        }

        @Nullable
        public String get() {
            T t = this.getter.get();
            if (t != null) {
                return this.codec.read.get(t);
            }
            return null;
        }
    }

    public record OptionCodec<T>(@NotNull ConsumingSupplier<T, String> read, @NotNull ConsumingSupplier<String, T> write) {
        public static final OptionCodec<String> STRING_CODEC = new OptionCodec<String>(consumes -> consumes, consumes -> consumes);
        public static final OptionCodec<Integer> INTEGER_CODEC = new OptionCodec<Integer>(Object::toString, consumes -> MathUtils.isInteger((String)consumes) ? Integer.valueOf(Integer.parseInt(consumes)) : null);
        public static final OptionCodec<Long> LONG_CODEC = new OptionCodec<Long>(Object::toString, consumes -> MathUtils.isLong((String)consumes) ? Long.valueOf(Long.parseLong(consumes)) : null);
        public static final OptionCodec<Double> DOUBLE_CODEC = new OptionCodec<Double>(Object::toString, consumes -> MathUtils.isDouble((String)consumes) ? Double.valueOf(Double.parseDouble(consumes)) : null);
        public static final OptionCodec<Float> FLOAT_CODEC = new OptionCodec<Float>(Object::toString, consumes -> MathUtils.isFloat((String)consumes) ? Float.valueOf(Float.parseFloat(consumes)) : null);
        public static final OptionCodec<Boolean> BOOLEAN_CODEC = new OptionCodec<Boolean>(consumes -> consumes != false ? "true" : "false", "true"::equalsIgnoreCase);
    }
}

