/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.file.type;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.resource.MinecraftResourceUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileCodec<T> {
    @NotNull
    public static <T> FileCodec<T> empty(@NotNull Class<T> type) {
        return new FileCodec<T>(){

            @Override
            @Nullable
            public T read(@NotNull InputStream in) {
                return null;
            }

            @Override
            @Nullable
            public T readLocation(@NotNull class_2960 location) {
                return null;
            }

            @Override
            @Nullable
            public T readLocal(@NotNull File file) {
                return null;
            }

            @Override
            @Nullable
            public T readWeb(@NotNull String fileUrl) {
                return null;
            }
        };
    }

    @NotNull
    public static <T> FileCodec<T> generic(@NotNull Class<T> type, @NotNull ConsumingSupplier<InputStream, T> streamReader) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(streamReader);
        ConsumingSupplier<class_2960, Object> locationReader = consumes -> {
            try {
                InputStream in = MinecraftResourceUtils.open(consumes);
                return streamReader.get(in);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        };
        return FileCodec.basic(type, streamReader, locationReader);
    }

    @NotNull
    public static <T> FileCodec<T> basic(@NotNull Class<T> type, final @NotNull ConsumingSupplier<InputStream, T> streamReader, final @NotNull ConsumingSupplier<class_2960, T> locationReader) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(streamReader);
        return new FileCodec<T>(){

            @Override
            @Nullable
            public T read(@NotNull InputStream in) {
                Objects.requireNonNull(in);
                return streamReader.get(in);
            }

            @Override
            @Nullable
            public T readLocation(@NotNull class_2960 location) {
                Objects.requireNonNull(location);
                return locationReader.get(location);
            }

            @Override
            @Nullable
            public T readLocal(@NotNull File file) {
                Objects.requireNonNull(file);
                try {
                    return streamReader.get(new FileInputStream(file));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            @Override
            @Nullable
            public T readWeb(@NotNull String fileUrl) {
                Objects.requireNonNull(fileUrl);
                InputStream in = WebUtils.openResourceStream(fileUrl);
                if (in != null) {
                    return streamReader.get(in);
                }
                return null;
            }
        };
    }

    @NotNull
    public static <T> FileCodec<T> basicWithLocal(@NotNull Class<T> type, final @NotNull ConsumingSupplier<InputStream, T> streamReader, final @NotNull ConsumingSupplier<class_2960, T> locationReader, final @NotNull ConsumingSupplier<File, T> fileReader) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(streamReader);
        Objects.requireNonNull(fileReader);
        return new FileCodec<T>(){

            @Override
            @Nullable
            public T read(@NotNull InputStream in) {
                Objects.requireNonNull(in);
                return streamReader.get(in);
            }

            @Override
            @Nullable
            public T readLocation(@NotNull class_2960 location) {
                Objects.requireNonNull(location);
                return locationReader.get(location);
            }

            @Override
            @Nullable
            public T readLocal(@NotNull File file) {
                Objects.requireNonNull(file);
                return fileReader.get(file);
            }

            @Override
            @Nullable
            public T readWeb(@NotNull String fileUrl) {
                Objects.requireNonNull(fileUrl);
                InputStream in = WebUtils.openResourceStream(fileUrl);
                if (in != null) {
                    return streamReader.get(in);
                }
                return null;
            }
        };
    }

    @NotNull
    public static <T> FileCodec<T> basicWithWeb(@NotNull Class<T> type, final @NotNull ConsumingSupplier<InputStream, T> streamReader, final @NotNull ConsumingSupplier<class_2960, T> locationReader, final @NotNull ConsumingSupplier<String, T> urlReader) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(streamReader);
        Objects.requireNonNull(urlReader);
        return new FileCodec<T>(){

            @Override
            @Nullable
            public T read(@NotNull InputStream in) {
                Objects.requireNonNull(in);
                return streamReader.get(in);
            }

            @Override
            @Nullable
            public T readLocation(@NotNull class_2960 location) {
                Objects.requireNonNull(location);
                return locationReader.get(location);
            }

            @Override
            @Nullable
            public T readLocal(@NotNull File file) {
                Objects.requireNonNull(file);
                try {
                    return streamReader.get(new FileInputStream(file));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            @Override
            @Nullable
            public T readWeb(@NotNull String fileUrl) {
                Objects.requireNonNull(fileUrl);
                return urlReader.get(fileUrl);
            }
        };
    }

    @NotNull
    public static <T> FileCodec<T> advanced(@NotNull Class<T> type, final @NotNull ConsumingSupplier<InputStream, T> streamReader, final @NotNull ConsumingSupplier<class_2960, T> locationReader, final @NotNull ConsumingSupplier<File, T> fileReader, final @NotNull ConsumingSupplier<String, T> urlReader) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(streamReader);
        Objects.requireNonNull(fileReader);
        Objects.requireNonNull(urlReader);
        return new FileCodec<T>(){

            @Override
            @Nullable
            public T read(@NotNull InputStream in) {
                Objects.requireNonNull(in);
                return streamReader.get(in);
            }

            @Override
            @Nullable
            public T readLocation(@NotNull class_2960 location) {
                Objects.requireNonNull(location);
                return locationReader.get(location);
            }

            @Override
            @Nullable
            public T readLocal(@NotNull File file) {
                Objects.requireNonNull(file);
                return fileReader.get(file);
            }

            @Override
            @Nullable
            public T readWeb(@NotNull String fileUrl) {
                Objects.requireNonNull(fileUrl);
                return urlReader.get(fileUrl);
            }
        };
    }

    @Nullable
    public abstract T read(@NotNull InputStream var1);

    @Nullable
    public abstract T readLocation(@NotNull class_2960 var1);

    @Nullable
    public abstract T readLocal(@NotNull File var1);

    @Nullable
    public abstract T readWeb(@NotNull String var1);

    @Nullable
    public T read(@NotNull ResourceSource resourceSource) {
        Objects.requireNonNull(resourceSource);
        try {
            if (resourceSource.getSourceType() == ResourceSourceType.LOCATION) {
                class_2960 loc = class_2960.method_12829((String)resourceSource.getSourceWithoutPrefix());
                return loc != null ? (T)this.readLocation(loc) : null;
            }
            if (resourceSource.getSourceType() == ResourceSourceType.LOCAL) {
                return this.readLocal(new File(resourceSource.getSourceWithoutPrefix()));
            }
            if (resourceSource.getSourceType() == ResourceSourceType.WEB) {
                return this.readWeb(resourceSource.getSourceWithoutPrefix());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

