/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageVariablesScreen
extends ModernScreen {
    protected Consumer<List<Variable>> callback;
    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super((class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage", new Object[0]));
        this.callback = callback;
    }

    protected void method_25426() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 21, 66, this.field_22789 / 2 - 40 - 2, 18, (class_2561)Components.empty()){

            @Override
            public void method_25359(@NotNull class_4587 graphics, int mouseX, int mouseY, float partial) {
                super.method_25359(graphics, mouseX, mouseY, partial);
                if (this.method_1882().isBlank() && !this.method_25370()) {
                    GuiGraphics guiGraphics = GuiGraphics.currentGraphics();
                    class_2588 class_25882 = Components.translatable("fancymenu.variables.manage_variables.screen.search_variable", new Object[0]);
                    int n = this.getX() + 4;
                    int n2 = this.getY() + this.method_25364() / 2;
                    Objects.requireNonNull(this.font);
                    guiGraphics.drawString(this.font, (class_2561)class_25882, n, n2 - 9 / 2, UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt(), false);
                }
            }
        };
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateVariablesList());
        this.method_37063((class_364)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.variableListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.variableListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(90, true);
        int buttonWidth = this.field_22789 - 20 - (this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20));
        if (buttonWidth < 150) {
            buttonWidth = 150;
        }
        if (buttonWidth > 220) {
            buttonWidth = 220;
        }
        int doneButtonX = this.field_22789 - 20 - buttonWidth;
        int doneButtonY = this.field_22790 - 20 - 20;
        int toggleResetButtonX = doneButtonX;
        int toggleResetButtonY = doneButtonY - 15 - 20;
        int deleteButtonX = doneButtonX;
        int deleteButtonY = toggleResetButtonY - 5 - 20;
        int setValueButtonX = doneButtonX;
        int setValueButtonY = deleteButtonY - 5 - 20;
        int addButtonX = doneButtonX;
        int addButtonY = setValueButtonY - 15 - 20;
        ExtendedButton addVariableButton = new ExtendedButton(addButtonX, addButtonY, buttonWidth, 20, (class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.add_variable", new Object[0]), button -> {
            TextInputScreen s = new TextInputScreen((class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name", new Object[0]), CharacterFilter.buildOnlyLowercaseFileNameFilter(), call -> {
                if (call != null && !VariableHandler.variableExists(call)) {
                    VariableHandler.setVariable(call, "");
                    this.updateVariablesList();
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_37063((class_364)addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(addVariableButton);
        ExtendedButton setValueButton = new ExtendedButton(setValueButtonX, setValueButtonY, buttonWidth, 20, (class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.set_value", new Object[0]), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen((class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.set_value", new Object[0]), null, call -> {
                    if (call != null) {
                        e.variable.setValue((String)call);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                s.setText(e.variable.getValue());
                class_310.method_1551().method_1507((class_437)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.method_37063((class_364)setValueButton);
        UIBase.applyDefaultWidgetSkinTo(setValueButton);
        ExtendedButton deleteVariableButton = new ExtendedButton(deleteButtonX, deleteButtonY, buttonWidth, 20, (class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.delete_variable", new Object[0]), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariablesList();
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.method_37063((class_364)deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(deleteVariableButton);
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        ExtendedButton toggleResetOnLaunchButton = new ExtendedButton(toggleResetButtonX, toggleResetButtonY, buttonWidth, 20, (class_2561)Components.empty(), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                return enabledDisabled.getCycleComponent();
            }
            return resetOnLaunchDisabled.getCycleComponent();
        });
        this.method_37063((class_364)toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(toggleResetOnLaunchButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, buttonWidth, 20, (class_2561)Components.translatable("fancymenu.guicomponents.done", new Object[0]), button -> this.callback.accept(VariableHandler.getVariables()));
        this.method_37063((class_364)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        this.updateVariablesList();
    }

    public void method_25419() {
        this.callback.accept(VariableHandler.getVariables());
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.drawString(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.field_22793, (class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.variables", new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.variableListScrollArea.render(graphics, mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Nullable
    protected VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            VariableScrollEntry s;
            if (!(e instanceof VariableScrollEntry) || !(s = (VariableScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected boolean variableFitsSearchValue(@NotNull Variable variable, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (variable.getName().toLowerCase().contains(s)) {
            return true;
        }
        return variable.getValue().toLowerCase().contains(s);
    }

    protected void updateVariablesList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.variableListScrollArea.clearEntries();
        for (Variable v : VariableHandler.getVariables()) {
            if (!this.variableFitsSearchValue(v, searchValue)) continue;
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, entry -> {});
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, (class_2561)Components.translatable("fancymenu.overlay.menu_bar.variables.manage.no_variables", new Object[0]).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    public static class VariableScrollEntry
    extends TextListScrollAreaEntry {
        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (class_2561)Components.literal(variable.name).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852((class_2561)Components.literal(" (" + variable.value + ")").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()))), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }
    }
}

